/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.HotPouredGlassBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;

public class HotPouredGlassBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.hot_poured_glass");
    private int capacity = 0;
    private boolean isInitialTransition = true;
    private int animationTicks = 0;
    private boolean initialized = false;

    public static void tick(Level level, BlockPos pos, BlockState state, HotPouredGlassBlockEntity glass) {
        glass.checkForLastTickSync();
        if (!glass.initialized) {
            return;
        }
        if (glass.animationTicks > 0) {
            --glass.animationTicks;
        } else if (glass.isInitialTransition) {
            glass.isInitialTransition = false;
            if (glass.capacity > 0) {
                HotPouredGlassBlockEntity.doFloodFill(level, pos, state, glass);
                glass.capacity = 0;
            }
            glass.markForSync();
        } else {
            level.m_46597_(pos, glass.getInternalBlock());
            Helpers.playSound(level, pos, SoundEvents.f_11937_);
            RandomSource random = level.m_213780_();
            Supplier<Vec3> supplier = () -> new Vec3(Mth.m_216263_((RandomSource)level.m_213780_(), (double)-0.005f, (double)0.005f), Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f));
            ParticleUtils.m_216318_((Level)level, (BlockPos)pos.m_7495_(), (ParticleOptions)ParticleTypes.f_123762_, (IntProvider)UniformInt.m_146622_((int)4, (int)10), (Direction)Direction.UP, supplier, (double)0.6);
        }
    }

    private static void doFloodFill(Level level, BlockPos pos, BlockState state, HotPouredGlassBlockEntity center) {
        if (level.f_46443_) {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        Object2IntOpenHashMap filled = new Object2IntOpenHashMap();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        filled.put((Object)pos, 0);
        record Path(BlockPos pos, int cost) {
        }
        queue.add(new Path(pos, 0));
        int maxCost = -1;
        int capacity = center.capacity;
        while (!queue.isEmpty()) {
            Path current = (Path)queue.remove();
            if (--capacity >= 0 && current.cost > maxCost) {
                maxCost = current.cost;
            }
            if (capacity <= 0 && current.cost > maxCost) break;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                cursor.m_122159_((Vec3i)current.pos, direction);
                if (filled.containsKey((Object)cursor) || !HotPouredGlassBlockEntity.canFloodFillAt(level, cursor)) continue;
                BlockPos posNext = cursor.m_7949_();
                queue.add(new Path(posNext, current.cost + 1));
                filled.put((Object)posNext, current.cost + 1);
            }
        }
        filled.object2IntEntrySet().stream().sorted(Comparator.comparingInt(Object2IntMap.Entry::getIntValue).thenComparing(e -> ((BlockPos)e.getKey()).m_123331_((Vec3i)pos))).limit(16L).forEach(entry -> {
            BlockPos fillPos = (BlockPos)entry.getKey();
            int cost = entry.getIntValue();
            level.m_46597_(fillPos, (BlockState)state.m_61124_((Property)HotPouredGlassBlock.FLAT, (Comparable)Boolean.valueOf(true)));
            BlockEntity patt4799$temp = level.m_7702_(fillPos);
            if (patt4799$temp instanceof HotPouredGlassBlockEntity) {
                HotPouredGlassBlockEntity side = (HotPouredGlassBlockEntity)patt4799$temp;
                side.isInitialTransition = false;
                side.animationTicks = 40 + cost * 10;
                side.initialized = true;
                side.capacity = 0;
                side.setGlassItem(center.getGlassItem().m_41777_());
                side.markForSync();
            }
        });
    }

    private static boolean canFloodFillAt(Level level, BlockPos.MutableBlockPos cursor) {
        if (level.m_8055_((BlockPos)cursor).m_60795_()) {
            cursor.m_122173_(Direction.DOWN);
            if (Helpers.isBlock(level.m_8055_((BlockPos)cursor), TFCTags.Blocks.GLASS_POURING_TABLE)) {
                cursor.m_122173_(Direction.UP);
                return true;
            }
            cursor.m_122173_(Direction.UP);
        }
        return false;
    }

    public HotPouredGlassBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.HOT_POURED_GLASS.get(), pos, state);
    }

    public HotPouredGlassBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, HotPouredGlassBlockEntity.defaultInventory(1), NAME);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.capacity = nbt.m_128451_("capacity");
        this.isInitialTransition = nbt.m_128471_("isInitialTransition");
        this.animationTicks = nbt.m_128451_("animationTicks");
        this.initialized = nbt.m_128471_("initialized");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("capacity", this.capacity);
        nbt.m_128379_("isInitialTransition", this.isInitialTransition);
        nbt.m_128405_("animationTicks", this.animationTicks);
        nbt.m_128379_("initialized", this.initialized);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof BlockItem;
    }

    public void setGlassItem(ItemStack stack) {
        ((ItemStackHandler)this.inventory).setStackInSlot(0, stack);
    }

    public void flattenFirstBlock() {
        this.animationTicks = 20;
        this.initialized = true;
        this.capacity = 15;
        this.markForSync();
    }

    private ItemStack getGlassItem() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0);
    }

    private BlockState getInternalBlock() {
        return ((BlockItem)((ItemStackHandler)this.inventory).getStackInSlot(0).m_41720_()).m_40614_().m_49966_();
    }

    public boolean isInitialTransition() {
        return this.isInitialTransition;
    }

    public int getAnimationTicks() {
        return this.animationTicks;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

