/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 8;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.grill");
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[5];

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.GRILL.get(), pos, state, GrillBlockEntity.defaultInventory(9), NAME);
        if (((Boolean)TFCConfig.SERVER.firePitEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(3).extract(4, 5, 6, 7, 8), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).insert(4, 5, 6, 7, 8), Direction.UP);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInv, Player player) {
        return GrillContainer.create(this, playerInv, windowID);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= 4 && slot <= 8) {
            return HeatCapability.maybeHas(stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    protected void handleCooking() {
        assert (this.f_58857_ != null);
        for (int slot = 4; slot <= 8; ++slot) {
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
            if (inputHeat == null) continue;
            HeatCapability.addTemp(inputHeat, this.temperature);
            HeatingRecipe recipe = this.cachedRecipes[slot - 4];
            if (recipe == null || !recipe.isValidTemperature(inputHeat.getTemperature())) continue;
            ItemStack output = recipe.assemble(new ItemStackInventory(inputStack), this.f_58857_.m_9598_());
            FoodCapability.applyTrait(output, FoodTraits.WOOD_GRILLED);
            FoodCapability.updateFoodDecayOnCreate(output);
            ((ItemStackHandler)this.inventory).setStackInSlot(slot, output);
            this.markForSync();
        }
    }

    @Override
    protected void coolInstantly() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            HeatCapability.setTemperature(stack, 0.0f);
        }
    }

    @Override
    protected void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        for (int slot = 4; slot <= 8; ++slot) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            this.cachedRecipes[slot - 4] = stack.m_41619_() ? null : HeatingRecipe.getRecipe(new ItemStackInventory(stack));
        }
    }
}

