/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.BlastFurnaceContainer;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IntArrayBuilder;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceBlockEntity
extends TickableInventoryBlockEntity<BlastFurnaceInventory>
implements ICalendarTickable {
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.blast_furnace");
    private final List<ItemStack> inputStacks;
    private final List<HeatingRecipe> inputCachedRecipes;
    private final List<ItemStack> catalystStacks;
    private final List<ItemStack> fuelStacks;
    private final IntArrayBuilder syncedData;
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory;
    private final FluidTank outputFluidTank;
    private FluidStack inputFluid;
    @Nullable
    private BlastFurnaceRecipe cachedRecipe;
    private float temperature;
    private int burnTicks;
    private float burnTemperature;
    private int airTicks;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private int lastKnownCapacity;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlastFurnaceBlockEntity entity) {
        entity.checkForLastTickSync();
        entity.checkForCalendarUpdate();
        if (level.m_46467_() % 20L == 0L) {
            int capacity = entity.calculateCapacity();
            boolean modified = entity.inputStacks.size() > capacity || entity.catalystStacks.size() > capacity || entity.fuelStacks.size() > capacity;
            entity.popItemsOffOverCapacity(entity.inputStacks, capacity);
            entity.popItemsOffOverCapacity(entity.catalystStacks, capacity);
            entity.popItemsOffOverCapacity(entity.fuelStacks, capacity);
            if (modified) {
                if (((Boolean)state.m_61143_((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
                    state = (BlockState)state.m_61124_((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false));
                    level.m_46597_(pos, state);
                }
                entity.markForSync();
            }
            entity.addItemsFromWorld(capacity);
            MoltenBlock.manageMoltenBlockTower(level, entity.f_58858_.m_7494_(), (Boolean)state.m_61143_((Property)BloomeryBlock.LIT), (Integer)TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get(), entity.inputStacks.size() + entity.fuelStacks.size(), 2 * (Integer)TFCConfig.SERVER.blastFurnaceCapacity.get());
        }
        if (((Boolean)state.m_61143_((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
            if (entity.burnTicks > 0) {
                entity.burnTicks = entity.burnTicks - (Integer)TFCConfig.SERVER.blastFurnaceFuelConsumptionMultiplier.get() * (entity.airTicks > 0 ? 2 : 1);
            }
            if (entity.burnTicks <= 0 && !entity.consumeFuel()) {
                entity.extinguish(state);
            }
        } else if (entity.burnTemperature > 0.0f) {
            entity.extinguish(state);
        }
        if (entity.airTicks > 0) {
            ItemStack tuyere;
            if (entity.airTicks % 20 == 0 && entity.temperature > 400.0f && !(tuyere = ((BlastFurnaceInventory)entity.inventory).getStackInSlot(0)).m_41619_()) {
                Helpers.damageItem(tuyere, 1);
            }
            --entity.airTicks;
        }
        if (entity.temperature > 0.0f || entity.burnTemperature > 0.0f) {
            entity.temperature = HeatCapability.adjustDeviceTemp(entity.temperature, entity.burnTemperature, entity.airTicks, false);
            entity.ensureCachedRecipesAreAligned();
            ArrayList<FluidStack> newInputFluids = new ArrayList<FluidStack>();
            Iterator<ItemStack> inputIterator = entity.inputStacks.iterator();
            Iterator<ItemStack> catalystIterator = entity.catalystStacks.iterator();
            Iterator<HeatingRecipe> recipeIterator = entity.inputCachedRecipes.iterator();
            while (inputIterator.hasNext()) {
                ItemStack inputStack = inputIterator.next();
                ItemStack catalystStack = catalystIterator.next();
                HeatingRecipe inputRecipe = recipeIterator.next();
                @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
                if (inputHeat == null) continue;
                HeatCapability.addTemp(inputHeat, entity.temperature);
                if (inputRecipe == null || !inputRecipe.isValidTemperature(inputHeat.getTemperature())) continue;
                FluidStack fluidStack = inputRecipe.assembleFluid(new ItemStackInventory(inputStack));
                newInputFluids.add(fluidStack);
                inputIterator.remove();
                catalystIterator.remove();
                recipeIterator.remove();
            }
            if (!newInputFluids.isEmpty()) {
                for (FluidStack newInputFluid : newInputFluids) {
                    entity.insertOrReplaceInputFluid(newInputFluid);
                }
                BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(level, entity.inputFluid);
                if (recipe != null) {
                    FluidStack newOutputFluid = recipe.assembleFluidOutput(entity.inputFluid);
                    entity.outputFluidTank.fill(newOutputFluid, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            entity.markForSync();
        }
        if (!entity.outputFluidTank.isEmpty()) {
            IFluidHandler belowFluidHandler;
            BlockEntity below = level.m_7702_(pos.m_7495_());
            if (below != null && (belowFluidHandler = (IFluidHandler)below.getCapability(Capabilities.FLUID).resolve().orElse(null)) != null && FluidHelpers.transferExact((IFluidHandler)entity.outputFluidTank, belowFluidHandler, 1)) {
                below.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> cap.setTemperatureIfWarmer(entity.temperature));
            }
            entity.markForSync();
        }
        entity.m_6596_();
    }

    public BlastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get(), pos, state, BlastFurnaceInventory::new, NAME);
        this.inputStacks = new ArrayList<ItemStack>();
        this.inputCachedRecipes = new ArrayList<HeatingRecipe>();
        this.catalystStacks = new ArrayList<ItemStack>();
        this.fuelStacks = new ArrayList<ItemStack>();
        this.inputFluid = FluidStack.EMPTY;
        this.outputFluidTank = new FluidTank(((Integer)TFCConfig.SERVER.blastFurnaceFluidCapacity.get()).intValue());
        this.syncedData = new IntArrayBuilder().add(() -> this.lastKnownCapacity, value -> {
            this.lastKnownCapacity = value;
        }).add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
        this.sidedFluidInventory = new SidedHandler.Builder<IFluidHandler>((IFluidHandler)this.inventory);
        if (((Boolean)TFCConfig.SERVER.blastFurnaceEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(this.inventory, side -> true);
            this.sidedFluidInventory.on((IFluidHandler)new PartialFluidHandler((IFluidHandler)this.inventory).extract(), side -> true);
        }
    }

    public int getCapacity() {
        return this.lastKnownCapacity;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public int getInputCount() {
        return this.inputStacks.size();
    }

    public int getFuelCount() {
        return this.fuelStacks.size();
    }

    public int getCatalystCount() {
        return this.catalystStacks.size();
    }

    public float getTemperature() {
        return this.temperature;
    }

    public ContainerData getSyncedData() {
        return this.syncedData;
    }

    public boolean hasTuyere() {
        return !((BlastFurnaceInventory)this.inventory).getStackInSlot(0).m_41619_();
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    public boolean light(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
            return true;
        }
        if (!this.fuelStacks.isEmpty()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        Helpers.readItemStacksFromNbt(this.inputStacks, nbt.m_128437_("inputStacks", 10));
        Helpers.readItemStacksFromNbt(this.catalystStacks, nbt.m_128437_("catalystStacks", 10));
        Helpers.readItemStacksFromNbt(this.fuelStacks, nbt.m_128437_("fuelStacks", 10));
        this.inputFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("inputFluid"));
        this.outputFluidTank.readFromNBT(nbt.m_128469_("outputFluidTank"));
        this.temperature = nbt.m_128457_("temperature");
        this.burnTicks = nbt.m_128451_("burnTicks");
        this.airTicks = nbt.m_128451_("airTicks");
        this.burnTemperature = nbt.m_128457_("burnTemperature");
        this.lastPlayerTick = nbt.m_128454_("lastPlayerTick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inputStacks", (Tag)Helpers.writeItemStacksToNbt(this.inputStacks));
        nbt.m_128365_("catalystStacks", (Tag)Helpers.writeItemStacksToNbt(this.catalystStacks));
        nbt.m_128365_("fuelStacks", (Tag)Helpers.writeItemStacksToNbt(this.fuelStacks));
        nbt.m_128365_("inputFluid", (Tag)this.inputFluid.writeToNBT(new CompoundTag()));
        nbt.m_128365_("outputFluidTank", (Tag)this.outputFluidTank.writeToNBT(new CompoundTag()));
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128405_("burnTicks", this.burnTicks);
        nbt.m_128405_("airTicks", this.airTicks);
        nbt.m_128350_("burnTemperature", this.burnTemperature);
        nbt.m_128356_("lastPlayerTick", this.lastPlayerTick);
        super.m_183515_(nbt);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.burnTicks, this.burnTemperature, this.fuelStacks);
        this.burnTicks = remainder.burnTicks();
        this.burnTemperature = remainder.burnTemperature();
        if (remainder.ticks() > 0L) {
            this.extinguish(this.m_58900_());
            for (ItemStack stack : this.inputStacks) {
                HeatCapability.setTemperature(stack, 0.0f);
            }
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return BlastFurnaceContainer.create(this, inventory, containerId);
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.TUYERES);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCapabilities() {
        this.sidedInventory.invalidate();
        this.sidedFluidInventory.invalidate();
    }

    @Override
    public void ejectInventory() {
        super.ejectInventory();
        this.dumpItems();
        this.destroyMolten();
    }

    private void dumpItems() {
        assert (this.f_58857_ != null);
        BlockPos pos = this.f_58858_.m_7494_();
        this.inputStacks.forEach(stack -> Helpers.spawnDropsAtExactCenter(this.f_58857_, pos, stack));
        this.catalystStacks.forEach(stack -> Helpers.spawnDropsAtExactCenter(this.f_58857_, pos, stack));
        this.fuelStacks.forEach(stack -> Helpers.spawnDropsAtExactCenter(this.f_58857_, pos, stack));
        this.cachedRecipe = null;
    }

    private void insertOrReplaceInputFluid(FluidStack newFluid) {
        this.inputFluid = this.insertOrReplaceFluid(newFluid, this.inputFluid);
    }

    private FluidStack insertOrReplaceFluid(FluidStack newFluid, FluidStack currentFluid) {
        if (currentFluid.isEmpty()) {
            return newFluid;
        }
        if (currentFluid.getFluid() == newFluid.getFluid()) {
            currentFluid.grow(newFluid.getAmount());
            return currentFluid;
        }
        return newFluid;
    }

    private void popItemsOffOverCapacity(List<ItemStack> items, int capacity) {
        assert (this.f_58857_ != null);
        while (items.size() > capacity) {
            Helpers.spawnItem(this.f_58857_, this.f_58858_, items.remove(items.size() - 1));
        }
    }

    private void ensureCachedRecipesAreAligned() {
        if (this.inputStacks.size() != this.inputCachedRecipes.size()) {
            this.inputCachedRecipes.clear();
            for (ItemStack inputStack : this.inputStacks) {
                this.inputCachedRecipes.add(HeatingRecipe.getRecipe(inputStack));
            }
        }
    }

    private boolean consumeFuel() {
        if (this.fuelStacks.isEmpty()) {
            return false;
        }
        ItemStack fuelStack = this.fuelStacks.get(0);
        if (!fuelStack.m_41619_()) {
            this.fuelStacks.remove(0);
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.getDuration();
                this.burnTemperature = fuel.getTemperature();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    public void extinguish(BlockState state) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)));
        this.burnTicks = 0;
        this.burnTemperature = 0.0f;
        this.markForSync();
    }

    private void addItemsFromWorld(int capacity) {
        assert (this.f_58857_ != null);
        this.updateCachedRecipe();
        if (this.cachedRecipe == null && !this.inputStacks.isEmpty()) {
            this.dumpItems();
            this.markForSync();
        }
        if (this.inputStacks.size() == capacity && this.fuelStacks.size() == capacity) {
            return;
        }
        List items = this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_7918_(1, BlastFurnaceBlock.getChimneyLevels(this.f_58857_, this.f_58858_) + 2, 1)), EntitySelector.f_20402_);
        if (this.cachedRecipe == null) {
            for (ItemEntity entity : items) {
                ItemStack stack = entity.m_32055_();
                BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(this.f_58857_, stack);
                if (recipe == null) continue;
                this.cachedRecipe = recipe;
                this.markForSync();
                break;
            }
        }
        if (this.cachedRecipe != null) {
            ArrayList<ItemEntity> foundInputs = new ArrayList<ItemEntity>();
            ArrayList<ItemEntity> foundCatalysts = new ArrayList<ItemEntity>();
            ArrayList<ItemEntity> foundFuels = new ArrayList<ItemEntity>();
            int inputCount = 0;
            int catalystCount = 0;
            int fuelCount = 0;
            for (ItemEntity entity : items) {
                ItemStack stack = entity.m_32055_();
                if (this.cachedRecipe.matchesInput(stack)) {
                    foundInputs.add(entity);
                    inputCount += stack.m_41613_();
                    continue;
                }
                if (this.cachedRecipe.matchesCatalyst(stack)) {
                    foundCatalysts.add(entity);
                    catalystCount += stack.m_41613_();
                    continue;
                }
                if (!Helpers.isItem(stack, TFCTags.Items.BLAST_FURNACE_FUEL)) continue;
                foundFuels.add(entity);
                fuelCount += stack.m_41613_();
            }
            int totalInsertCapacity = IntStream.of(capacity - this.inputStacks.size(), inputCount, catalystCount).min().orElse(0);
            Helpers.consumeItemsFromEntitiesIndividually(foundInputs, totalInsertCapacity, this.inputStacks::add);
            Helpers.consumeItemsFromEntitiesIndividually(foundCatalysts, totalInsertCapacity, this.catalystStacks::add);
            int totalFuelCapacity = Math.min(capacity - this.fuelStacks.size(), fuelCount);
            Helpers.consumeItemsFromEntitiesIndividually(foundFuels, totalFuelCapacity, this.fuelStacks::add);
            this.markForSync();
        }
    }

    private void destroyMolten() {
        assert (this.f_58857_ != null);
        MoltenBlock.removeMoltenBlockTower(this.f_58857_, this.f_58858_.m_7494_(), (Integer)TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get());
    }

    private int calculateCapacity() {
        assert (this.f_58857_ != null);
        this.lastKnownCapacity = BlastFurnaceBlock.getChimneyLevels(this.f_58857_, this.f_58858_) * (Integer)TFCConfig.SERVER.blastFurnaceCapacity.get();
        return this.lastKnownCapacity;
    }

    private void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = !this.inputStacks.isEmpty() ? BlastFurnaceRecipe.get(this.f_58857_, this.inputStacks.get(0)) : null;
    }

    static class BlastFurnaceInventory
    extends ItemStackHandler
    implements BlastFurnaceRecipe.Inventory,
    DelegateFluidHandler {
        private final BlastFurnaceBlockEntity blastFurnace;

        BlastFurnaceInventory(InventoryBlockEntity<?> entity) {
            super(1);
            this.blastFurnace = (BlastFurnaceBlockEntity)entity;
        }

        @Override
        public FluidStack getFluid() {
            return this.blastFurnace.inputFluid;
        }

        @Override
        public ItemStack getCatalyst() {
            return this.blastFurnace.catalystStacks.isEmpty() ? ItemStack.f_41583_ : this.blastFurnace.catalystStacks.get(0);
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.blastFurnace.outputFluidTank;
        }
    }
}

