/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BerryBushBlockEntity
extends TFCBlockEntity
implements ICalendarTickable {
    private long lastTick = Integer.MIN_VALUE;
    private long lastUpdateTick = Calendars.SERVER.getTicks();

    public static void serverTick(Level level, BlockPos pos, BlockState state, BerryBushBlockEntity bush) {
        bush.checkForCalendarUpdate();
    }

    public BerryBushBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.BERRY_BUSH.get(), pos, state);
    }

    protected BerryBushBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public long getTicksSinceBushUpdate() {
        return Calendars.SERVER.getTicks() - this.lastUpdateTick;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.lastUpdateTick = nbt.m_128454_("lastUpdateTick");
        this.lastTick = nbt.m_128454_("lastTick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("lastUpdateTick", this.lastUpdateTick);
        nbt.m_128356_("lastTick", this.lastTick);
        super.m_183515_(nbt);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        BlockState state;
        Block block;
        if (this.f_58857_ != null && ticks >= 24000L && (block = (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_()) instanceof IBushBlock) {
            IBushBlock bush = (IBushBlock)block;
            bush.onUpdate(this.f_58857_, this.f_58858_, state);
            this.lastUpdateTick = Calendars.SERVER.getTicks();
            this.m_6596_();
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastTick = tick;
    }

    public void setLastBushTick(long ticks) {
        this.lastUpdateTick = ticks;
    }
}

