/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BarrelInventoryCallback;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockEntity
extends TickableInventoryBlockEntity<BarrelInventory>
implements ICalendarTickable,
BarrelInventoryCallback {
    public static final int SLOT_FLUID_CONTAINER_IN = 0;
    public static final int SLOT_FLUID_CONTAINER_OUT = 1;
    public static final int SLOT_ITEM = 2;
    public static final int SLOTS = 3;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.barrel");
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory;
    @Nullable
    private ResourceLocation recipeName;
    @Nullable
    private SealedBarrelRecipe recipe;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private long sealedTick;
    private long recipeTick;
    private int soundCooldownTicks = 0;
    @Nullable
    private BlockPos pourPos = null;
    private boolean needsInstantRecipeUpdate;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BarrelBlockEntity barrel) {
        List<ItemStack> excess;
        if (barrel.recipeName != null) {
            barrel.recipe = level.m_7465_().m_44043_(barrel.recipeName).map(b -> {
                SealedBarrelRecipe r;
                return b instanceof SealedBarrelRecipe ? (r = (SealedBarrelRecipe)b) : null;
            }).orElse(null);
            barrel.recipeName = null;
        }
        barrel.checkForLastTickSync();
        barrel.checkForCalendarUpdate();
        if (level.m_46467_() % 5L == 0L) {
            barrel.updateFluidIOSlots();
        }
        if (!(excess = ((BarrelInventory)barrel.inventory).excess).isEmpty() && ((BarrelInventory)barrel.inventory).getStackInSlot(2).m_41619_()) {
            ((BarrelInventory)barrel.inventory).setStackInSlot(2, excess.remove(0));
        }
        SealedBarrelRecipe recipe = barrel.recipe;
        boolean sealed = (Boolean)state.m_61143_((Property)BarrelBlock.SEALED);
        Direction facing = (Direction)state.m_61143_(BarrelBlock.FACING);
        if (recipe != null && sealed) {
            int durationSealed = (int)(Calendars.SERVER.getTicks() - barrel.recipeTick);
            if (!recipe.isInfinite() && durationSealed > recipe.getDuration()) {
                if (recipe.matches((net.dries007.tfc.common.recipes.inventory.BarrelInventory)barrel.inventory, level)) {
                    recipe.assembleOutputs((net.dries007.tfc.common.recipes.inventory.BarrelInventory)barrel.inventory);
                    Helpers.playSound(level, barrel.m_58899_(), recipe.getCompleteSound());
                }
                barrel.updateRecipe();
                barrel.markForSync();
                SealedBarrelRecipe knownRecipe = barrel.recipe;
                if (knownRecipe != null) {
                    knownRecipe.onSealed((net.dries007.tfc.common.recipes.inventory.BarrelInventory)barrel.inventory);
                }
            }
        }
        if (barrel.needsInstantRecipeUpdate) {
            barrel.needsInstantRecipeUpdate = false;
            if (((BarrelInventory)barrel.inventory).excess.isEmpty()) {
                RecipeManager recipeManager = level.m_7465_();
                Optional.empty().or(() -> recipeManager.m_44015_((RecipeType)TFCRecipeTypes.BARREL_INSTANT.get(), (Container)((net.dries007.tfc.common.recipes.inventory.BarrelInventory)barrel.inventory), level)).or(() -> recipeManager.m_44015_((RecipeType)TFCRecipeTypes.BARREL_INSTANT_FLUID.get(), (Container)((net.dries007.tfc.common.recipes.inventory.BarrelInventory)barrel.inventory), level)).ifPresent(instantRecipe -> {
                    instantRecipe.assembleOutputs((net.dries007.tfc.common.recipes.inventory.BarrelInventory)barrel.inventory);
                    if (barrel.soundCooldownTicks == 0) {
                        Helpers.playSound(level, barrel.m_58899_(), instantRecipe.getCompleteSound());
                        barrel.soundCooldownTicks = 5;
                        if (instantRecipe.getCompleteSound() == SoundEvents.f_11937_ && level instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)level;
                            double x = (double)pos.m_123341_() + 0.5;
                            double y = pos.m_123342_();
                            double z = (double)pos.m_123343_() + 0.5;
                            RandomSource random = level.m_213780_();
                            server.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.BUBBLE.get()), x + (double)random.m_188501_() * 0.375 - 0.1875, y + 0.9375, z + (double)random.m_188501_() * 0.375 - 0.1875, 6, 0.0, 0.0, 0.0, 1.0);
                            server.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.STEAM.get()), x + (double)random.m_188501_() * 0.375 - 0.1875, y + 0.9375, z + (double)random.m_188501_() * 0.375 - 0.1875, 6, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                });
                barrel.markForSync();
            }
        }
        if (barrel.soundCooldownTicks > 0) {
            --barrel.soundCooldownTicks;
        }
        if (level.m_46467_() % 20L == 0L && !sealed && facing == Direction.UP) {
            Helpers.gatherAndConsumeItems(level, new AABB(0.25, 0.0625, 0.25, 0.75, 0.9375, 0.75).m_82338_(pos), (IItemHandler)barrel.inventory, 2, 2);
        }
        barrel.tickPouring(level, pos, sealed, facing);
        if (!sealed && facing == Direction.UP && level.m_46467_() % 4L == 0L && level.m_46758_(pos.m_7494_())) {
            ((BarrelInventory)barrel.inventory).fill(new FluidStack((Fluid)Fluids.f_76193_, 1), IFluidHandler.FluidAction.EXECUTE);
            barrel.markForSync();
        }
    }

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BARREL.get(), pos, state, BarrelInventory::new, NAME);
        this.sidedFluidInventory = new SidedHandler.Builder<IFluidHandler>((IFluidHandler)this.inventory);
        if (((Boolean)TFCConfig.SERVER.barrelEnableAutomation.get()).booleanValue()) {
            Direction facing = state.m_61138_(BarrelBlock.FACING) ? (Direction)state.m_61143_(BarrelBlock.FACING) : Direction.UP;
            boolean vertical = facing == Direction.UP;
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0).extract(1), (Predicate<Direction>)(vertical ? Direction.Plane.HORIZONTAL : d -> d.m_122434_() != facing.m_122434_() && d.m_122434_().m_122479_())).on(new PartialItemHandler(this.inventory).insert(2), facing).on(new PartialItemHandler(this.inventory).extract(2), facing.m_122424_());
            this.sidedFluidInventory.on((IFluidHandler)new PartialFluidHandler((IFluidHandler)this.inventory).insert(), vertical ? Direction.UP : facing.m_122424_()).on((IFluidHandler)new PartialFluidHandler((IFluidHandler)this.inventory).extract(), vertical ? d -> d != Direction.UP : d -> d == facing);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return BarrelContainer.create(this, player.m_150109_(), containerId);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsInstantRecipeUpdate = true;
        this.updateRecipe();
    }

    @Override
    public void fluidTankChanged() {
        this.needsInstantRecipeUpdate = true;
        this.updateRecipe();
        this.m_6596_();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> Helpers.mightHaveCapability(stack, Capabilities.FLUID_ITEM);
            case 2 -> {
                IItemSize size = ItemSizeManager.get(stack);
                if (size.getSize(stack).isSmallerThan(Size.HUGE) || size.getWeight(stack).isSmallerThan(Weight.VERY_HEAVY)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        try (CalendarTransaction tr = Calendars.SERVER.transaction();){
            tr.add(-ticks);
            this.updateRecipe();
        }
        if (!((Boolean)this.m_58900_().m_61143_((Property)BarrelBlock.SEALED)).booleanValue() || this.recipe == null || this.recipe.isInfinite()) {
            return;
        }
        long currentTick = Calendars.SERVER.getTicks();
        for (long lastKnownTick = this.recipeTick + (long)this.recipe.getDuration(); lastKnownTick < currentTick; lastKnownTick += (long)this.recipe.getDuration()) {
            long offset = currentTick - lastKnownTick;
            assert (offset >= 0L);
            try (CalendarTransaction tr = Calendars.SERVER.transaction();){
                tr.add(-offset);
                SealedBarrelRecipe recipe = this.recipe;
                if (((BarrelRecipe)recipe).matches((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory, null)) {
                    recipe.assembleOutputs((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory);
                }
                this.updateRecipe();
                this.markForSync();
            }
            SealedBarrelRecipe knownRecipe = this.recipe;
            if (knownRecipe == null) {
                return;
            }
            knownRecipe.onSealed((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory);
            if (!knownRecipe.isInfinite()) continue;
            return;
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("lastUpdateTick", this.lastUpdateTick);
        nbt.m_128356_("sealedTick", this.sealedTick);
        nbt.m_128356_("recipeTick", this.recipeTick);
        if (this.recipe != null) {
            nbt.m_128359_("recipe", this.recipe.m_6423_().toString());
        } else if (this.recipeName != null) {
            nbt.m_128359_("recipeName", this.recipeName.toString());
        }
        super.m_183515_(nbt);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.lastUpdateTick = nbt.m_128454_("lastUpdateTick");
        this.sealedTick = nbt.m_128454_("sealedTick");
        this.recipeTick = nbt.m_128454_("recipeTick");
        this.recipe = null;
        this.recipeName = null;
        if (nbt.m_128425_("recipe", 8)) {
            this.recipeName = Helpers.resourceLocation(nbt.m_128461_("recipe"));
            if (this.f_58857_ != null) {
                this.recipe = this.f_58857_.m_7465_().m_44043_(this.recipeName).map(b -> {
                    SealedBarrelRecipe r;
                    return b instanceof SealedBarrelRecipe ? (r = (SealedBarrelRecipe)b) : null;
                }).orElse(null);
            }
        }
        super.loadAdditional(nbt);
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    public void ejectInventory() {
        super.ejectInventory();
        assert (this.f_58857_ != null);
        ((BarrelInventory)this.inventory).excess.stream().filter(item -> !item.m_41619_()).forEach(item -> Helpers.spawnItem(this.f_58857_, this.f_58858_, item));
    }

    public void tickPouring(Level level, BlockPos pos, boolean sealed, Direction facing) {
        BlockPos pourPos;
        BlockEntity blockEntity;
        BlockPos faucetPos;
        if (level.m_46467_() % 20L == 0L && !sealed && !((BarrelInventory)this.inventory).tank.isEmpty() && facing != Direction.UP && level.m_8055_(faucetPos = pos.m_121945_(facing)).m_60795_() && (blockEntity = level.m_7702_(pourPos = faucetPos.m_7495_())) != null) {
            blockEntity.getCapability(Capabilities.FLUID, Direction.UP).ifPresent(cap -> {
                if (FluidHelpers.couldTransferExact((IFluidHandler)((BarrelInventory)this.inventory).tank, cap, 1)) {
                    this.pourPos = pourPos;
                }
            });
        }
        if (this.pourPos != null && !sealed) {
            BlockEntity blockEntity2 = level.m_7702_(this.pourPos);
            if (blockEntity2 != null) {
                Fluid fluid = ((BarrelInventory)this.inventory).tank.getFluid().getFluid();
                if (blockEntity2.getCapability(Capabilities.FLUID, Direction.UP).map(cap -> FluidHelpers.transferExact((IFluidHandler)((BarrelInventory)this.inventory).tank, cap, 1)).orElse(false).booleanValue()) {
                    if (level.m_46467_() % 12L == 0L && level instanceof ServerLevel) {
                        double dx;
                        ServerLevel server = (ServerLevel)level;
                        double offset = 0.6;
                        double d = facing.m_122429_() > 0 ? 0.6 : (dx = facing.m_122429_() < 0 ? -0.6 : 0.0);
                        double dz = facing.m_122431_() > 0 ? 0.6 : (facing.m_122431_() < 0 ? -0.6 : 0.0);
                        double x = (double)((float)pos.m_123341_() + 0.5f) + dx;
                        double y = (float)pos.m_123342_() + 0.125f;
                        double z = (double)((float)pos.m_123343_() + 0.5f) + dz;
                        Helpers.playSound(level, pos, (SoundEvent)TFCSounds.BARREL_DRIP.get());
                        server.m_8767_((ParticleOptions)new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.BARREL_DRIP.get()), fluid), x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
                    }
                } else {
                    this.pourPos = null;
                }
            } else {
                this.pourPos = null;
            }
        }
    }

    public void onSeal() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            for (int slot : new int[]{0, 1}) {
                Helpers.spawnItem(this.f_58857_, this.f_58858_, ((BarrelInventory)this.inventory).getStackInSlot(slot));
                ((BarrelInventory)this.inventory).setStackInSlot(slot, ItemStack.f_41583_);
            }
        }
        this.sealedTick = Calendars.get((LevelReader)this.f_58857_).getTicks();
        this.updateRecipe();
        if (this.recipe != null) {
            this.recipe.onSealed((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory);
            this.recipeTick = this.sealedTick;
        }
        this.markForSync();
        Helpers.playSound(this.f_58857_, this.f_58858_, (SoundEvent)TFCSounds.CLOSE_BARREL.get());
    }

    public void onUnseal() {
        assert (this.f_58857_ != null);
        this.recipeTick = 0L;
        this.sealedTick = 0L;
        if (this.recipe != null) {
            this.recipe.onUnsealed((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory);
        }
        this.updateRecipe();
        this.markForSync();
        Helpers.playSound(this.f_58857_, this.f_58858_, (SoundEvent)TFCSounds.OPEN_BARREL.get());
    }

    @Override
    public boolean canModify() {
        return (Boolean)this.m_58900_().m_61143_((Property)BarrelBlock.SEALED) == false;
    }

    protected void updateRecipe() {
        assert (this.f_58857_ != null);
        SealedBarrelRecipe oldRecipe = this.recipe;
        if (((BarrelInventory)this.inventory).excess.isEmpty()) {
            this.recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.BARREL_SEALED.get(), (Container)((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory), this.f_58857_).orElse(null);
            if (!(this.recipe == null || oldRecipe == this.recipe || oldRecipe != null && oldRecipe.m_6423_().equals((Object)this.recipe.m_6423_()))) {
                this.recipeTick = Calendars.get((LevelReader)this.f_58857_).getTicks();
                this.markForSync();
            }
        }
    }

    private void updateFluidIOSlots() {
        assert (this.f_58857_ != null);
        ItemStack input = ((BarrelInventory)this.inventory).getStackInSlot(0);
        if (!input.m_41619_() && ((BarrelInventory)this.inventory).getStackInSlot(1).m_41619_()) {
            FluidHelpers.transferBetweenBlockEntityAndItem(input, this, this.f_58857_, this.f_58858_, (newOriginalStack, newContainerStack) -> {
                if (newContainerStack.m_41619_()) {
                    ((BarrelInventory)this.inventory).setStackInSlot(0, ItemStack.f_41583_);
                    ((BarrelInventory)this.inventory).setStackInSlot(1, newOriginalStack);
                } else {
                    ((BarrelInventory)this.inventory).setStackInSlot(0, newOriginalStack);
                    ((BarrelInventory)this.inventory).setStackInSlot(1, newContainerStack);
                }
            });
        }
    }

    @Nullable
    public BarrelRecipe getRecipe() {
        return this.recipe;
    }

    public long getSealedTick() {
        return this.sealedTick;
    }

    public long getRecipeTick() {
        return this.recipeTick;
    }

    public long getRemainingTicks() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            if (this.recipe == null) {
                this.recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.BARREL_SEALED.get(), (Container)((net.dries007.tfc.common.recipes.inventory.BarrelInventory)this.inventory), this.f_58857_).orElse(null);
            }
            if (this.recipe != null) {
                return (long)this.recipe.getDuration() - (Calendars.get((LevelReader)this.f_58857_).getTicks() - this.recipeTick);
            }
        }
        return 0L;
    }

    public static class BarrelInventory
    implements DelegateItemHandler,
    DelegateFluidHandler,
    INBTSerializable<CompoundTag>,
    EmptyInventory,
    FluidTankCallback,
    net.dries007.tfc.common.recipes.inventory.BarrelInventory {
        private final BarrelInventoryCallback callback;
        private final InventoryItemHandler inventory;
        private final List<ItemStack> excess;
        private final InventoryFluidTank tank;
        private boolean mutable;

        BarrelInventory(InventoryBlockEntity<?> entity) {
            this((BarrelInventoryCallback)((Object)entity));
        }

        public BarrelInventory(BarrelInventoryCallback callback) {
            this.callback = callback;
            this.inventory = new InventoryItemHandler(callback, 3);
            this.excess = new ArrayList<ItemStack>();
            this.tank = new InventoryFluidTank((Integer)Helpers.getValueOrDefault(TFCConfig.SERVER.barrelCapacity), stack -> Helpers.isFluid(stack.getFluid(), TFCTags.Fluids.USABLE_IN_BARREL), this);
        }

        @Override
        public void whileMutable(Runnable action) {
            try {
                this.mutable = true;
                action.run();
            }
            finally {
                this.mutable = false;
            }
        }

        public boolean isInventoryEmpty() {
            return this.tank.getFluid().isEmpty() && this.excess.isEmpty() && Helpers.isEmpty((IItemHandler)this.inventory);
        }

        @Override
        public void insertItemWithOverflow(ItemStack stack) {
            ItemStack remainder = this.inventory.insertItem(2, stack, false);
            if (!remainder.m_41619_()) {
                this.excess.add(remainder);
            }
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.canModify() ? this.tank.fill(resource, action) : 0;
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.canModify() ? this.tank.drain(resource, action) : FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.canModify() ? this.tank.drain(maxDrain, action) : FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.canModify() ? this.inventory.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canModify() ? this.inventory.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return this.canModify() && DelegateItemHandler.super.isItemValid(slot, stack);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            if (!this.excess.isEmpty()) {
                ListTag excessNbt = new ListTag();
                for (ItemStack stack : this.excess) {
                    excessNbt.add((Object)stack.m_41739_(new CompoundTag()));
                }
                nbt.m_128365_("excess", (Tag)excessNbt);
            }
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.excess.clear();
            if (nbt.m_128441_("excess")) {
                ListTag excessNbt = nbt.m_128437_("excess", 10);
                for (int i = 0; i < excessNbt.size(); ++i) {
                    this.excess.add(ItemStack.m_41712_((CompoundTag)excessNbt.m_128728_(i)));
                }
            }
        }

        @Override
        public void fluidTankChanged() {
            this.callback.fluidTankChanged();
        }

        private boolean canModify() {
            return this.mutable || this.callback.canModify();
        }
    }
}

