/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.Tiered;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.forge.ForgeRule;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.container.AnvilPlanContainer;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilBlockEntity
extends InventoryBlockEntity<AnvilInventory>
implements ISlotCallback {
    public static final int SLOT_INPUT_MAIN = 0;
    public static final int SLOT_INPUT_SECOND = 1;
    public static final int SLOT_HAMMER = 2;
    public static final int SLOT_CATALYST = 3;
    public static final int[] SLOTS_BY_HAND_EXTRACT = new int[]{0, 1};
    public static final int[] SLOTS_BY_HAND_INSERT = new int[]{3, 0, 1};
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.anvil");

    public AnvilBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends AnvilBlockEntity>)((BlockEntityType)TFCBlockEntities.ANVIL.get()), pos, state, AnvilInventory::new, NAME);
    }

    public AnvilBlockEntity(BlockEntityType<? extends AnvilBlockEntity> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<AnvilInventory> inventoryFactory, Component defaultName) {
        super(type, pos, state, inventoryFactory, defaultName);
    }

    @Nullable
    public Forging getMainInputForging() {
        return ForgingCapability.get(((AnvilInventory)this.inventory).getStackInSlot(0));
    }

    public MenuProvider planProvider() {
        return new SimpleMenuProvider(this::createPlanContainer, this.m_5446_());
    }

    public MenuProvider anvilProvider() {
        return this;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return AnvilContainer.create(this, player.m_150109_(), containerId);
    }

    @Nullable
    public AbstractContainerMenu createPlanContainer(int containerId, Inventory inventory, Player player) {
        return AnvilPlanContainer.create(this, player.m_150109_(), containerId);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 0, 1 -> true;
            case 2 -> Helpers.isItem(stack, TFCTags.Items.HAMMERS);
            case 3 -> Helpers.isItem(stack, TFCTags.Items.FLUX);
            default -> false;
        };
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return slot == 3 ? 64 : 1;
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        List<ItemStack> excess;
        if (slot == 0) {
            ForgingCapability.clearRecipeIfNotWorked(stack);
        }
        if ((slot == 0 || slot == 1) && !(excess = ((AnvilInventory)this.inventory).excess).isEmpty() && ((AnvilInventory)this.inventory).getStackInSlot(slot).m_41619_()) {
            ((AnvilInventory)this.inventory).setStackInSlot(slot, excess.remove(0));
        }
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        List<AnvilRecipe> all;
        AnvilRecipe recipe;
        Forging forge;
        assert (this.f_58857_ != null);
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        if (!stack.m_41619_() && (forge = ForgingCapability.get(stack)) != null && (recipe = forge.getRecipe(this.f_58857_)) == null && (all = AnvilRecipe.getAll(this.f_58857_, stack, this.getTier())).size() == 1) {
            recipe = (AnvilRecipe)all.iterator().next();
            if (!this.f_58857_.f_46443_) {
                if (stack.m_41613_() != 1) {
                    ItemStack overflow = stack.m_41620_(stack.m_41613_() - 1);
                    if (((AnvilInventory)this.inventory).getStackInSlot(1).m_41619_()) {
                        ((AnvilInventory)this.inventory).setStackInSlot(1, overflow);
                    } else {
                        ((AnvilInventory)this.inventory).excess.add(overflow);
                    }
                }
                forge.setRecipe(recipe, (AnvilRecipe.Inventory)this.inventory);
            }
        }
        this.m_6596_();
    }

    @Override
    public void ejectInventory() {
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        if (!stack.m_41619_()) {
            ForgingCapability.clearRecipeIfNotWorked(stack);
        }
        super.ejectInventory();
        assert (this.f_58857_ != null);
        ((AnvilInventory)this.inventory).excess.stream().filter(item -> !item.m_41619_()).forEach(item -> Helpers.spawnItem(this.f_58857_, this.f_58858_, item));
    }

    public void chooseRecipe(@Nullable AnvilRecipe recipe) {
        Forging forge;
        assert (this.f_58857_ != null);
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        if (!stack.m_41619_() && (forge = ForgingCapability.get(stack)) != null) {
            if (stack.m_41613_() != 1) {
                ItemStack overflow = stack.m_41620_(stack.m_41613_() - 1);
                if (((AnvilInventory)this.inventory).getStackInSlot(1).m_41619_()) {
                    ((AnvilInventory)this.inventory).setStackInSlot(1, overflow);
                } else {
                    ((AnvilInventory)this.inventory).excess.add(overflow);
                }
            }
            forge.setRecipe(recipe, (AnvilRecipe.Inventory)this.inventory);
        }
    }

    public InteractionResult work(ServerPlayer player, ForgeStep step) {
        assert (this.f_58857_ != null);
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        Forging forge = ForgingCapability.get(stack);
        if (forge != null) {
            ItemStack hammer = ((AnvilInventory)this.inventory).getStackInSlot(2);
            InteractionHand hammerSlot = null;
            if (hammer.m_41619_()) {
                hammer = player.m_21205_();
                hammerSlot = InteractionHand.MAIN_HAND;
            }
            if (hammer.m_41619_()) {
                hammer = player.m_21206_();
                hammerSlot = InteractionHand.OFF_HAND;
            }
            if (hammer.m_41619_() || !Helpers.isItem(hammer, TFCTags.Items.HAMMERS)) {
                player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.hammer_required_to_work"), false);
                return InteractionResult.FAIL;
            }
            if (!forge.getSteps().any() && forge.getWork() == 0 && step.step() < 0) {
                return InteractionResult.FAIL;
            }
            AnvilRecipe recipe = forge.getRecipe(this.f_58857_);
            if (recipe != null) {
                if (!recipe.matches((AnvilRecipe.Inventory)this.inventory, this.f_58857_)) {
                    player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.anvil_is_too_low_tier_to_work"), false);
                    return InteractionResult.FAIL;
                }
                @Nullable IHeat heat = HeatCapability.get(stack);
                if (heat != null && !heat.canWork()) {
                    player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.not_hot_enough_to_work"), false);
                    return InteractionResult.FAIL;
                }
                forge.addStep(step);
                InteractionHand breakingHand = hammerSlot;
                hammer.m_41622_(1, (LivingEntity)player, e -> {
                    if (breakingHand != null) {
                        e.m_21190_(breakingHand);
                    }
                });
                if (forge.getWork() < 0 || forge.getWork() > 150) {
                    ((AnvilInventory)this.inventory).setStackInSlot(0, ItemStack.f_41583_);
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11665_, SoundSource.PLAYERS, 0.4f, 1.0f);
                    return InteractionResult.FAIL;
                }
                this.createForgingEffects();
                if (recipe.checkComplete((AnvilRecipe.Inventory)this.inventory)) {
                    ItemStack outputStack = recipe.assemble((AnvilRecipe.Inventory)this.inventory, this.f_58857_.m_9598_());
                    @Nullable IHeat outputHeat = HeatCapability.get(outputStack);
                    if (outputHeat != null) {
                        outputHeat.setTemperatureIfWarmer(heat);
                    }
                    if (recipe.shouldApplyForgingBonus()) {
                        float ratio = (float)forge.getSteps().total() / (float)ForgeRule.calculateOptimalStepsToTarget(recipe.computeTarget((AnvilRecipe.Inventory)this.inventory), recipe.getRules());
                        ForgingBonus bonus = ForgingBonus.byRatio(ratio);
                        ForgingBonus.set(outputStack, bonus, (Player)player);
                        if (bonus == ForgingBonus.PERFECTLY_FORGED) {
                            TFCAdvancements.PERFECTLY_FORGED.trigger(player);
                        }
                    }
                    ((AnvilInventory)this.inventory).setStackInSlot(0, outputStack);
                }
                this.markForSync();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean workRemotely(ForgeStep step, int movement, boolean forceCompletion) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return false;
        }
        ItemStack stack = ((AnvilInventory)this.inventory).getStackInSlot(0);
        Forging forge = ForgingCapability.get(stack);
        if (forge != null) {
            if (!forge.getSteps().any() && forge.getWork() == 0 && movement < 0) {
                return false;
            }
            AnvilRecipe recipe = forge.getRecipe(this.f_58857_);
            if (recipe != null) {
                if (!recipe.matches((AnvilRecipe.Inventory)this.inventory, this.f_58857_)) {
                    return false;
                }
                @Nullable IHeat heat = HeatCapability.get(stack);
                if (heat != null && !heat.canWork()) {
                    return false;
                }
                if (forceCompletion) {
                    int target = recipe.computeTarget((AnvilRecipe.Inventory)this.inventory);
                    int cursor = forge.getWork();
                    if (movement > 0 && cursor > target || movement < 0 && cursor < target) {
                        movement = -movement;
                    }
                    if (movement > 0 && cursor + movement > target || movement < 0 && cursor + movement < target) {
                        movement = target - cursor;
                    }
                }
                forge.addStep(step, movement);
                if (forge.getWork() < 0 || forge.getWork() > 150) {
                    ((AnvilInventory)this.inventory).setStackInSlot(0, ItemStack.f_41583_);
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11665_, SoundSource.PLAYERS, 0.4f, 1.0f);
                    return true;
                }
                this.createForgingEffects();
                if (recipe.checkComplete((AnvilRecipe.Inventory)this.inventory)) {
                    ItemStack outputStack = recipe.assemble((AnvilRecipe.Inventory)this.inventory, this.f_58857_.m_9598_());
                    @Nullable IHeat outputHeat = HeatCapability.get(outputStack);
                    if (outputHeat != null) {
                        outputHeat.setTemperatureIfWarmer(heat);
                    }
                    ((AnvilInventory)this.inventory).setStackInSlot(0, outputStack);
                }
                this.markForSync();
            }
            return true;
        }
        return false;
    }

    private void createForgingEffects() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)TFCSounds.ANVIL_HIT.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double x = (double)this.f_58858_.m_123341_() + Mth.m_216263_((RandomSource)this.f_58857_.f_46441_, (double)0.2, (double)0.8);
            double z = (double)this.f_58858_.m_123343_() + Mth.m_216263_((RandomSource)this.f_58857_.f_46441_, (double)0.2, (double)0.8);
            double y = (double)this.f_58858_.m_123342_() + Mth.m_216263_((RandomSource)this.f_58857_.f_46441_, (double)0.8, (double)1.0);
            server.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.SPARK.get()), x, y, z, 5, 0.0, 0.0, 0.0, (double)0.2f);
        }
    }

    public InteractionResult weld(Player player) {
        ItemStack left = ((AnvilInventory)this.inventory).getLeft();
        ItemStack right = ((AnvilInventory)this.inventory).getRight();
        if (left.m_41619_() && right.m_41619_()) {
            return InteractionResult.PASS;
        }
        assert (this.f_58857_ != null);
        WeldingRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.WELDING.get(), (Container)((WeldingRecipe.Inventory)this.inventory), this.f_58857_).orElse(null);
        if (recipe != null) {
            if (!recipe.isCorrectTier(this.getTier())) {
                player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.anvil_is_too_low_tier_to_weld"), true);
                return InteractionResult.FAIL;
            }
            @Nullable IHeat leftHeat = HeatCapability.get(left);
            @Nullable IHeat rightHeat = HeatCapability.get(right);
            if (leftHeat != null && !leftHeat.canWeld() || rightHeat != null && !rightHeat.canWeld()) {
                player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.not_hot_enough_to_weld"), true);
                return InteractionResult.FAIL;
            }
            if (((AnvilInventory)this.inventory).getStackInSlot(3).m_41619_()) {
                player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.no_flux_to_weld"), true);
                return InteractionResult.FAIL;
            }
            ItemStack result = recipe.assemble((WeldingRecipe.Inventory)this.inventory, this.f_58857_.m_9598_());
            @Nullable IHeat resultHeat = HeatCapability.get(result);
            ((AnvilInventory)this.inventory).getStackInSlot(0).m_41774_(1);
            ((AnvilInventory)this.inventory).getStackInSlot(1).m_41774_(1);
            ((AnvilInventory)this.inventory).getStackInSlot(3).m_41774_(1);
            if (((AnvilInventory)this.inventory).getStackInSlot(0).m_41619_()) {
                ((AnvilInventory)this.inventory).setStackInSlot(0, result);
            } else {
                ((AnvilInventory)this.inventory).excess.add(result);
            }
            if (!((AnvilInventory)this.inventory).excess.isEmpty()) {
                ((AnvilInventory)this.inventory).setStackInSlot(1, ((AnvilInventory)this.inventory).excess.remove(0));
            }
            if (resultHeat != null) {
                resultHeat.setTemperatureIfWarmer(leftHeat);
                resultHeat.setTemperatureIfWarmer(rightHeat);
            }
            this.markForSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getTier() {
        int n;
        Block block = this.m_58900_().m_60734_();
        if (block instanceof Tiered) {
            Tiered tiered = (Tiered)block;
            n = tiered.getTier();
        } else {
            n = 0;
        }
        return n;
    }

    public void setInventoryFromOutsideWorld(ItemStack main, ItemStack hammer, ItemStack flux) {
        NonNullList<ItemStack> internalStacks = ((AnvilInventory)this.inventory).getInternalStacks();
        internalStacks.set(0, (Object)main);
        internalStacks.set(2, (Object)hammer);
        internalStacks.set(3, (Object)flux);
    }

    public static class AnvilInventory
    extends InventoryItemHandler
    implements AnvilRecipe.Inventory,
    WeldingRecipe.Inventory {
        private final AnvilBlockEntity anvil;
        private final List<ItemStack> excess;

        public AnvilInventory(InventoryBlockEntity<AnvilInventory> anvil) {
            super(anvil, 4);
            this.anvil = (AnvilBlockEntity)anvil;
            this.excess = new ArrayList<ItemStack>();
        }

        @Override
        public ItemStack getItem() {
            return this.getStackInSlot(0);
        }

        @Override
        public ItemStack getLeft() {
            return this.getStackInSlot(0);
        }

        @Override
        public ItemStack getRight() {
            return this.getStackInSlot(1);
        }

        @Override
        public int getTier() {
            return this.anvil.getTier();
        }

        @Override
        public long getSeed() {
            long l;
            Helpers.warnWhenCalledFromClientThread();
            Level level = this.anvil.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                l = level2.m_7328_();
            } else {
                l = 0L;
            }
            return l;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            ForgingCapability.clearRecipeIfNotWorked(stack);
            if (!this.excess.isEmpty() && this.getStackInSlot(slot).m_41619_()) {
                ((AnvilInventory)this.anvil.inventory).setStackInSlot(slot, this.excess.remove(0));
            }
            return stack;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            if (!this.excess.isEmpty()) {
                ListTag excessNbt = new ListTag();
                for (ItemStack stack : this.excess) {
                    excessNbt.add((Object)stack.m_41739_(new CompoundTag()));
                }
                nbt.m_128365_("excess", (Tag)excessNbt);
            }
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.excess.clear();
            if (nbt.m_128441_("excess")) {
                ListTag excessNbt = nbt.m_128437_("excess", 10);
                for (int i = 0; i < excessNbt.size(); ++i) {
                    this.excess.add(ItemStack.m_41712_((CompoundTag)excessNbt.m_128728_(i)));
                }
            }
        }
    }
}

