/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class TFCEffects {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((ResourceKey)Registries.f_256929_, (String)"tfc");
    public static final RegistryObject<MobEffect> PINNED = TFCEffects.register("pinned", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 5926017).m_19472_(Attributes.f_22279_, "0e31b409-5bbe-44a8-a0df-f596c00897f3", -7.5, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)ForgeMod.SWIM_SPEED.get(), "99875c8b-c0eb-4ce3-ac4b-fd36b7823e32", -7.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> INK = TFCEffects.register("ink", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 4731988));
    public static final RegistryObject<MobEffect> GLOW_INK = TFCEffects.register("glow_ink", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 4255207));
    public static final RegistryObject<MobEffect> OVERBURDENED = TFCEffects.register("overburdened", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 2504281).m_19472_(Attributes.f_22279_, "81b630a5-3b60-438f-9c73-728a3427205b", -7.5, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)ForgeMod.SWIM_SPEED.get(), "459dacad-9943-4583-9bba-9206886e3974", -7.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> EXHAUSTED = TFCEffects.register("exhausted", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 6715941));
    public static final RegistryObject<MobEffect> THIRST = TFCEffects.register("thirst", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 10333649));

    public static <T extends MobEffect> RegistryObject<T> register(String name, Supplier<T> supplier) {
        return EFFECTS.register(name, supplier);
    }

    public static class TFCMobEffect
    extends MobEffect {
        public TFCMobEffect(MobEffectCategory category, int color) {
            super(category, color);
        }

        public void m_6742_(LivingEntity entity, int amplitude) {
            if (entity instanceof Player) {
                FoodData foodData;
                Player player = (Player)entity;
                if (this == PINNED.get()) {
                    player.setForcedPose(Pose.SLEEPING);
                } else if (this == THIRST.get() && (foodData = player.m_36324_()) instanceof TFCFoodData) {
                    TFCFoodData foodData2 = (TFCFoodData)foodData;
                    if (foodData2.getThirst() > 0.05f) {
                        foodData2.addThirst(-0.02f * (float)(amplitude + 1));
                    }
                } else if (this == EXHAUSTED.get()) {
                    player.m_36399_(1.3333334f * ((Double)TFCConfig.SERVER.passiveExhaustionModifier.get()).floatValue() * 0.25f);
                }
            }
        }

        public boolean m_6584_(int duration, int amplitude) {
            return this == PINNED.get() || this.tickForAmplitude((Supplier<MobEffect>)THIRST, 50, amplitude) || this.tick((Supplier<MobEffect>)EXHAUSTED, duration % 20 == 0);
        }

        private boolean tick(Supplier<MobEffect> check, boolean accepted) {
            return this == check.get() && accepted;
        }

        private boolean tickForAmplitude(Supplier<MobEffect> check, int base, int amplitude) {
            if (this == check.get()) {
                int ticker = base >> amplitude;
                return ticker <= 0 || amplitude % ticker == 0;
            }
            return false;
        }
    }
}

