/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.common.container.SewingTableContainer;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class SewingTableScreen
extends TFCContainerScreen<SewingTableContainer> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/sewing.png");
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 16;
    private static final int RECIPES_PER_PAGE = 16;
    private final List<SewingRecipe> recipes = new ArrayList<SewingRecipe>();
    private boolean showRecipes = false;
    @Nullable
    private SewingRecipe selectedRecipe = null;
    private int startIndex = 0;

    public static void forEachStitch(TriFunction<Integer, Integer, Integer, Boolean> action) {
        int i = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (((Boolean)action.apply((Object)x, (Object)y, (Object)i)).booleanValue()) {
                    return;
                }
                ++i;
            }
        }
    }

    public static void forEachClothSquare(TriConsumer<Integer, Integer, Integer> action) {
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 8; ++x) {
                action.accept((Object)x, (Object)y, (Object)i);
                ++i;
            }
        }
    }

    public SewingTableScreen(SewingTableContainer menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, TEXTURE);
        this.f_97727_ += 30;
        this.f_97731_ += 30;
        --this.f_97729_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.createButton(this.f_97735_ + 125, this.f_97736_ + 13, 20, 20, 236, 0, 20, 0, "tfc.tooltip.sewing.dark_cloth");
        this.createButton(this.f_97735_ + 150, this.f_97736_ + 13, 20, 20, 236, 40, 20, 1, "tfc.tooltip.sewing.light_cloth");
        this.createButton(this.f_97735_ + 125, this.f_97736_ + 38, 20, 20, 236, 80, 20, 2, "tfc.tooltip.sewing.remove_stitch");
        this.createButton(this.f_97735_ + 150, this.f_97736_ + 38, 20, 20, 236, 120, 20, 3, "tfc.tooltip.sewing.stitch");
        this.createButton(this.f_97735_ + 135, this.f_97736_ + 63, 20, 18, 192, 96, 18, 5, "tfc.tooltip.sewing.select_recipe");
        SewingTableScreen.forEachClothSquare((TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, i) -> {
            int id = i + 100;
            this.createButton(this.getScreenX(x * 12 + 6), this.getScreenY(y * 12 + 6), 12, 12, 208, 32, 0, id, null);
        }));
        this.recipes.addAll(ClientHelpers.getLevelOrThrow().m_7465_().m_44013_((RecipeType)TFCRecipeTypes.SEWING.get()));
    }

    private void createButton(int x, int y, int sizeX, int sizeY, int u, int v, int yDiffTex, int packetButtonId, @Nullable String translationKey) {
        SilentImageButton button;
        if (translationKey != null) {
            button = new ImageButton(x, y, sizeX, sizeY, u, v, yDiffTex, TEXTURE, 256, 256, btn -> {
                if (packetButtonId == 5) {
                    this.selectedRecipe = null;
                    this.showRecipes = !this.showRecipes;
                    return;
                }
                if (((SewingTableContainer)this.f_97732_).m_142621_().m_41619_() && !this.showRecipes) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new ScreenButtonPacket(packetButtonId, null));
                }
            }, (Component)Component.m_237115_((String)translationKey));
            button.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)translationKey)));
        } else {
            button = new SilentImageButton(x, y, sizeX, sizeY, u, v, yDiffTex, TEXTURE, 256, 256, btn -> {
                if (((SewingTableContainer)this.f_97732_).m_142621_().m_41619_() && !this.showRecipes) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new ScreenButtonPacket(packetButtonId, null));
                }
            });
        }
        this.m_142416_((GuiEventListener)button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int sewX = this.getSewingX(mouseX);
        int sewY = this.getSewingY(mouseY);
        if (this.showRecipes && this.isSewing(mouseX, mouseY)) {
            int y2 = sewY / 16;
            int x2 = sewX / 16;
            int i2 = y2 * 6 + x2;
            if (i2 == 16) {
                if (this.hasLeftPage()) {
                    this.startIndex = Math.max(0, this.startIndex - 16);
                }
                this.playSound(SoundEvents.f_11713_);
            } else if (i2 == 17) {
                if (this.hasRightPage()) {
                    this.startIndex += 16;
                }
                this.playSound(SoundEvents.f_11713_);
            } else if (i2 + this.startIndex < this.recipes.size()) {
                this.selectedRecipe = this.recipes.get(i2 + this.startIndex);
                this.showRecipes = false;
                this.startIndex = 0;
                this.playSound(SoundEvents.f_12491_);
                return true;
            }
        }
        int mat = ((SewingTableContainer)this.f_97732_).getActiveMaterial();
        if (!this.showRecipes && this.isSewing(mouseX, mouseY) && (mat == 3 || mat == 2)) {
            SewingTableScreen.forEachStitch((TriFunction<Integer, Integer, Integer, Boolean>)((TriFunction)(x, y, i) -> {
                int topY;
                int leftX = x * 12 + 6;
                if (RenderHelpers.isInside(sewX + 6, sewY + 6, leftX, topY = y * 12 + 6, 12, 12) && (((SewingTableContainer)this.f_97732_).getStitchAt((int)i) == 1 || mat == 3)) {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128405_("id", i.intValue());
                    tag.m_128405_("stitchType", mat == 3 ? 1 : 0);
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new ScreenButtonPacket(4, tag));
                    return true;
                }
                return false;
            }));
            if (mat == 3) {
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slotId == 4) {
            this.selectedRecipe = null;
        }
        super.m_6597_(slot, slotId, mouseButton, type);
    }

    public boolean m_7979_(double x, double y, int clickType, double dragX, double dragY) {
        if (clickType == 0 && ((SewingTableContainer)this.f_97732_).getActiveMaterial() != 3 && this.isSewing(x, y)) {
            this.m_6375_(x, y, clickType);
        }
        return super.m_7979_(x, y, clickType, dragX, dragY);
    }

    @Override
    public void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTick, mouseX, mouseY);
        SewingTableScreen.forEachClothSquare((TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, i) -> {
            int recipeMat;
            int mat = ((SewingTableContainer)this.f_97732_).getPlacedMaterial((int)i);
            if (mat != -1) {
                graphics.m_280218_(TEXTURE, this.getScreenX(x * 12 + 6), this.getScreenY(y * 12 + 6), 208, mat == 0 ? 16 : 0, 12, 12);
            } else if (this.selectedRecipe != null && (recipeMat = this.selectedRecipe.getSquares().get((int)i).intValue()) != -1) {
                graphics.m_280218_(TEXTURE, this.getScreenX(x * 12 + 6), this.getScreenY(y * 12 + 6), 208, recipeMat == 0 ? 80 : 64, 12, 12);
            }
        }));
        SewingTableScreen.forEachStitch((TriFunction<Integer, Integer, Integer, Boolean>)((TriFunction)(x, y, i) -> {
            int stitch = ((SewingTableContainer)this.f_97732_).getStitchAt((int)i);
            if (stitch == 1) {
                graphics.m_280398_(TEXTURE, this.getScreenX(x * 12 + 6) - 2, this.getScreenY(y * 12 + 6) - 2, 2, 192.0f, 0.0f, 5, 5, 256, 256);
            } else if (this.selectedRecipe != null && this.selectedRecipe.getStitches().get((int)i) == 1) {
                graphics.m_280398_(TEXTURE, this.getScreenX(x * 12 + 6) - 2, this.getScreenY(y * 12 + 6) - 2, 2, 192.0f, 64.0f, 5, 5, 256, 256);
            }
            return false;
        }));
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (!((SewingTableContainer)this.f_97732_).canPickup(0)) {
            SewingTableScreen.m_280359_((GuiGraphics)graphics, (int)8, (int)83, (int)1);
        }
        if (!((SewingTableContainer)this.f_97732_).canPickup(2)) {
            SewingTableScreen.m_280359_((GuiGraphics)graphics, (int)62, (int)83, (int)1);
        }
        if (!((SewingTableContainer)this.f_97732_).canPickup(3)) {
            SewingTableScreen.m_280359_((GuiGraphics)graphics, (int)80, (int)83, (int)1);
        }
        if (!((SewingTableContainer)this.f_97732_).canPickup(1)) {
            SewingTableScreen.m_280359_((GuiGraphics)graphics, (int)26, (int)83, (int)1);
        }
        if (((SewingTableContainer)this.f_97732_).m_142621_().m_41619_() && RenderHelpers.isInside(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_) && !this.showRecipes) {
            int mat = ((SewingTableContainer)this.f_97732_).getActiveMaterial();
            if (mat == 0) {
                graphics.m_280218_(TEXTURE, mouseX - this.f_97735_, mouseY - this.f_97736_, 208, 16, 12, 12);
            } else if (mat == 1) {
                graphics.m_280218_(TEXTURE, mouseX - this.f_97735_, mouseY - this.f_97736_, 208, 0, 12, 12);
            } else if (mat == 2 || mat == 3) {
                graphics.m_280218_(TEXTURE, mouseX - this.f_97735_, mouseY - this.f_97736_, 208, 48, 16, 16);
            }
        }
        int burlapCount = ((SewingTableContainer)this.f_97732_).getBurlapCount();
        int woolCount = ((SewingTableContainer)this.f_97732_).getWoolCount();
        int yarnCount = ((SewingTableContainer)this.f_97732_).getYarnCount();
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, String.valueOf(Math.min(burlapCount, 99)), 135, 25, burlapCount == 0 ? 0x404040 : 0xFFFFFF);
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, String.valueOf(Math.min(woolCount, 99)), 160, 25, woolCount == 0 ? 0x404040 : 0xFFFFFF);
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, String.valueOf(Math.min(yarnCount, 99)), 160, 48, yarnCount == 0 ? 0x404040 : 0xFFFFFF);
        if (this.showRecipes) {
            this.renderRecipes(graphics, mouseX, mouseY);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280024_(8, 14, 119, 77, -1072689136, -804253680);
        RegistryAccess access = ClientHelpers.getLevelOrThrow().m_9598_();
        int max = this.startIndex + 16 + 2;
        for (int idx = this.startIndex; idx < max; ++idx) {
            int i = idx - this.startIndex;
            int x = i % 6 * 16 + 10;
            int y = i / 6 * 16 + 16;
            if (i == 16) {
                if (!this.hasLeftPage()) continue;
                graphics.m_280218_(TEXTURE, x, y, 192, 144, 16, 16);
                continue;
            }
            if (i == 17) {
                if (!this.hasRightPage()) continue;
                graphics.m_280218_(TEXTURE, x, y, 208, 144, 16, 16);
                continue;
            }
            if (idx >= this.recipes.size()) continue;
            SewingRecipe recipe = this.recipes.get(idx);
            ItemStack item = recipe.m_8043_(access);
            graphics.m_280256_(item, x, y, 1);
            if (!RenderHelpers.isInside(mouseX - this.f_97735_, mouseY - this.f_97736_, x, y, 16, 16)) continue;
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, item, x + 8, y + 8);
        }
    }

    private boolean hasLeftPage() {
        return this.startIndex > 0;
    }

    private boolean hasRightPage() {
        return this.startIndex + 16 < this.recipes.size();
    }

    private boolean isSewing(double mouseX, double mouseY) {
        return RenderHelpers.isInside((int)mouseX, (int)mouseY, 10 + this.f_97735_, 16 + this.f_97736_, 107, 59);
    }

    private int getSewingX(double mouseX) {
        return (int)(mouseX - 10.0 - (double)this.f_97735_);
    }

    private int getSewingY(double mouseY) {
        return (int)(mouseY - 16.0 - (double)this.f_97736_);
    }

    private int getScreenX(int posX) {
        return posX == -1 ? 0 : posX + 10 + this.f_97735_;
    }

    private int getScreenY(int posY) {
        return posY == -1 ? 0 : posY + 16 + this.f_97736_;
    }

    private void playSound(SoundEvent sound) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)1.0f));
    }

    public static class SilentImageButton
    extends ImageButton {
        public SilentImageButton(int x, int y, int width, int height, int texStart, int yTexStart, int yDiffTex, ResourceLocation texture, int textureWidth, int textureHeight, Button.OnPress onPress) {
            super(x, y, width, height, texStart, yTexStart, yDiffTex, texture, textureWidth, textureHeight, onPress);
        }

        public void m_7435_(SoundManager handler) {
        }
    }
}

