/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.fluids.FluidStack;

public class PotScreen
extends BlockEntityScreen<PotBlockEntity, PotContainer> {
    private static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/fire_pit_cooking_pot.png");

    public PotScreen(PotContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 20;
        this.f_97727_ += 20;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            this.drawDisabled(graphics, 4, 8);
        }
        MutableComponent text = Component.m_237119_();
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            text.m_7220_((Component)Component.m_237115_((String)"tfc.tooltip.pot_boiling"));
        } else if (((PotBlockEntity)this.blockEntity).getOutput() != null && !((PotBlockEntity)this.blockEntity).getOutput().isEmpty()) {
            BlockEntityTooltip tooltip = ((PotBlockEntity)this.blockEntity).getOutput().getTooltip();
            if (tooltip != null && ((PotBlockEntity)this.blockEntity).m_58904_() != null) {
                ArrayList fakeTooltip = new ArrayList();
                tooltip.display(((PotBlockEntity)this.blockEntity).m_58904_(), ((PotBlockEntity)this.blockEntity).m_58900_(), ((PotBlockEntity)this.blockEntity).m_58899_(), this.blockEntity, fakeTooltip::add);
                text.m_7220_((Component)fakeTooltip.get(0));
            } else {
                text.m_7220_((Component)Component.m_237115_((String)"tfc.tooltip.pot_finished"));
            }
        }
        int x = 118 - this.f_96547_.m_92852_((FormattedText)text) / 2;
        graphics.m_280614_(this.f_96547_, (Component)text, x, 80, 0x404040, false);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        FluidStack fluid;
        super.m_280072_(graphics, mouseX, mouseY);
        if (RenderHelpers.isInside(mouseX, mouseY, this.getGuiLeft() + 121, this.getGuiTop() + 30, 41, 28) && !(fluid = ((PotBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).map(c -> c.getFluidInTank(0)).orElse(FluidStack.EMPTY)).isEmpty()) {
            graphics.m_280557_(this.f_96547_, (Component)Tooltips.fluidUnitsAndCapacityOf(fluid, 1000), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.f_97735_ + 30, this.f_97736_ + 76 - 51, 15, 51) && (text = ((TemperatureDisplayStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(((PotBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.m_280557_(this.f_96547_, (Component)text, mouseX, mouseY);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluid;
        int temp;
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        if (Helpers.isJEIEnabled()) {
            graphics.m_280218_(this.texture, this.getGuiLeft() + 77, this.getGuiTop() + 6, 247, 0, 9, 14);
        }
        if ((temp = Heat.scaleTemperatureForGui(((PotBlockEntity)this.blockEntity).getTemperature())) > 0) {
            graphics.m_280218_(this.texture, this.f_97735_ + 30, this.f_97736_ + 76 - Math.min(51, temp), 176, 0, 15, 5);
        }
        if (((PotBlockEntity)this.blockEntity).getTemperature() > 0.0f) {
            graphics.m_280218_(BACKGROUND, this.f_97735_ + 121, this.f_97736_ + 58, 192, 0, 13, 13);
            graphics.m_280218_(BACKGROUND, this.f_97735_ + 136, this.f_97736_ + 58, 192, 0, 13, 13);
            graphics.m_280218_(BACKGROUND, this.f_97735_ + 151, this.f_97736_ + 58, 192, 0, 13, 13);
        }
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            int ticks = ((PotBlockEntity)this.blockEntity).getBoilingTicks() % 35;
            int vHeight = Mth.m_14167_((float)((float)ticks / 35.0f * 20.0f));
            graphics.m_280218_(BACKGROUND, this.f_97735_ + 131, this.f_97736_ + 10 + 20 - vHeight, 193, 37 - vHeight, 11, vHeight);
            graphics.m_280218_(BACKGROUND, this.f_97735_ + 144, this.f_97736_ + 10 + 20 - vHeight, 193, 37 - vHeight, 11, vHeight);
        }
        int fluidColor = -1;
        PotRecipe.Output output = ((PotBlockEntity)this.blockEntity).getOutput();
        if (output != null && !output.isEmpty()) {
            if (output.getRenderTexture() != null) {
                TextureAtlasSprite sprite = RenderHelpers.blockTexture(output.getRenderTexture());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.f_97735_ + 133, this.f_97736_ + 33, 20, 6, 16, 16);
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.f_97735_ + 131, this.f_97736_ + 35, 2, 2, 16, 16);
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.f_97735_ + 153, this.f_97736_ + 35, 2, 2, 16, 16);
                return;
            }
            fluidColor = output.getFluidColor();
        }
        if (fluidColor == -1 && !(fluid = ((PotBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).map(cap -> cap.getFluidInTank(0)).orElse(FluidStack.EMPTY)).isEmpty()) {
            fluidColor = RenderHelpers.getFluidColor(fluid);
        }
        if (fluidColor != -1) {
            RenderHelpers.setShaderColor(graphics, fluidColor);
            graphics.m_280218_(BACKGROUND, this.f_97735_ + 131, this.f_97736_ + 33, 208, 0, 24, 6);
            this.resetToBackgroundSprite();
        }
    }
}

