/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.client.screen.ScreenParticle;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.KnappingButton;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.KnappingType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KnappingScreen
extends TFCContainerScreen<KnappingContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/knapping.png");
    private final ResourceLocation buttonLocation;
    @Nullable
    private final ResourceLocation buttonDisabledLocation;
    private final List<ScreenParticle> particles = new ArrayList<ScreenParticle>();

    public static ResourceLocation getHighTexture(ItemStack stack) {
        return KnappingScreen.getButtonLocation(stack.m_41720_(), false);
    }

    @Nullable
    public static ResourceLocation getLowTexture(KnappingType type, ItemStack stack) {
        return type.usesDisabledTexture() ? KnappingScreen.getButtonLocation(stack.m_41720_(), true) : null;
    }

    public static ResourceLocation getButtonLocation(Item item, boolean disabled) {
        return Helpers.identifier("textures/gui/knapping/" + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_() + (disabled ? "_disabled" : "") + ".png");
    }

    public KnappingScreen(KnappingContainer container, Inventory inv, Component name) {
        super(container, inv, name, BACKGROUND);
        this.f_97727_ = 186;
        this.f_97731_ += 22;
        this.f_97729_ -= 2;
        ItemStack stack = container.getOriginalStack();
        this.buttonLocation = KnappingScreen.getHighTexture(stack);
        this.buttonDisabledLocation = KnappingScreen.getLowTexture(container.getKnappingType(), stack);
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                int bx = (this.f_96543_ - this.getXSize()) / 2 + 12 + 16 * x;
                int by = (this.f_96544_ - this.getYSize()) / 2 + 12 + 16 * y;
                this.m_142416_((GuiEventListener)new KnappingButton(x + 5 * y, bx, by, 16, 16, this.buttonLocation, ((KnappingContainer)this.f_97732_).getKnappingType().clickSound(), this::spawnParticles));
            }
        }
        ((KnappingContainer)this.f_97732_).setRequiresReset(true);
    }

    private void spawnParticles(Button button) {
        if (button instanceof KnappingButton) {
            KnappingButton knappingButton = (KnappingButton)button;
            if (((KnappingContainer)this.f_97732_).getKnappingType().spawnsParticles() && ((Boolean)TFCConfig.CLIENT.enableScreenParticles.get()).booleanValue() && Minecraft.m_91405_()) {
                RandomSource random = Minecraft.m_91087_().f_91062_.f_92711_;
                int amount = Mth.m_216271_((RandomSource)random, (int)0, (int)3);
                for (int i = 0; i < amount; ++i) {
                    ScreenParticle particle = new ScreenParticle(knappingButton.getTexture(), button.m_252754_(), button.m_252907_(), Mth.m_216267_((RandomSource)random, (float)-0.1f, (float)0.1f), Mth.m_216267_((RandomSource)random, (float)1.2f, (float)1.5f), 16, 16, random);
                    this.particles.add(particle);
                }
            }
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        for (ScreenParticle particle : this.particles) {
            particle.tick();
        }
        this.particles.removeIf(ScreenParticle::shouldBeRemoved);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        KnappingButton button;
        if (((KnappingContainer)this.f_97732_).requiresReset()) {
            for (Renderable widget : this.f_169369_) {
                if (!(widget instanceof KnappingButton)) continue;
                button = (KnappingButton)widget;
                button.f_93624_ = ((KnappingContainer)this.f_97732_).getPattern().get(button.id);
            }
            ((KnappingContainer)this.f_97732_).setRequiresReset(false);
        }
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof KnappingButton)) continue;
            button = (KnappingButton)widget;
            if (button.f_93624_) {
                graphics.m_280163_(this.buttonLocation, button.m_252754_(), button.m_252907_(), 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            if (this.buttonDisabledLocation == null) continue;
            graphics.m_280163_(this.buttonDisabledLocation, button.m_252754_(), button.m_252907_(), 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    @Override
    public void m_88315_(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(poseStack, mouseX, mouseY, partialTicks);
        for (ScreenParticle particle : this.particles) {
            particle.render(poseStack);
        }
    }

    public boolean m_7979_(double x, double y, int clickType, double dragX, double dragY) {
        if (clickType == 0) {
            this.m_6375_(x, y, clickType);
        }
        return super.m_7979_(x, y, clickType, dragX, dragY);
    }

    public boolean m_6375_(double x, double y, int clickType) {
        if (clickType == 0) {
            this.undoAccidentalButtonPress(x, y);
        }
        return super.m_6375_(x, y, clickType);
    }

    private void undoAccidentalButtonPress(double x, double y) {
        for (Renderable widget : this.f_169369_) {
            KnappingButton button;
            if (!(widget instanceof KnappingButton) || !(button = (KnappingButton)widget).m_5953_(x, y)) continue;
            ((KnappingContainer)this.f_97732_).getPattern().set(button.id, false);
        }
    }
}

