/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.Objects;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.BarrelSealButton;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class BarrelScreen
extends BlockEntityScreen<BarrelBlockEntity, BarrelContainer> {
    private static final Component SEAL = Component.m_237115_((String)"tfc.tooltip.seal_barrel");
    private static final Component UNSEAL = Component.m_237115_((String)"tfc.tooltip.unseal_barrel");
    private static final int MAX_RECIPE_NAME_LENGTH = 100;
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/barrel.png");

    public BarrelScreen(BarrelContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 12;
        this.f_97727_ += 12;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BarrelSealButton((BarrelBlockEntity)this.blockEntity, this.getGuiLeft(), this.getGuiTop(), this.isSealed() ? UNSEAL : SEAL));
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (this.isSealed()) {
            this.drawDisabled(graphics, 0, 2);
            BarrelRecipe recipe = ((BarrelBlockEntity)this.blockEntity).getRecipe();
            if (recipe != null) {
                MutableComponent resultText = recipe.getTranslationComponent();
                if (this.f_96547_.m_92852_((FormattedText)resultText) > 100) {
                    int line = 0;
                    for (FormattedCharSequence text : this.f_96547_.m_92923_((FormattedText)resultText, 100)) {
                        int n = 70 + Math.floorDiv(100 - this.f_96547_.m_92724_(text), 2);
                        Objects.requireNonNull(this.f_96547_);
                        graphics.m_280649_(this.f_96547_, text, n, this.f_97729_ + line * 9, 0x404040, false);
                        ++line;
                    }
                } else {
                    graphics.m_280056_(this.f_96547_, resultText.getString(), 70 + Math.floorDiv(100 - this.f_96547_.m_92852_((FormattedText)resultText), 2), 61, 0x404040, false);
                }
            }
            String date = ICalendar.getTimeAndDate(Calendars.CLIENT.ticksToCalendarTicks(((BarrelBlockEntity)this.blockEntity).getSealedTick()), Calendars.CLIENT.getCalendarDaysInMonth()).getString();
            graphics.m_280056_(this.f_96547_, date, this.f_97726_ / 2 - this.f_96547_.m_92895_(date) / 2, 74, 0x404040, false);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        if (Helpers.isJEIEnabled()) {
            graphics.m_280218_(this.texture, this.getGuiLeft() + 92, this.getGuiTop() + 21, 227, 0, 9, 14);
        }
        ((BarrelBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluidStack);
                int fillHeight = (int)Math.ceil(50.0f * (float)fluidStack.getAmount() / (float)((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue());
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.f_97735_ + 8, this.f_97736_ + 70 - fillHeight, 16, fillHeight, 16, 16);
                this.resetToBackgroundSprite();
            }
        });
        graphics.m_280218_(this.texture, this.getGuiLeft() + 7, this.getGuiTop() + 19, 176, 0, 18, 52);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        int relX = mouseX - this.getGuiLeft();
        int relY = mouseY - this.getGuiTop();
        if (relX >= 7 && relY >= 19 && relX < 25 && relY < 71) {
            ((BarrelBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
                FluidStack fluid = fluidHandler.getFluidInTank(0);
                if (!fluid.isEmpty()) {
                    graphics.m_280557_(this.f_96547_, (Component)Tooltips.fluidUnitsOf(fluid), mouseX, mouseY);
                }
            });
        }
    }

    private boolean isSealed() {
        return (Boolean)((BarrelBlockEntity)this.blockEntity).m_58900_().m_61143_((Property)BarrelBlock.SEALED);
    }
}

