/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.WindmillBladeLatticeModel;
import net.dries007.tfc.client.model.entity.WindmillBladeModel;
import net.dries007.tfc.client.model.entity.WindmillBladeRusticModel;
import net.dries007.tfc.client.render.blockentity.AxleBlockEntityRenderer;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class WindmillBlockEntityRenderer
implements BlockEntityRenderer<WindmillBlockEntity> {
    public static final Map<Item, Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>> BLADE_MODELS = (Map)Util.m_137469_(new IdentityHashMap(), map -> {
        ResourceLocation defaultTexture = Helpers.identifier("textures/entity/misc/windmill_blade.png");
        Function<BlockEntityRendererProvider.Context, WindmillBladeModel> defaultModel = WindmillBlockEntityRenderer.defaultModelFactory();
        map.put((Item)TFCItems.WINDMILL_BLADE.get(), new Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>(defaultTexture, DyeColor.WHITE, defaultModel));
        TFCItems.COLORED_WINDMILL_BLADES.forEach((color, item) -> map.put((Item)item.get(), new Provider<Function>(defaultTexture, (DyeColor)color, defaultModel)));
        map.put((Item)TFCItems.LATTICE_WINDMILL_BLADE.get(), new Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>(Helpers.identifier("textures/entity/misc/windmill_blade_lattice.png"), DyeColor.WHITE, context -> new WindmillBladeLatticeModel(context.m_173582_(RenderHelpers.modelIdentifier("windmill_blade_lattice")))));
        map.put((Item)TFCItems.RUSTIC_WINDMILL_BLADE.get(), new Provider<Function<BlockEntityRendererProvider.Context, WindmillBladeModel>>(Helpers.identifier("textures/entity/misc/windmill_blade_rustic.png"), DyeColor.WHITE, context -> new WindmillBladeRusticModel(context.m_173582_(RenderHelpers.modelIdentifier("windmill_blade_rustic")))));
    });
    private static final float[] NO_COLOR = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final Map<Item, Provider<WindmillBladeModel>> bladeModels;
    private final Provider<WindmillBladeModel> fallbackModel;

    private static Function<BlockEntityRendererProvider.Context, WindmillBladeModel> defaultModelFactory() {
        MutableObject cache = new MutableObject(null);
        return arg_0 -> WindmillBlockEntityRenderer.lambda$defaultModelFactory$4((Mutable)cache, arg_0);
    }

    public WindmillBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)BLADE_MODELS.size());
        BLADE_MODELS.forEach((item, provider) -> builder.put(item, new Provider<WindmillBladeModel>(provider.texture, provider.color, (WindmillBladeModel)((Object)((Object)((Function)provider.model).apply(context))))));
        this.bladeModels = builder.build();
        this.fallbackModel = Objects.requireNonNull(this.bladeModels.get(TFCItems.WINDMILL_BLADE.get()));
    }

    public void render(WindmillBlockEntity windmill, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Provider<WindmillBladeModel> provider;
        ItemStack item;
        int i;
        boolean hasFullIdenticalSet;
        boolean axisX;
        WindmillBlock windmillBlock;
        BlockState state;
        block11: {
            block10: {
                Level level = windmill.m_58904_();
                state = windmill.m_58900_();
                Block block = state.m_60734_();
                if (!(block instanceof WindmillBlock)) break block10;
                windmillBlock = (WindmillBlock)block;
                if (level != null) break block11;
            }
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(WindmillBlock.AXIS);
        int bladeCount = (Integer)state.m_61143_((Property)WindmillBlock.COUNT);
        AxleBlockEntityRenderer.renderAxle(stack, bufferSource, windmillBlock, axis, packedLight, packedOverlay, -windmill.getRotationAngle(partialTick));
        stack.m_85836_();
        boolean bl = axisX = state.m_61143_(WindmillBlock.AXIS) == Direction.Axis.X;
        if (!axisX) {
            stack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        }
        stack.m_252880_(0.5f, -1.0f, axisX ? 0.5f : -0.5f);
        IItemHandler inv = Helpers.getCapability((ICapabilityProvider)windmill, Capabilities.ITEM);
        if (inv == null) {
            return;
        }
        boolean bl2 = hasFullIdenticalSet = bladeCount == 5;
        if (hasFullIdenticalSet) {
            WindmillBladeModel model = null;
            for (i = 0; i < bladeCount; ++i) {
                item = inv.getStackInSlot(i);
                provider = this.bladeModels.getOrDefault(item.m_41720_(), this.fallbackModel);
                if (item.m_41619_() || model != null && model != provider.model) {
                    hasFullIdenticalSet = false;
                    break;
                }
                model = (WindmillBladeModel)((Object)provider.model);
            }
        }
        float offsetAngle = (float)Math.PI * 2 / (float)bladeCount;
        for (i = 0; i < bladeCount; ++i) {
            item = inv.getStackInSlot(i);
            if (item.m_41619_()) continue;
            provider = this.bladeModels.getOrDefault(item.m_41720_(), this.fallbackModel);
            float[] color = provider.color == DyeColor.WHITE ? NO_COLOR : provider.color.m_41068_();
            WindmillBladeModel bladeModel = (WindmillBladeModel)((Object)provider.model);
            ResourceLocation bladeTexture = provider.texture;
            stack.m_85836_();
            stack.m_252880_(1.0E-4f * (float)i, 1.0E-4f * (float)i, 1.0E-4f * (float)i);
            bladeModel.setupAnim(windmill, partialTick, offsetAngle * (float)i);
            bladeModel.m_7695_(stack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)bladeTexture)), packedLight, packedOverlay, color[0], color[1], color[2], 1.0f);
            if (hasFullIdenticalSet) {
                bladeModel.renderWindmillExtras(stack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)bladeTexture)), packedLight, packedOverlay, color[0], color[1], color[2], 1.0f);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    public boolean shouldRenderOffScreen(WindmillBlockEntity windmill) {
        return true;
    }

    private static /* synthetic */ WindmillBladeModel lambda$defaultModelFactory$4(Mutable cache, BlockEntityRendererProvider.Context context) {
        if (cache.getValue() != null && ((Pair)cache.getValue()).getFirst() != context) {
            cache.setValue(null);
        }
        if (cache.getValue() == null) {
            cache.setValue((Object)Pair.of((Object)context, (Object)((Object)new WindmillBladeModel(context.m_173582_(RenderHelpers.modelIdentifier("windmill_blade"))))));
        }
        return (WindmillBladeModel)((Object)((Pair)cache.getValue()).getSecond());
    }

    public record Provider<T>(ResourceLocation texture, DyeColor color, T model) {
    }
}

