/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SluiceBlockEntityRenderer
implements BlockEntityRenderer<SluiceBlockEntity> {
    private static void drawItem(ItemStack stack, float x, float y, float z, float rotation, ItemRenderer renderer, PoseStack poseStack, int combinedLight, int combinedOverlay, MultiBufferSource buffer, @Nullable Level level) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(0.3f, 0.3f, 0.3f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        renderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, level, 0);
        poseStack.m_85849_();
    }

    private static void vertex(QuadRenderInfo info, float x, float y, float z, int color, float u, float v) {
        info.builder.m_252986_(info.matrix4f, x, y, z).m_193479_(color).m_7421_(u, v).m_86008_(info.combinedOverlay).m_85969_(info.combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    public void render(SluiceBlockEntity sluice, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (sluice.m_58904_() == null) {
            return;
        }
        BlockState state = sluice.m_58900_();
        if (!((Boolean)state.m_61143_((Property)SluiceBlock.UPPER)).booleanValue()) {
            return;
        }
        poseStack.m_85836_();
        Direction facing = (Direction)state.m_61143_((Property)SluiceBlock.FACING);
        if (facing == Direction.NORTH) {
            poseStack.m_252880_(1.0f, 0.0f, 1.0f);
        } else if (facing == Direction.WEST) {
            poseStack.m_252880_(1.0f, 0.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else if (facing == Direction.EAST) {
            poseStack.m_252880_(0.0f, 0.0f, 1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)((Direction)state.m_61143_((Property)SluiceBlock.FACING)).m_122416_() * 90.0f));
        float rotation = RenderHelpers.itemTimeRotation();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        sluice.getCapability(Capabilities.ITEM).ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                int step = Mth.m_14143_((float)((float)i / 4.0f));
                int across = i % 4;
                float x = 0.125f + 0.25f * (float)across;
                float y = 0.95625f - 0.125f * (float)step;
                float z = 0.14375f + 0.25f * (float)step;
                SluiceBlockEntityRenderer.drawItem(stack, x, y, z, rotation, itemRenderer, poseStack, combinedLight, combinedOverlay, buffer, sluice.m_58904_());
            }
        });
        Fluid fluid = sluice.getFlow();
        if (fluid == null) {
            poseStack.m_85849_();
            return;
        }
        FluidType attributes = fluid.getFluidType();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((FluidType)attributes);
        ResourceLocation texture = extension.getStillTexture();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS).apply(texture);
        int color = Helpers.isFluid(fluid, TFCTags.Fluids.ANY_INFINITE_WATER) ? TFCColors.getWaterColor(sluice.m_58899_()) : RenderHelpers.getFluidColor(fluid);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)RenderHelpers.BLOCKS_ATLAS));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        QuadRenderInfo info = new QuadRenderInfo(builder, matrix4f, combinedOverlay, combinedLight);
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 1.033f, 0.0f, color, sprite.m_118409_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.15f, 2.45f, color, sprite.m_118409_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.15f, 2.45f, color, sprite.m_118410_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 1.033f, 0.0f, color, sprite.m_118410_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 0.833f, 0.0f, color, sprite.m_118409_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.3f, 2.45f, color, sprite.m_118409_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.3f, 2.45f, color, sprite.m_118410_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 0.833f, 0.0f, color, sprite.m_118410_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.15f, 2.45f, color, sprite.m_118409_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 1.033f, 0.0f, color, sprite.m_118409_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, 0.833f, 0.0f, color, sprite.m_118410_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.05f, -0.3f, 2.45f, color, sprite.m_118410_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 1.033f, 0.0f, color, sprite.m_118409_(), sprite.m_118411_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.15f, 2.45f, color, sprite.m_118409_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, -0.3f, 2.45f, color, sprite.m_118410_(), sprite.m_118412_());
        SluiceBlockEntityRenderer.vertex(info, 0.95f, 0.833f, 0.0f, color, sprite.m_118410_(), sprite.m_118411_());
        poseStack.m_85849_();
    }

    private record QuadRenderInfo(VertexConsumer builder, Matrix4f matrix4f, int combinedOverlay, int combinedLight) {
    }
}

