/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.render.blockentity.FirepitBlockEntityRenderer;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class PotBlockEntityRenderer
extends FirepitBlockEntityRenderer<PotBlockEntity> {
    @Override
    public void render(PotBlockEntity pot, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(pot, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (pot.m_58904_() == null) {
            return;
        }
        PotRecipe.Output output = pot.getOutput();
        if (output != null && output.getRenderTexture() != null) {
            RenderHelpers.renderTexturedFace(poseStack, buffer, 0xFFFFFF, 0.3125f, 0.3125f, 0.6875f, 0.6875f, output.getFluidYLevel(), combinedOverlay, combinedLight, output.getRenderTexture(), false);
        } else {
            boolean useDefaultFluid = output != null && output.getFluidColor() != -1;
            FluidStack fluidStack = pot.getCapability(Capabilities.FLUID).map(cap -> cap.getFluidInTank(0)).filter(f -> !f.isEmpty()).orElseGet(() -> useDefaultFluid ? new FluidStack((Fluid)Fluids.f_76193_, 1000) : FluidStack.EMPTY);
            if (!fluidStack.isEmpty()) {
                int color = useDefaultFluid ? output.getFluidColor() : RenderHelpers.getFluidColor(fluidStack);
                RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, color, 0.3125f, 0.3125f, 0.6875f, 0.6875f, output == null ? 0.625f : output.getFluidYLevel(), combinedOverlay, combinedLight);
            }
        }
        pot.getCapability(Capabilities.ITEM).ifPresent(cap -> {
            int ordinal = 0;
            for (int slot = 4; slot <= 8; ++slot) {
                ItemStack item = cap.getStackInSlot(slot);
                if (item.m_41619_()) continue;
                float yOffset = 0.46f;
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 0.003125 + (double)yOffset, 0.5);
                poseStack.m_85841_(0.3f, 0.3f, 0.3f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.0f, -0.12f * (float)(++ordinal));
                Minecraft.m_91087_().m_91291_().m_269128_(item, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, pot.m_58904_(), 0);
                poseStack.m_85849_();
            }
        });
    }
}

