/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.rotation.CrankshaftBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.common.blocks.rotation.FluidPumpBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class CrankshaftBlockEntityRenderer
implements BlockEntityRenderer<CrankshaftBlockEntity> {
    public static final ResourceLocation WHEEL_MODEL = Helpers.identifier("block/crankshaft_wheel");
    public static final ResourceLocation ROD_TEXTURE = Helpers.identifier("block/metal/block/steel");
    public static final ResourceLocation PUMP_TEXTURE = Helpers.identifier("block/metal/smooth/brass");

    public void render(CrankshaftBlockEntity crankshaft, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = crankshaft.m_58904_();
        BlockPos pos = crankshaft.m_58899_();
        BlockState state = crankshaft.m_58900_();
        if (!(state.m_60734_() instanceof CrankshaftBlock) || level == null) {
            return;
        }
        Direction face = (Direction)state.m_61143_(CrankshaftBlock.FACING);
        CrankshaftBlock.Part part = (CrankshaftBlock.Part)((Object)state.m_61143_(CrankshaftBlock.PART));
        if (part == CrankshaftBlock.Part.SHAFT && crankshaft.getRotationNode().rotation() == null) {
            BlockEntity mainPart = level.m_7702_(pos.m_5484_(face, -1));
            if (!(mainPart instanceof CrankshaftBlockEntity)) {
                return;
            }
            CrankshaftBlockEntity mainEntity = (CrankshaftBlockEntity)mainPart;
            crankshaft = mainEntity;
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        float rotationAngle = CrankshaftBlockEntity.calculateRealRotationAngle(crankshaft, face, partialTick);
        RandomSource random = RandomSource.m_216327_();
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - 90.0f * (float)face.m_122416_()));
        if (part == CrankshaftBlock.Part.BASE) {
            stack.m_252781_(Axis.f_252529_.m_252961_(rotationAngle + (float)Math.PI));
            stack.m_252880_(-0.5f, -0.5f, -0.5f);
            ModelBlockRenderer modelRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
            BakedModel baked = Minecraft.m_91087_().m_91304_().getModel(WHEEL_MODEL);
            modelRenderer.tesselateWithAO((BlockAndTintGetter)level, baked, crankshaft.m_58900_(), crankshaft.m_58899_(), stack, buffer, true, random, (long)packedLight, packedOverlay, ModelData.EMPTY, RenderType.m_110463_());
            BlockState adjacentAxleState = level.m_8055_(crankshaft.m_58899_().m_121945_(face.m_122428_()));
            Block block = adjacentAxleState.m_60734_();
            if (block instanceof ConnectedAxleBlock) {
                ConnectedAxleBlock axleBlock = (ConnectedAxleBlock)block;
                if (crankshaft.getRotationNode().isConnectedToNetwork()) {
                    ResourceLocation axleTexture = axleBlock.getAxleTextureLocation();
                    TextureAtlasSprite axleSprite = RenderHelpers.blockTexture(axleTexture);
                    RenderHelpers.renderTexturedCuboid(stack, buffer, axleSprite, packedLight, packedOverlay, 0.0f, 0.375f, 0.375f, 0.375f, 0.625f, 0.625f, false);
                }
            }
        } else {
            stack.m_252880_(-0.5f, -0.5f, -0.5f);
            TextureAtlasSprite rodSprite = RenderHelpers.blockTexture(ROD_TEXTURE);
            CrankshaftBlockEntity.ShaftMovement movement = CrankshaftBlockEntity.calculateShaftMovement(rotationAngle);
            float pistonLength = 1.03125f;
            float armLength = 0.75f;
            float armRadius = 0.0625f;
            float boxRadius = 0.125f;
            stack.m_252880_(0.5625f, 0.5f, movement.lengthEH());
            RenderHelpers.renderTexturedCuboid(stack, buffer, rodSprite, packedLight, packedOverlay, -0.125f, -0.125f, -0.125f, 0.125f, 0.125f, 0.125f);
            RenderHelpers.renderTexturedCuboid(stack, buffer, rodSprite, packedLight, packedOverlay, -0.0625f, -0.0625f, -1.03125f, 0.0625f, 0.0625f, 0.0625f);
            BlockPos pumpPos = pos.m_121945_(face);
            BlockState pumpState = level.m_8055_(pumpPos);
            if (pumpState.m_60734_() == TFCBlocks.STEEL_PUMP.get() && face == pumpState.m_61143_(FluidPumpBlock.FACING)) {
                RenderHelpers.renderTexturedCuboid(stack, buffer, RenderHelpers.blockTexture(PUMP_TEXTURE), packedLight, packedOverlay, -0.125f, -0.125f, -1.125f, 0.125f, 0.125f, -0.875f);
            }
            stack.m_252781_(Axis.f_252529_.m_252961_(movement.raiseAngle()));
            RenderHelpers.renderTexturedCuboid(stack, buffer, rodSprite, packedLight, packedOverlay, -0.0625f, -0.0625f, -0.0625f, 0.0625f, 0.0625f, 0.8125f);
        }
        stack.m_85849_();
    }

    public boolean shouldRenderOffScreen(CrankshaftBlockEntity entity) {
        return true;
    }
}

