/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.rotation.AxleBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AxleBlockEntityRenderer
implements BlockEntityRenderer<AxleBlockEntity> {
    public static void renderAxle(PoseStack stack, MultiBufferSource bufferSource, ConnectedAxleBlock axle, Direction.Axis axis, int packedLight, int packedOverlay, float rotationAngle) {
        TextureAtlasSprite sprite = RenderHelpers.blockTexture(axle.getAxleTextureLocation());
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        stack.m_85836_();
        AxleBlockEntityRenderer.applyRotation(stack, axis, rotationAngle);
        RenderHelpers.renderTexturedCuboid(stack, buffer, sprite, packedLight, packedOverlay, 0.375f, 0.375f, 0.0f, 0.625f, 0.625f, 1.0f, false);
        stack.m_85849_();
    }

    public static void applyRotation(PoseStack stack, Direction.Axis axis, float rotationAngle) {
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        switch (axis) {
            case X: {
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case Y: {
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
        }
        stack.m_252781_(Axis.f_252403_.m_252961_(rotationAngle));
        stack.m_252880_(-0.5f, -0.5f, -0.5f);
    }

    public void render(AxleBlockEntity axle, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        AxleBlock axleBlock;
        BlockState state;
        block3: {
            block2: {
                state = axle.m_58900_();
                Level level = axle.m_58904_();
                Block block = state.m_60734_();
                if (!(block instanceof AxleBlock)) break block2;
                axleBlock = (AxleBlock)block;
                if (level != null) break block3;
            }
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AxleBlock.f_55923_);
        AxleBlockEntityRenderer.renderAxle(stack, bufferSource, axleBlock, axis, packedLight, packedOverlay, -axle.getRotationAngle(partialTick));
    }
}

