/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class LeafParticle
extends TextureSheetParticle {
    private final float windMoveX;
    private final float windMoveZ;
    private final int xSignModifier;
    private final int zSignModifier;
    private final double xMod;
    private final double zMod;

    public LeafParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ, boolean tinted) {
        super(level, x, y, z);
        this.xSignModifier = this.f_107223_.m_188499_() ? 1 : -1;
        this.zSignModifier = this.f_107223_.m_188499_() ? 1 : -1;
        this.xMod = (this.f_107223_.m_188501_() - 0.5f) / 7.0f;
        this.zMod = (this.f_107223_.m_188501_() - 0.5f) / 7.0f;
        this.f_107225_ = 60 + this.f_107223_.m_188503_(20);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.m_6569_(Mth.m_216267_((RandomSource)this.f_107223_, (float)1.8f, (float)2.6f));
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (tinted) {
            BlockState state = level.m_8055_(pos);
            int color = Helpers.isBlock(state, TFCTags.Blocks.SEASONAL_LEAVES) ? TFCColors.getSeasonalFoliageColor(pos, 0, state.m_60734_() instanceof TFCLeavesBlock ? ((TFCLeavesBlock)state.m_60734_()).getAutumnIndex() : 0) : TFCColors.getFoliageColor(pos, 0);
            this.m_107253_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
        Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
        float windStrength = wind.m_165907_();
        this.windMoveX = wind.f_82470_ * windStrength * 0.2f;
        this.windMoveZ = wind.f_82471_ * windStrength * 0.2f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        float swayWave = 0.03f * Mth.m_14031_((float)((float)this.f_107224_ / 12.5f));
        float rollWave = 0.1f * Mth.m_14031_((float)((float)this.f_107224_ / 12.5f));
        this.f_107231_ = rollWave * (float)this.xSignModifier;
        this.f_107216_ -= 0.001;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ = (double)(swayWave * (float)this.xSignModifier) + this.xMod + (double)this.windMoveX;
        this.f_107216_ *= 0.96;
        this.f_107217_ = (double)(swayWave * (float)this.zSignModifier) + this.zMod + (double)this.windMoveZ;
        if (this.f_107218_) {
            this.f_107230_ = (float)((double)this.f_107230_ + 0.04);
            if (this.f_107230_ >= 1.0f) {
                this.m_107274_();
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Provider(SpriteSet set, boolean tinted) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LeafParticle particle = new LeafParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.tinted);
            particle.m_108335_(this.set);
            return particle;
        }
    }
}

