/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.dries007.tfc.world.Codecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidParticleOption
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<FluidParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<FluidParticleOption>(){

        public FluidParticleOption fromCommand(ParticleType<FluidParticleOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            ResourceLocation res = ResourceLocation.m_135818_((StringReader)reader);
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(res);
            return new FluidParticleOption(type, fluid);
        }

        public FluidParticleOption fromNetwork(ParticleType<FluidParticleOption> type, FriendlyByteBuf buffer) {
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7942_(buffer.m_130242_());
            return new FluidParticleOption(type, fluid);
        }
    };
    private final ParticleType<FluidParticleOption> type;
    private final Fluid fluid;

    public static Codec<FluidParticleOption> getCodec(ParticleType<FluidParticleOption> type) {
        return Codecs.FLUID.xmap(f -> new FluidParticleOption(type, (Fluid)f), o -> o.fluid);
    }

    public FluidParticleOption(ParticleType<FluidParticleOption> type, Fluid fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(BuiltInRegistries.f_257020_.m_7447_((Object)this.fluid));
    }

    public String m_5942_() {
        return BuiltInRegistries.f_257034_.m_7981_(this.type) + " " + new FluidStack(this.fluid, 1).getDisplayName();
    }
}

