/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import java.util.stream.Stream;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MooseModel
extends HierarchicalAnimatedModel<RammingPrey> {
    public static final AnimationDefinition MOOSE_RUN = AnimationDefinition.Builder.m_232275_((float)0.9583434f).m_232274_().m_232279_("neck", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-4.5661516f, (float)5.398936f, (float)4.5661516f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.89099824f, (float)2.4405522f, (float)1.5636137f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-3.6843684f, (float)-4.6235404f, (float)-5.3985906f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("left_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("right_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
    public static final AnimationDefinition MOOSE_EAT_GRASS = AnimationDefinition.Builder.m_232275_((float)12.291676f).m_232279_("moose", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("body", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.125f, KeyframeAnimations.m_253186_((float)-17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(11.041676f, KeyframeAnimations.m_253186_((float)-17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(12.291676f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("neck", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.125f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(11.791676f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(12.291676f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("neck", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.125f, KeyframeAnimations.m_253186_((float)-31.97f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(11.791676f, KeyframeAnimations.m_253186_((float)-31.97f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(12.291676f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(3.7916765f, KeyframeAnimations.m_253186_((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(5.291677f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(6.583433f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(7.834333f, KeyframeAnimations.m_253186_((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(9.541676f, KeyframeAnimations.m_253186_((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(11.25f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("bone3", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.125f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("bone4", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.125f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
    public static final AnimationDefinition MOOSE_WALK = AnimationDefinition.Builder.m_232275_((float)1.5834333f).m_232274_().m_232279_("neck", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.375f, KeyframeAnimations.m_253186_((float)-4.5661516f, (float)5.398936f, (float)4.5661516f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.8343334f, KeyframeAnimations.m_253186_((float)2.8063273f, (float)0.27423415f, (float)-0.57548606f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)-4.680253f, (float)-4.254786f, (float)-4.722189f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5834333f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4167667f, KeyframeAnimations.m_253186_((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5834333f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("left_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4167667f, KeyframeAnimations.m_253186_((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5834333f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("right_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4167667f, KeyframeAnimations.m_253186_((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5834333f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4167667f, KeyframeAnimations.m_253186_((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5834333f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
    private final ModelPart moose;
    private final ModelPart neck;
    private final ModelPart antler1;
    private final ModelPart antler2;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart head;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition moose = partdefinition.m_171599_("moose", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)41.0f, (float)23.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition body = moose.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -5.04f, -0.168f, 14.0f, 17.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-48.0f, (float)-2.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(50, 43).m_171488_(-1.0f, -38.4515f, -5.4433f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)35.0f, (float)-9.0f, (float)-0.3578f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-8.0f, -54.0f, 1.0f, 16.0f, 21.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)46.0f, (float)26.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(62, 25).m_171488_(-3.5f, 1.7643f, 0.1755f, 6.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-9.7643f, (float)31.8245f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(67, 86).m_171488_(0.0074f, 2.923f, -8.4288f, 0.0f, 9.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0074f, (float)6.5199f, (float)17.5063f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(6, 82).m_171488_(-1.6981f, -2.2641f, -5.9761f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.8876f, (float)-5.2647f, (float)4.9703f, (float)-0.0763f, (float)-0.0886f, (float)-0.2467f));
        PartDefinition cube_r4 = head.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171488_(-2.3019f, -2.3506f, -5.9845f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.8683f, (float)-5.0215f, (float)4.8818f, (float)-0.0326f, (float)0.0886f, (float)0.2467f));
        PartDefinition cube_r5 = head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(83, 0).m_171488_(-3.0f, -57.0f, 50.0f, 6.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(92, 16).m_171488_(-4.0f, -60.0f, 41.0f, 8.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4926f, (float)35.923f, (float)-60.4288f, (float)-0.3578f, (float)0.0f, (float)0.0f));
        PartDefinition left_antler = head.m_171599_("left_antler", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-13.9398f, (float)-8.9723f, (float)4.6713f, (float)0.4349f, (float)0.0368f, (float)-0.0791f));
        PartDefinition cube_r6 = left_antler.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(54, 12).m_171488_(4.9564f, 5.3252f, -1.6931f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(92, 35).m_171488_(0.9564f, 1.3252f, -1.6931f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.8055f, (float)1.0429f, (float)1.1749f, (float)0.0627f, (float)0.6157f, (float)-0.5853f));
        PartDefinition cube_r7 = left_antler.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(68, 60).m_171488_(-6.7375f, -2.0783f, 1.4421f, 12.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.9419f, (float)8.7268f, (float)7.112f, (float)-2.9171f, (float)1.465f, (float)2.041f));
        PartDefinition cube_r8 = left_antler.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(50, 53).m_171488_(-2.6847f, 1.3137f, -3.7996f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.4218f, (float)5.1432f, (float)1.1283f, (float)-0.8226f, (float)0.1677f, (float)0.0781f));
        PartDefinition cube_r9 = left_antler.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(54, 9).m_171488_(-4.037f, -0.6194f, -0.4597f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.6471f, (float)5.1476f, (float)-0.4881f, (float)-0.6757f, (float)1.1065f, (float)-1.9179f));
        PartDefinition cube_r10 = left_antler.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(58, 43).m_171488_(-0.0436f, -5.6221f, -1.7214f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.8055f, (float)1.0429f, (float)1.1749f, (float)0.0191f, (float)0.6157f, (float)-0.5853f));
        PartDefinition cube_r11 = left_antler.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(1.9564f, -10.5683f, -1.7474f, 2.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.8055f, (float)1.0429f, (float)1.1749f, (float)-0.0245f, (float)0.6157f, (float)-0.5853f));
        PartDefinition cube_r12 = left_antler.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(6, 89).m_171488_(0.1075f, -4.8409f, -1.9375f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0766f, (float)-6.9028f, (float)-3.0826f, (float)0.0626f, (float)0.5558f, (float)-0.1181f));
        PartDefinition cube_r13 = left_antler.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(80, 63).m_171488_(0.1075f, -2.463f, -1.8588f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5834f, (float)-6.7346f, (float)-4.5476f, (float)0.1499f, (float)0.5558f, (float)-0.1181f));
        PartDefinition cube_r14 = left_antler.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(31, 82).m_171488_(0.1075f, -6.463f, -1.8588f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.4781f, (float)-6.1341f, (float)-1.3821f, (float)0.1499f, (float)0.5558f, (float)-0.1181f));
        PartDefinition cube_r15 = left_antler.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(3.1075f, -10.1321f, 0.7786f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.4725f, (float)4.8411f, (float)0.632f, (float)0.2808f, (float)0.5558f, (float)-0.1181f));
        PartDefinition bone = left_antler.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.9419f, (float)5.7268f, (float)7.112f, (float)0.2618f, (float)-0.3491f, (float)0.0f));
        PartDefinition cube_r16 = bone.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(76, 56).m_171488_(-4.0915f, -2.8079f, 1.6677f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)-2.9171f, (float)1.465f, (float)2.041f));
        PartDefinition cube_r17 = bone.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(54, 6).m_171488_(-4.0686f, -1.4158f, -0.189f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.2949f, (float)-2.5792f, (float)-7.6002f, (float)-0.6757f, (float)1.1065f, (float)-1.9179f));
        PartDefinition right_antler = head.m_171599_("right_antler", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)16.6547f, (float)-8.2266f, (float)6.3154f, (float)0.4349f, (float)-0.0368f, (float)0.0791f));
        PartDefinition cube_r18 = right_antler.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(16, 19).m_171488_(-7.9564f, 5.3252f, -1.6931f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(50, 90).m_171488_(-8.9564f, 1.3252f, -1.6931f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0627f, (float)-0.6157f, (float)0.5853f));
        PartDefinition cube_r19 = right_antler.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(50, 57).m_171488_(-5.2625f, -2.0783f, 1.4421f, 12.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.7474f, (float)7.6839f, (float)5.9371f, (float)-2.9171f, (float)-1.465f, (float)-2.041f));
        PartDefinition cube_r20 = right_antler.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-7.3153f, 1.3137f, -3.7996f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.2273f, (float)4.1003f, (float)-0.0466f, (float)-0.8226f, (float)-0.1677f, (float)-0.0781f));
        PartDefinition cube_r21 = right_antler.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(54, 3).m_171488_(-2.963f, -0.6194f, -0.4597f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.4526f, (float)4.1047f, (float)-1.663f, (float)-0.6757f, (float)-1.1065f, (float)1.9179f));
        PartDefinition cube_r22 = right_antler.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.9564f, -5.6221f, -1.7214f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0191f, (float)-0.6157f, (float)0.5853f));
        PartDefinition cube_r23 = right_antler.m_171599_("cube_r23", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-3.9564f, -10.5683f, -1.7474f, 2.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0245f, (float)-0.6157f, (float)0.5853f));
        PartDefinition cube_r24 = right_antler.m_171599_("cube_r24", CubeListBuilder.m_171558_().m_171514_(83, 0).m_171488_(-2.1075f, -4.8409f, -1.9375f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.7289f, (float)-7.9457f, (float)-4.2575f, (float)0.0626f, (float)-0.5558f, (float)0.1181f));
        PartDefinition cube_r25 = right_antler.m_171599_("cube_r25", CubeListBuilder.m_171558_().m_171514_(62, 12).m_171488_(-2.1075f, -2.463f, -1.8588f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.3889f, (float)-7.7776f, (float)-5.7225f, (float)0.1499f, (float)-0.5558f, (float)0.1181f));
        PartDefinition cube_r26 = right_antler.m_171599_("cube_r26", CubeListBuilder.m_171558_().m_171514_(25, 82).m_171488_(-2.1075f, -6.463f, -1.8588f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6726f, (float)-7.177f, (float)-2.557f, (float)0.1499f, (float)-0.5558f, (float)0.1181f));
        PartDefinition cube_r27 = right_antler.m_171599_("cube_r27", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-11.1075f, -10.1321f, 0.7786f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.667f, (float)3.7982f, (float)-0.5429f, (float)0.2808f, (float)-0.5558f, (float)0.1181f));
        PartDefinition bone2 = right_antler.m_171599_("bone2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.7474f, (float)4.6839f, (float)5.9371f, (float)0.2618f, (float)0.3491f, (float)0.0f));
        PartDefinition cube_r28 = bone2.m_171599_("cube_r28", CubeListBuilder.m_171558_().m_171514_(73, 53).m_171488_(-4.9085f, -2.8079f, 1.6677f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)-2.9171f, (float)-1.465f, (float)-2.041f));
        PartDefinition cube_r29 = bone2.m_171599_("cube_r29", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-2.9314f, -1.4158f, -0.189f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.2949f, (float)-2.5792f, (float)-7.6002f, (float)-0.6757f, (float)-1.1065f, (float)1.9179f));
        PartDefinition left_hind_leg = moose.m_171599_("left_hind_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-38.9634f, (float)-2.1665f));
        PartDefinition cube_r30 = left_hind_leg.m_171599_("cube_r30", CubeListBuilder.m_171558_().m_171514_(0, 103).m_171488_(-8.0f, -39.0f, -21.5f, 4.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)42.9634f, (float)26.1665f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r31 = left_hind_leg.m_171599_("cube_r31", CubeListBuilder.m_171558_().m_171514_(81, 78).m_171488_(-9.0f, -8.9699f, -10.5488f, 6.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)-1.0366f, (float)2.1665f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = moose.m_171599_("left_front_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)-42.9128f, (float)30.7086f));
        PartDefinition bone3 = left_front_leg.m_171599_("bone3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-2.0872f, (float)-0.7086f));
        PartDefinition cube_r32 = bone3.m_171599_("cube_r32", CubeListBuilder.m_171558_().m_171514_(51, 65).m_171488_(-9.0f, 19.0f, -55.0f, 6.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)49.0f, (float)26.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition bone5 = left_front_leg.m_171599_("bone5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)46.9128f, (float)28.2914f));
        PartDefinition cube_r33 = bone5.m_171599_("cube_r33", CubeListBuilder.m_171558_().m_171514_(25, 86).m_171488_(-8.0f, 25.0f, -38.0f, 4.0f, 4.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_leg = moose.m_171599_("right_front_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-42.9128f, (float)30.7086f));
        PartDefinition bone4 = right_front_leg.m_171599_("bone4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)-2.0872f, (float)-0.7086f));
        PartDefinition cube_r34 = bone4.m_171599_("cube_r34", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-10.0f, 19.0f, -55.0f, 6.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)49.0f, (float)26.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition bone6 = right_front_leg.m_171599_("bone6", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)34.9128f, (float)0.2914f));
        PartDefinition cube_r35 = bone6.m_171599_("cube_r35", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(4.0f, 25.0f, -38.0f, 4.0f, 4.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)12.0f, (float)28.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = moose.m_171599_("right_hind_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-38.9634f, (float)-2.1665f));
        PartDefinition cube_r36 = right_hind_leg.m_171599_("cube_r36", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -39.0f, -21.5f, 4.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)42.9634f, (float)26.1665f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r37 = right_hind_leg.m_171599_("cube_r37", CubeListBuilder.m_171558_().m_171514_(80, 53).m_171488_(4.0f, -8.9699f, -10.5488f, 6.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-1.0366f, (float)2.1665f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public MooseModel(ModelPart root) {
        super(root);
        this.moose = root.m_171324_("moose");
        this.neck = this.moose.m_171324_("body").m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.antler1 = this.head.m_171324_("left_antler");
        this.antler2 = this.head.m_171324_("right_antler");
        this.rightHindLeg = this.moose.m_171324_("right_hind_leg");
        this.leftHindLeg = this.moose.m_171324_("left_hind_leg");
        this.rightFrontLeg = this.moose.m_171324_("right_front_leg");
        this.leftFrontLeg = this.moose.m_171324_("left_front_leg");
    }

    public void setupAnim(RammingPrey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        boolean antlers = entity.displayMaleCharacteristics();
        Stream.concat(this.antler1.m_171331_(), this.antler2.m_171331_()).forEach(p -> {
            p.f_104207_ = antlers;
        });
        float speed = this.getAdjustedLandSpeed(entity);
        if (speed > 1.0f) {
            this.m_267799_(MOOSE_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (entity.isTelegraphingAttack()) {
            this.head.f_104203_ = (float)entity.getTelegraphAttackTick() * ((float)Math.PI / 180) * -1.0f;
            this.neck.f_104203_ = (float)entity.getTelegraphAttackTick() * ((float)Math.PI / 180) * -1.0f;
        } else {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.6f;
            this.neck.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.4f;
            this.head.f_104204_ = headYaw * ((float)Math.PI / 180) * 0.6f;
            this.neck.f_104204_ = headYaw * ((float)Math.PI / 180) * 0.4f;
        }
    }
}

