/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;

public enum IngotPileBlockModel implements SimpleStaticBlockEntityModel<IngotPileBlockModel, IngotPileBlockEntity>
{
    INSTANCE;


    @Override
    public TextureAtlasSprite render(IngotPileBlockEntity pile, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        int ingots = (Integer)pile.m_58900_().m_61143_((Property)IngotPileBlock.COUNT);
        Function textureAtlas = Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS);
        TextureAtlasSprite sprite = null;
        for (int i = 0; i < ingots; ++i) {
            Metal metal = pile.getOrCacheMetal(i);
            sprite = (TextureAtlasSprite)textureAtlas.apply(metal.getSoftTextureId());
            int layer = (i + 8) / 8;
            boolean oddLayer = layer % 2 == 1;
            float x = (float)(i % 4) * 0.25f;
            float y = (float)(layer - 1) * 0.125f;
            float z = i % 8 >= 4 ? 0.5f : 0.0f;
            poseStack.m_85836_();
            if (oddLayer) {
                poseStack.m_252880_(0.5f, 0.0f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
            }
            poseStack.m_252880_(x, y, z);
            float scale = 0.03125f;
            float minX = 0.015625f;
            float minY = 0.0f;
            float minZ = 0.015625f;
            float maxX = 0.21923828f;
            float maxY = 0.125f;
            float maxZ = 0.46923828f;
            RenderHelpers.renderTexturedTrapezoidalCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, 0.015625f, 0.21923828f, 0.015625f, 0.46923828f, 0.046875f, 0.18798828f, 0.046875f, 0.43798828f, 0.0f, 0.125f, 7.0f, 4.0f, 15.0f, oddLayer);
            poseStack.m_85849_();
        }
        if (sprite == null) {
            sprite = RenderHelpers.missingTexture();
        }
        return sprite;
    }

    @Override
    public BlockEntityType<IngotPileBlockEntity> type() {
        return (BlockEntityType)TFCBlockEntities.INGOT_PILE.get();
    }

    @Override
    public int faces(IngotPileBlockEntity blockEntity) {
        return (Integer)blockEntity.m_58900_().m_61143_((Property)IngotPileBlock.COUNT) * 6;
    }
}

