/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Locale;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.player.PlayerData;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.config.DisabledExperienceBarStyle;
import net.dries007.tfc.config.HealthDisplayStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.jetbrains.annotations.Nullable;

public final class IngameOverlays
extends Enum<IngameOverlays> {
    public static final /* enum */ IngameOverlays HEALTH = new IngameOverlays(IngameOverlays::renderHealth);
    public static final /* enum */ IngameOverlays MOUNT_HEALTH = new IngameOverlays(IngameOverlays::renderMountHealth);
    public static final /* enum */ IngameOverlays FOOD = new IngameOverlays(IngameOverlays::renderFood);
    public static final /* enum */ IngameOverlays THIRST = new IngameOverlays(IngameOverlays::renderThirst);
    public static final /* enum */ IngameOverlays INK = new IngameOverlays(IngameOverlays::renderInk);
    public static final /* enum */ IngameOverlays CHISEL = new IngameOverlays(IngameOverlays::renderChiselMode);
    public static final /* enum */ IngameOverlays EXPERIENCE = new IngameOverlays(IngameOverlays::renderExperience);
    public static final /* enum */ IngameOverlays JUMP_BAR = new IngameOverlays(IngameOverlays::renderJumpBar);
    public static final /* enum */ IngameOverlays HUD_MOVER = new IngameOverlays(IngameOverlays::moveLeftAndRightHeights);
    public static final /* enum */ IngameOverlays FAMILIARITY = new IngameOverlays(IngameOverlays::renderFamiliarity);
    private final String id = this.name().toLowerCase(Locale.ROOT);
    final IGuiOverlay overlay;
    public static final ResourceLocation TEXTURE;
    public static final ResourceLocation INK_TEXTURE;
    public static final ResourceLocation GLOW_INK_TEXTURE;
    private static final ResourceLocation VANILLA_HEALTH;
    private static final ResourceLocation VANILLA_MOUNT_HEALTH;
    private static final ResourceLocation VANILLA_FOOD;
    private static final ResourceLocation VANILLA_EXP;
    private static final ResourceLocation VANILLA_JUMP;
    private static final /* synthetic */ IngameOverlays[] $VALUES;

    public static IngameOverlays[] values() {
        return (IngameOverlays[])$VALUES.clone();
    }

    public static IngameOverlays valueOf(String name) {
        return Enum.valueOf(IngameOverlays.class, name);
    }

    private IngameOverlays(IGuiOverlay overlay) {
        this.overlay = overlay;
    }

    public ResourceLocation id() {
        return Helpers.identifier(this.id);
    }

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        IngameOverlays.above(event, VanillaGuiOverlay.PLAYER_HEALTH, HEALTH);
        IngameOverlays.above(event, VanillaGuiOverlay.MOUNT_HEALTH, MOUNT_HEALTH);
        IngameOverlays.above(event, VanillaGuiOverlay.FOOD_LEVEL, FOOD);
        IngameOverlays.above(event, VanillaGuiOverlay.FOOD_LEVEL, THIRST);
        IngameOverlays.above(event, VanillaGuiOverlay.EXPERIENCE_BAR, EXPERIENCE);
        IngameOverlays.above(event, VanillaGuiOverlay.JUMP_BAR, JUMP_BAR);
        IngameOverlays.above(event, VanillaGuiOverlay.PLAYER_HEALTH, HUD_MOVER);
        IngameOverlays.above(event, VanillaGuiOverlay.CROSSHAIR, FAMILIARITY);
        IngameOverlays.top(event, INK);
        IngameOverlays.top(event, CHISEL);
    }

    private static void above(RegisterGuiOverlaysEvent event, VanillaGuiOverlay vanilla, IngameOverlays overlay) {
        event.registerAbove(vanilla.id(), overlay.id, overlay.overlay);
    }

    private static void top(RegisterGuiOverlaysEvent event, IngameOverlays overlay) {
        event.registerAboveAll(overlay.id, overlay.overlay);
    }

    public static void checkGuiOverlays(RenderGuiOverlayEvent.Pre event) {
        ResourceLocation id = event.getOverlay().id();
        if (id.equals((Object)VANILLA_EXP) || id.equals((Object)VANILLA_JUMP)) {
            event.setCanceled(true);
        } else if (IngameOverlays.enableThisOrThat(id, (Boolean)TFCConfig.CLIENT.enableHungerBar.get(), FOOD.id(), VANILLA_FOOD) || IngameOverlays.enableThisOrThat(id, (Boolean)TFCConfig.CLIENT.enableHealthBar.get(), HEALTH.id(), VANILLA_HEALTH) || IngameOverlays.enableThisOrThat(id, (Boolean)TFCConfig.CLIENT.enableHealthBar.get(), MOUNT_HEALTH.id(), VANILLA_MOUNT_HEALTH)) {
            event.setCanceled(true);
        } else if (IngameOverlays.disableIfFalse(id, (Boolean)TFCConfig.CLIENT.enableThirstBar.get(), THIRST.id()) || IngameOverlays.disableIfFalse(id, (Boolean)TFCConfig.CLIENT.enableInkSplatter.get(), INK.id())) {
            event.setCanceled(true);
        }
    }

    private static boolean enableThisOrThat(ResourceLocation id, boolean config, ResourceLocation myOverlay, ResourceLocation vanillaOverlay) {
        return config && id.equals((Object)vanillaOverlay) || !config && id.equals((Object)myOverlay);
    }

    private static boolean disableIfFalse(ResourceLocation id, boolean config, ResourceLocation myOverlay) {
        return id.equals((Object)myOverlay) && !config;
    }

    public static void renderHealth(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            IngameOverlays.renderHealthBar((LivingEntity)player, gui, graphics, width, height);
        }
    }

    public static void renderMountHealth(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            Entity entity = player.m_20202_();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                IngameOverlays.renderHealthBar(entity2, gui, graphics, width, height);
            }
        }
    }

    public static void renderFood(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        PoseStack stack = graphics.m_280168_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            int x = width / 2;
            int y = height - gui.rightHeight;
            float percentFood = (float)player.m_36324_().m_38702_() / 20.0f;
            stack.m_85836_();
            stack.m_252880_((float)(x + 1), (float)(y + 4), 0.0f);
            graphics.m_280218_(TEXTURE, 0, 0, 0, 20, 90, 5);
            graphics.m_280218_(TEXTURE, 0, 0, 0, 25, (int)(90.0f * percentFood), 5);
            stack.m_85849_();
            gui.rightHeight += 6;
        }
    }

    public static void renderThirst(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        PoseStack stack = graphics.m_280168_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            int x = width / 2;
            int y = height - gui.rightHeight;
            float percentThirst = 0.0f;
            float overheat = 0.0f;
            FoodData foodData = player.m_36324_();
            if (foodData instanceof TFCFoodData) {
                TFCFoodData data = (TFCFoodData)foodData;
                percentThirst = data.getThirst() / 100.0f;
                overheat = data.getThirstContributionFromTemperature(player);
            }
            stack.m_85836_();
            stack.m_252880_((float)(x + 1), (float)(y + 4), 0.0f);
            graphics.m_280218_(TEXTURE, 0, 0, 90, 20, 90, 5);
            graphics.m_280218_(TEXTURE, 0, 0, 90, 25, (int)(90.0f * percentThirst), 5);
            if (overheat > 0.0f) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(overheat / 0.4f));
                graphics.m_280218_(TEXTURE, 0, 0, 90, 30, 90, 5);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            stack.m_85849_();
            gui.rightHeight += 6;
        }
    }

    private static void renderChiselMode(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Player player;
        PoseStack stack = graphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        if (IngameOverlays.setup(gui, mc) && (player = ClientHelpers.getPlayer()) != null && Helpers.isItem(player.m_21120_(InteractionHand.MAIN_HAND), TFCTags.Items.CHISELS)) {
            int u = 60;
            if (Helpers.isItem(player.m_21120_(InteractionHand.OFF_HAND), TFCTags.Items.HAMMERS)) {
                u = PlayerData.get(player).getChiselMode().ordinal() * 20;
            }
            stack.m_85836_();
            graphics.m_280218_(TEXTURE, width / 2 + 100, height - 21, u, 58, 20, 20);
            stack.m_85849_();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void renderExperience(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        FishingHook fishingHook;
        boolean isStyleLeftHotbar;
        PoseStack stack = graphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        @Nullable LocalPlayer localPlayer = mc.f_91074_;
        boolean isShowingExperience = (Boolean)TFCConfig.CLIENT.enableExperienceBar.get();
        boolean bl = isStyleLeftHotbar = TFCConfig.CLIENT.disabledExperienceBarStyle.get() == DisabledExperienceBarStyle.LEFT_HOTBAR;
        if (localPlayer != null && (fishingHook = localPlayer.f_36083_) instanceof TFCFishingHook) {
            TFCFishingHook hook = (TFCFishingHook)fishingHook;
            if (IngameOverlays.setup(gui, mc)) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                if (!isShowingExperience && isStyleLeftHotbar) {
                    int uOffset;
                    int barHeight;
                    if (localPlayer.m_20202_() instanceof LivingEntity && ((Boolean)TFCConfig.CLIENT.enableHealthBar.get()).booleanValue()) {
                        barHeight = 42;
                        uOffset = 164;
                    } else {
                        barHeight = 32;
                        uOffset = 153;
                    }
                    int x = width / 2 - 97;
                    int y = height - barHeight;
                    int texturePos = 36 + barHeight;
                    int amount = Mth.m_14167_((float)Mth.m_184631_((float)hook.pullExhaustion, (float)0.0f, (float)100.0f, (float)0.0f, (float)(barHeight + 1)));
                    graphics.m_280218_(TEXTURE, x, y, uOffset, 36, 5, barHeight);
                    if (amount > 0) {
                        graphics.m_280218_(TEXTURE, x, height - amount, uOffset + 5, texturePos - amount, 5, amount);
                    }
                } else {
                    int x = width / 2 - 91;
                    int y = height - 29;
                    int amount = Mth.m_14167_((float)Mth.m_184631_((float)hook.pullExhaustion, (float)0.0f, (float)100.0f, (float)0.0f, (float)183.0f));
                    graphics.m_280218_(TEXTURE, x, y, 0, 111, 182, 5);
                    if (amount > 0) {
                        graphics.m_280218_(TEXTURE, x, y, 0, 116, amount, 5);
                    }
                }
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                return;
            }
        }
        if (!isShowingExperience) return;
        NamedGuiOverlay overlay = GuiOverlayManager.findOverlay((ResourceLocation)VANILLA_EXP);
        if (overlay == null) return;
        overlay.overlay().render(gui, graphics, partialTicks, width, height);
    }

    private static void renderJumpBar(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        boolean isStyleLeftHotbar;
        PoseStack stack = graphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        boolean isShowingExperience = (Boolean)TFCConfig.CLIENT.enableExperienceBar.get();
        boolean bl = isStyleLeftHotbar = TFCConfig.CLIENT.disabledExperienceBarStyle.get() == DisabledExperienceBarStyle.LEFT_HOTBAR;
        if (isShowingExperience || !isStyleLeftHotbar) {
            NamedGuiOverlay overlay = GuiOverlayManager.findOverlay((ResourceLocation)VANILLA_JUMP);
            if (overlay != null) {
                overlay.overlay().render(gui, graphics, partialTicks, width, height);
            }
        } else if (localPlayer != null && localPlayer.m_245714_() != null && IngameOverlays.setup(gui, mc)) {
            int uOffset;
            int barHeight;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            if (((Boolean)TFCConfig.CLIENT.enableHealthBar.get()).booleanValue()) {
                barHeight = 42;
                uOffset = 186;
            } else {
                barHeight = 32;
                uOffset = 175;
            }
            int x = width / 2 - 97;
            int y = height - barHeight;
            int texturePos = 36 + barHeight;
            int charge = (int)(localPlayer.m_108634_() * (float)(barHeight + 1));
            graphics.m_280218_(TEXTURE, x, y, uOffset, 36, 5, barHeight);
            if (charge > 0) {
                graphics.m_280218_(TEXTURE, x, height - charge, uOffset + 5, texturePos - charge, 5, charge);
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void renderInk(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && (player = Minecraft.m_91087_().f_91074_) != null) {
            if (player.m_21023_((MobEffect)TFCEffects.INK.get())) {
                IngameOverlays.renderTextureOverlay(graphics, INK_TEXTURE, 1.0f);
            } else if (player.m_21023_((MobEffect)TFCEffects.GLOW_INK.get())) {
                IngameOverlays.renderTextureOverlay(graphics, GLOW_INK_TEXTURE, 1.0f);
            }
        }
    }

    private static void renderHealthBar(LivingEntity entity, ForgeGui gui, GuiGraphics graphics, int width, int height) {
        float f;
        Player player;
        FoodData foodData;
        float surplusPercent;
        Player player2;
        boolean playerHasSaturation;
        PoseStack stack = graphics.m_280168_();
        HealthDisplayStyle style = (HealthDisplayStyle)((Object)TFCConfig.CLIENT.healthDisplayStyle.get());
        float maxHealth = entity.m_21233_();
        int centerX = width / 2;
        int y = height - gui.leftHeight;
        stack.m_85836_();
        stack.m_252880_((float)(centerX - 91), (float)y, 0.0f);
        graphics.m_280218_(TEXTURE, 0, 0, 0, 0, 90, 10);
        float absorption = entity.m_6103_();
        absorption = Float.isNaN(absorption) ? 0.0f : absorption;
        float percentHealth = (entity.m_21223_() + absorption) / entity.m_21233_();
        float currentHealth = percentHealth * maxHealth;
        percentHealth = Mth.m_14036_((float)percentHealth, (float)0.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, 0, 0, 0, 10, (int)(90.0f * percentHealth), 10);
        boolean isHurt = entity.m_21223_() > 0.0f && entity.m_21223_() < entity.m_21233_();
        boolean bl = playerHasSaturation = entity instanceof Player && (player2 = (Player)entity).m_36324_().m_38722_() > 0.0f;
        if (playerHasSaturation && isHurt || entity.f_20916_ > 0 || entity.m_21023_(MobEffects.f_19605_)) {
            graphics.m_280218_(TEXTURE, 0, 1, 0, 30, 90, 8);
        }
        if ((surplusPercent = Mth.m_14036_((float)(percentHealth + absorption / 20.0f - 1.0f), (float)0.0f, (float)1.0f)) > 0.0f) {
            float percent = Math.min(surplusPercent, 1.0f);
            graphics.m_280218_(TEXTURE, 0, 0, 90, 10, (int)(90.0f * percent), 10);
        }
        stack.m_85849_();
        if (entity instanceof Player && (foodData = (player = (Player)entity).m_36324_()) instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            f = data.getHealthModifier();
        } else {
            f = 1.0f;
        }
        float healthModifier = f;
        String text = style.format(currentHealth * healthModifier, maxHealth * healthModifier);
        stack.m_85836_();
        stack.m_85837_((double)(centerX - 45), (double)y + 2.5, 0.0);
        stack.m_85841_(0.8f, 0.8f, 1.0f);
        graphics.m_280056_(gui.m_93082_(), text, -1 * gui.m_93082_().m_92895_(text) / 2, 0, (double)surplusPercent < 0.6 ? Color.WHITE.getRGB() : Color.BLACK.getRGB(), false);
        stack.m_85849_();
        gui.leftHeight += 10;
    }

    private static void renderFamiliarity(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        TFCAnimalProperties animal;
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player.m_6144_() && IngameOverlays.setup(gui, mc) && (entity = mc.f_91076_) instanceof TFCAnimalProperties && (animal = (TFCAnimalProperties)entity).getAdultFamiliarityCap() > 0.0f && player.m_19950_(entity, 5.0)) {
            MammalProperties mammal;
            int fontColor;
            int u;
            PoseStack stack = graphics.m_280168_();
            stack.m_85836_();
            stack.m_252880_((float)width / 2.0f, (float)height / 2.0f - 45.0f, 0.0f);
            stack.m_85841_(1.5f, 1.5f, 1.5f);
            float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
            if (familiarity >= animal.getAdultFamiliarityCap() && animal.getAgeType() != TFCAnimalProperties.Age.CHILD) {
                u = 132;
                fontColor = Color.RED.getRGB();
            } else if (familiarity >= 0.3f) {
                u = 112;
                fontColor = Color.WHITE.getRGB();
            } else {
                u = 92;
                fontColor = Color.GRAY.getRGB();
            }
            if (((Boolean)TFCConfig.CLIENT.displayFamiliarityAsPercent.get()).booleanValue()) {
                String string = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
                graphics.m_280056_(mc.f_91062_, string, -mc.f_91062_.m_92895_(string) / 2, 0, fontColor, false);
            } else {
                graphics.m_280218_(TEXTURE, -8, 0, u, 40, 16, 16);
                stack.m_252880_(0.0f, 0.0f, -0.001f);
                graphics.m_280218_(TEXTURE, -6, 14 - (int)(12.0f * familiarity), familiarity == 1.0f ? 114 : 94, 74 - (int)(12.0f * familiarity), 12, (int)(12.0f * familiarity));
            }
            if (animal instanceof MammalProperties && (mammal = (MammalProperties)animal).getPregnantTime() > 0L && mammal.isFertilized()) {
                stack.m_252880_(0.0f, -15.0f, 0.0f);
                String string = Component.m_237110_((String)"tfc.tooltip.animal.pregnant", (Object[])new Object[]{entity.m_7755_().getString()}).getString();
                graphics.m_280056_(mc.f_91062_, string, -mc.f_91062_.m_92895_(string) / 2, 0, Color.WHITE.getRGB(), false);
            }
            stack.m_85849_();
        }
    }

    private static void renderTextureOverlay(GuiGraphics graphics, ResourceLocation location, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        graphics.m_280398_(location, 0, 0, -90, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void moveLeftAndRightHeights(ForgeGui gui, GuiGraphics stack, float partialTicks, int width, int height) {
        gui.rightHeight -= IngameOverlays.considerExperienceConfigs();
        gui.leftHeight -= IngameOverlays.considerExperienceConfigs();
    }

    private static boolean setupForSurvival(ForgeGui gui, Minecraft minecraft) {
        return gui.shouldDrawSurvivalElements() && IngameOverlays.setup(gui, minecraft);
    }

    public static boolean setup(ForgeGui gui, Minecraft minecraft) {
        if (!minecraft.f_91066_.f_92062_ && minecraft.m_91288_() instanceof Player) {
            gui.setupOverlayRenderState(true, false);
            return true;
        }
        return false;
    }

    private static int considerExperienceConfigs() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return switch ((DisabledExperienceBarStyle)((Object)TFCConfig.CLIENT.disabledExperienceBarStyle.get())) {
            case DisabledExperienceBarStyle.LEFT_HOTBAR -> 6;
            case DisabledExperienceBarStyle.BUMP -> {
                if (player != null && (player.f_36083_ instanceof TFCFishingHook || player.m_245714_() != null)) {
                    yield 0;
                }
                yield 6;
            }
            default -> 0;
        };
    }

    private static /* synthetic */ IngameOverlays[] $values() {
        return new IngameOverlays[]{HEALTH, MOUNT_HEALTH, FOOD, THIRST, INK, CHISEL, EXPERIENCE, JUMP_BAR, HUD_MOVER, FAMILIARITY};
    }

    static {
        $VALUES = IngameOverlays.$values();
        TEXTURE = Helpers.identifier("textures/gui/icons/overlay.png");
        INK_TEXTURE = Helpers.identifier("textures/misc/ink_splatter.png");
        GLOW_INK_TEXTURE = Helpers.identifier("textures/misc/glow_ink_splatter.png");
        VANILLA_HEALTH = VanillaGuiOverlay.PLAYER_HEALTH.id();
        VANILLA_MOUNT_HEALTH = VanillaGuiOverlay.MOUNT_HEALTH.id();
        VANILLA_FOOD = VanillaGuiOverlay.FOOD_LEVEL.id();
        VANILLA_EXP = VanillaGuiOverlay.EXPERIENCE_BAR.id();
        VANILLA_JUMP = VanillaGuiOverlay.JUMP_BAR.id();
    }
}

