/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.VertexConsumerWrapper;
import org.jetbrains.annotations.Nullable;

public interface IGhostBlockHandler {
    default public boolean draw(Level level, Player player, BlockState lookState, BlockPos lookPos, Vec3 location, Direction lookDirection, PoseStack stack, MultiBufferSource buffer, ItemStack item) {
        BlockState state = this.getStateToDraw(level, player, lookState, lookDirection, lookPos, location.f_82479_ - (double)lookPos.m_123341_(), location.f_82480_ - (double)lookPos.m_123342_(), location.f_82481_ - (double)lookPos.m_123343_(), item);
        if (state == null || !level.f_46443_) {
            return false;
        }
        return RenderHelpers.renderGhostBlock(level, state, lookPos, stack, buffer, this.shouldGrowSlightly(), Mth.m_14143_((float)(this.alpha() * 255.0f)));
    }

    default public boolean shouldGrowSlightly() {
        return true;
    }

    default public float alpha() {
        return 0.66f;
    }

    @Nullable
    public BlockState getStateToDraw(Level var1, Player var2, BlockState var3, Direction var4, BlockPos var5, double var6, double var8, double var10, ItemStack var12);

    public static class ForcedAlphaVertexConsumer
    extends VertexConsumerWrapper {
        private final int alpha;

        public ForcedAlphaVertexConsumer(VertexConsumer wrapped, int alpha) {
            super(wrapped);
            this.alpha = alpha;
        }

        public VertexConsumer m_6122_(int r, int g, int b, int a) {
            return this.parent.m_6122_(r, g, b, a * this.alpha / 255);
        }
    }
}

