/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.HoeOverlays;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.client.IngameOverlays;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCBubbleColumnAmbientSoundHandler;
import net.dries007.tfc.client.TFCKeyBindings;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.capabilities.glass.GlassWorkData;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.items.EmptyPanItem;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.mixin.client.accessor.LocalPlayerAccessor;
import net.dries007.tfc.network.CycleChiselModePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.PlaceBlockSpecialPacket;
import net.dries007.tfc.network.RequestClimateModelPacket;
import net.dries007.tfc.network.StackFoodPacket;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Pannable;
import net.dries007.tfc.util.PhysicalDamageType;
import net.dries007.tfc.util.Sluiceable;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ToastAddEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class ClientForgeEventHandler {
    private static final Field CAP_NBT_FIELD = (Field)Helpers.uncheck(() -> {
        Field field = ItemStack.class.getDeclaredField("capNBT");
        field.setAccessible(true);
        return field;
    });
    private static float waterFogLevel = 1.0f;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ClientForgeEventHandler::onRenderGameOverlayText);
        bus.addListener(ClientForgeEventHandler::onRenderGameOverlayPost);
        bus.addListener(ClientForgeEventHandler::onItemTooltip);
        bus.addListener(ClientForgeEventHandler::onInitGuiPost);
        bus.addListener(ClientForgeEventHandler::onClientPlayerLoggedIn);
        bus.addListener(ClientForgeEventHandler::onClientPlayerLoggedOut);
        bus.addListener(ClientForgeEventHandler::onClientTick);
        bus.addListener(ClientForgeEventHandler::onKeyEvent);
        bus.addListener(ClientForgeEventHandler::onScreenKey);
        bus.addListener(ClientForgeEventHandler::onHighlightBlockEvent);
        bus.addListener(ClientForgeEventHandler::onFogRender);
        bus.addListener(ClientForgeEventHandler::onHandRender);
        bus.addListener(ClientForgeEventHandler::onToast);
        bus.addListener(ClientForgeEventHandler::onEffectRender);
        bus.addListener(IngameOverlays::checkGuiOverlays);
    }

    public static void onRenderGameOverlayText(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91066_.f_92063_ && ((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue()) {
            Entity camera = mc.m_91288_();
            assert (camera != null);
            BlockPos pos = BlockPos.m_274561_((double)camera.m_20185_(), (double)camera.m_20191_().f_82289_, (double)camera.m_20189_());
            if (mc.f_91073_.m_7232_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
                ChunkGenerator chunkGenerator;
                ArrayList tooltip = event.getLeft();
                tooltip.add("");
                tooltip.add(ChatFormatting.AQUA + "TerraFirmaCraft");
                tooltip.add(Component.m_237110_((String)"tfc.tooltip.calendar_date", (Object[])new Object[]{Calendars.CLIENT.getCalendarTimeAndDate()}).getString());
                tooltip.add("Avg: %.3f Actual: %.3f Rain: %.3f".formatted(Float.valueOf(ClimateRenderCache.INSTANCE.getAverageTemperature()), Float.valueOf(ClimateRenderCache.INSTANCE.getTemperature()), Float.valueOf(ClimateRenderCache.INSTANCE.getRainfall())));
                Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
                tooltip.add(Component.m_237110_((String)"tfc.tooltip.wind_speed", (Object[])new Object[]{Mth.m_14143_((float)(320.0f * wind.m_165907_())), String.format("%.0f", Float.valueOf(Mth.m_14154_((float)(wind.f_82470_ * 100.0f)))), Helpers.translateEnum(wind.f_82470_ > 0.0f ? Direction.EAST : Direction.WEST), String.format("%.0f", Float.valueOf(Mth.m_14154_((float)(wind.f_82471_ * 100.0f)))), Helpers.translateEnum(wind.f_82471_ > 0.0f ? Direction.SOUTH : Direction.NORTH)}).getString());
                tooltip.add("Tick: %d Calendar: %d Day: %d".formatted(Calendars.CLIENT.getTicks(), Calendars.CLIENT.getCalendarTicks(), camera.m_9236_().m_46468_()));
                ChunkData data = ChunkData.get((LevelReader)mc.f_91073_, pos);
                if (data.status() == ChunkData.Status.CLIENT) {
                    tooltip.add("F: %s Density: %.1f Weird: %.1f".formatted(data.getForestType().m_7912_(), Float.valueOf(data.getForestDensity()), Float.valueOf(data.getForestWeirdness())));
                } else {
                    tooltip.add("[Waiting for chunk data]");
                }
                WorldTracker.get((Level)mc.f_91073_).addDebugTooltip(tooltip);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null && (chunkGenerator = server.m_129783_().m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
                    ChunkGeneratorExtension ex = (ChunkGeneratorExtension)chunkGenerator;
                    int approxSurfaceY = mc.f_91073_.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
                    ex.chunkDataProvider().generator().displayDebugInfo(tooltip, pos, approxSurfaceY);
                }
            }
        }
    }

    public static void onRenderGameOverlayPost(RenderGuiOverlayEvent.Post event) {
        GuiGraphics stack = event.getGuiGraphics();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null) {
            boolean holdingHoe;
            boolean bl = holdingHoe = Helpers.isItem(player.m_21205_().m_41720_(), TFCTags.Items.HOES) || Helpers.isItem(player.m_21206_().m_41720_(), TFCTags.Items.HOES);
            if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && minecraft.f_91080_ == null && holdingHoe && (!((Boolean)TFCConfig.CLIENT.showHoeOverlaysOnlyWhenShifting.get()).booleanValue() || player.m_6144_())) {
                HoeOverlays.render(minecraft, event.getWindow(), stack);
            }
        }
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List text = event.getToolTip();
        if (!stack.m_41619_()) {
            BlockItem bi;
            boolean pan;
            MutableComponent heatTooltip;
            Metal metal;
            FluidStack fluid;
            ItemStackInventory inventory;
            HeatingRecipe recipe;
            Fertilizer fertilizer;
            MutableComponent heatTooltip2;
            Fuel fuel;
            IEgg egg;
            if (Helpers.isItem(stack, TFCTags.Items.SILICA_ITEMS)) {
                text.add(Component.m_237115_((String)"tfc.tooltip.glass.silica").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.HEMATITIC_ITEMS)) {
                text.add(Component.m_237115_((String)"tfc.tooltip.glass.hematitic").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.OLIVINE_ITEMS)) {
                text.add(Component.m_237115_((String)"tfc.tooltip.glass.olivine").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.VOLCANIC_ITEMS)) {
                text.add(Component.m_237115_((String)"tfc.tooltip.glass.volcanic").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.SEDIMENTARY_ITEMS)) {
                text.add(Helpers.translateEnum(RockCategory.SEDIMENTARY).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.METAMORPHIC_ITEMS)) {
                text.add(Helpers.translateEnum(RockCategory.METAMORPHIC).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.IGNEOUS_EXTRUSIVE_ITEMS)) {
                text.add(Helpers.translateEnum(RockCategory.IGNEOUS_EXTRUSIVE).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.IGNEOUS_INTRUSIVE_ITEMS)) {
                text.add(Helpers.translateEnum(RockCategory.IGNEOUS_INTRUSIVE).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.UNSEALED_JARS)) {
                text.add(Component.m_237115_((String)"tfc.tooltip.unsealed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else if (Helpers.isItem(stack, TFCTags.Items.SEALED_JARS)) {
                text.add(Component.m_237115_((String)"tfc.tooltip.sealed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
            ItemSizeManager.addTooltipInfo(stack, text);
            PhysicalDamageType.addTooltipInfo(stack, text);
            ForgingBonus.addTooltipInfo(stack, text);
            ForgingCapability.addTooltipInfo(stack, text);
            GlassWorkData.addTooltipInfo(stack, text);
            FoodCapability.addTooltipInfo(stack, text);
            @Nullable IHeat heat = HeatCapability.get(stack);
            if (heat != null) {
                heat.addTooltipInfo(stack, text);
            }
            if ((egg = EggCapability.get(stack)) != null) {
                egg.addTooltipInfo(text);
            }
            if ((fuel = Fuel.get(stack)) != null && (heatTooltip2 = ((TemperatureDisplayStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(fuel.getTemperature())) != null) {
                text.add(Component.m_237110_((String)"tfc.tooltip.fuel_burns_at", (Object[])new Object[]{heatTooltip2, Calendars.CLIENT.getTimeDelta(fuel.getDuration())}));
            }
            if ((fertilizer = Fertilizer.get(stack)) != null) {
                float n = fertilizer.getNitrogen();
                float p = fertilizer.getPhosphorus();
                float k = fertilizer.getPotassium();
                if (n != 0.0f) {
                    text.add(Component.m_237110_((String)"tfc.tooltip.fertilizer.nitrogen", (Object[])new Object[]{String.format("%.1f", Float.valueOf(n * 100.0f))}));
                }
                if (p != 0.0f) {
                    text.add(Component.m_237110_((String)"tfc.tooltip.fertilizer.phosphorus", (Object[])new Object[]{String.format("%.1f", Float.valueOf(p * 100.0f))}));
                }
                if (k != 0.0f) {
                    text.add(Component.m_237110_((String)"tfc.tooltip.fertilizer.potassium", (Object[])new Object[]{String.format("%.1f", Float.valueOf(k * 100.0f))}));
                }
            }
            if ((recipe = HeatingRecipe.getRecipe(inventory = new ItemStackInventory(stack))) != null && !(fluid = recipe.assembleFluid(inventory)).isEmpty() && (metal = Metal.get(fluid.getFluid())) != null && (heatTooltip = ((TemperatureDisplayStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(recipe.getTemperature())) != null) {
                text.add(Component.m_237110_((String)"tfc.tooltip.item_melts_into", (Object[])new Object[]{fluid.getAmount() * stack.m_41613_(), Component.m_237115_((String)metal.getTranslationKey()), heatTooltip}));
            }
            boolean sluice = Sluiceable.get(stack) != null;
            Item item = stack.m_41720_();
            boolean bl = pan = item instanceof BlockItem && Pannable.get((bi = (BlockItem)item).m_40614_().m_49966_()) != null;
            if (sluice && !pan) {
                text.add(Component.m_237115_((String)"tfc.tooltip.usable_in_sluice").m_130940_(ChatFormatting.GRAY));
            } else if (pan && !sluice) {
                text.add(Component.m_237115_((String)"tfc.tooltip.usable_in_pan").m_130940_(ChatFormatting.GRAY));
            } else if (pan && sluice) {
                text.add(Component.m_237115_((String)"tfc.tooltip.usable_in_sluice_and_pan").m_130940_(ChatFormatting.GRAY));
            }
            if (((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue() && event.getFlags().m_7050_()) {
                CompoundTag capTag;
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag != null) {
                    text.add(Component.m_237113_((String)(ChatFormatting.DARK_GRAY + "[Debug] NBT: " + stackTag)));
                }
                if ((capTag = (CompoundTag)Helpers.uncheck(() -> CAP_NBT_FIELD.get(stack))) != null && !capTag.m_128456_()) {
                    text.add(Component.m_237113_((String)(ChatFormatting.DARK_GRAY + "[Debug] Cap NBT: " + capTag)));
                }
                text.add(Component.m_237113_((String)(ChatFormatting.DARK_GRAY + "[Debug] Item Tags: " + stack.m_41720_().m_204114_().m_203616_().map(t1 -> "#" + t1.f_203868_()).collect(Collectors.joining(", ")))));
                Item item2 = stack.m_41720_();
                if (item2 instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item2;
                    Block block = blockItem.m_40614_();
                    text.add(Component.m_237113_((String)(ChatFormatting.DARK_GRAY + "[Debug] Block Tags: " + block.m_204297_().m_203616_().map(t -> "#" + t.f_203868_()).collect(Collectors.joining(", ")))));
                }
            }
        }
    }

    public static void onInitGuiPost(ScreenEvent.Init.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (player != null && !player.m_7500_()) {
                int guiLeft = screen2.getGuiLeft();
                int guiTop = screen2.getGuiTop();
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 173, 4, 23, 22, 148, 0, 1, 3, 0, 0, button -> {}).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 27, 20, 22, 128, 0, 1, 3, 32, 0, SwitchInventoryTabPacket.Type.CALENDAR).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 50, 20, 22, 128, 0, 1, 3, 64, 0, SwitchInventoryTabPacket.Type.NUTRITION).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 73, 20, 22, 128, 0, 1, 3, 96, 0, SwitchInventoryTabPacket.Type.CLIMATE).setRecipeBookCallback(screen2));
                PatchouliIntegration.ifEnabled(() -> event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 96, 20, 22, 128, 0, 1, 3, 0, 32, SwitchInventoryTabPacket.Type.BOOK).setRecipeBookCallback(screen2)));
            }
        }
    }

    public static void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new RequestClimateModelPacket());
        LocalPlayer player = event.getPlayer();
        List<AmbientSoundHandler> handlers = ((LocalPlayerAccessor)player).accessor$getAmbientSoundHandlers();
        if (handlers.stream().noneMatch(handler -> handler instanceof TFCBubbleColumnAmbientSoundHandler)) {
            handlers.add(new TFCBubbleColumnAmbientSoundHandler(player));
        }
    }

    public static void onClientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() != null) {
            Calendars.CLIENT.resetToDefault();
            IndirectHashCollection.clearAllCaches();
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (event.phase == TickEvent.Phase.END && world != null && !Minecraft.m_91087_().m_91104_()) {
            Calendars.CLIENT.onClientTick();
            ClimateRenderCache.INSTANCE.onClientTick();
            ClientForgeEventHandler.tickWind();
        }
    }

    private static void tickWind() {
        if (!((Boolean)TFCConfig.CLIENT.enableWindParticles.get()).booleanValue()) {
            return;
        }
        Level level = ClientHelpers.getLevel();
        Player player = ClientHelpers.getPlayer();
        if (player != null && level != null && level.m_46467_() % 2L == 0L) {
            BlockPos pos = player.m_20183_();
            Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
            float windStrength = wind.m_165907_();
            int count = 0;
            if (windStrength > 0.3f) {
                count = (int)(windStrength * 8.0f);
            } else if (player.m_20202_() instanceof Boat) {
                count = 2;
            }
            if (count == 0) {
                return;
            }
            double xBias = wind.f_82470_ > 0.0f ? 6.0 : -6.0;
            double zBias = wind.f_82471_ > 0.0f ? 6.0 : -6.0;
            ParticleOptions particle = ClimateRenderCache.INSTANCE.getTemperature() < 0.0f && level.m_46722_(0.0f) > 0.0f ? (ParticleOptions)TFCParticles.SNOWFLAKE.get() : (ParticleOptions)TFCParticles.WIND.get();
            for (int i = 0; i < count; ++i) {
                double z;
                double y;
                double x = (double)pos.m_123341_() + Mth.m_216263_((RandomSource)level.f_46441_, (double)(-12.0 - xBias), (double)(12.0 - xBias));
                if (!level.m_45527_(BlockPos.m_274561_((double)x, (double)(y = (double)pos.m_123342_() + Mth.m_216263_((RandomSource)level.f_46441_, (double)-1.0, (double)6.0)), (double)(z = (double)pos.m_123343_() + Mth.m_216263_((RandomSource)level.f_46441_, (double)(-12.0 - zBias), (double)(12.0 - zBias)))))) continue;
                level.m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void onKeyEvent(InputEvent.Key event) {
        if (TFCKeyBindings.PLACE_BLOCK.m_90857_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PlaceBlockSpecialPacket());
        } else if (TFCKeyBindings.CYCLE_CHISEL_MODE.m_90857_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new CycleChiselModePacket());
        }
    }

    public static void onScreenKey(ScreenEvent.KeyPressed.Pre event) {
        InventoryScreen inv;
        Slot slot;
        Screen screen;
        if (TFCKeyBindings.STACK_FOOD.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode())) && (screen = event.getScreen()) instanceof InventoryScreen && (slot = (inv = (InventoryScreen)screen).getSlotUnderMouse()) != null) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new StackFoodPacket(slot.f_40219_));
        }
    }

    public static void onHighlightBlockEvent(RenderHighlightEvent.Block event) {
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        Entity entity = camera.m_90592_();
        Level level = entity.m_9236_();
        BlockHitResult hit = event.getTarget();
        BlockPos pos = hit.m_82425_();
        if (entity instanceof Player) {
            BlockEntity blockEntity;
            Player player = (Player)entity;
            BlockState stateAt = level.m_8055_(pos);
            Block blockAt = stateAt.m_60734_();
            ChiselRecipe.computeResult(player, stateAt, hit, false).ifLeft(chiseled -> {
                IHighlightHandler.drawBox(poseStack, chiseled.m_60808_((BlockGetter)level, pos), event.getMultiBufferSource(), pos, camera.m_90583_(), 1.0f, 0.0f, 0.0f, 0.4f);
                event.setCanceled(true);
            });
            if (blockAt instanceof IHighlightHandler) {
                IHighlightHandler handler = (IHighlightHandler)blockAt;
                if (handler.drawHighlight(level, pos, player, hit, poseStack, event.getMultiBufferSource(), camera.m_90583_())) {
                    event.setCanceled(true);
                }
            } else if (blockAt instanceof IGhostBlockHandler) {
                IGhostBlockHandler handler = (IGhostBlockHandler)blockAt;
                if (handler.draw(level, player, stateAt, pos, hit.m_82450_(), hit.m_82434_(), event.getPoseStack(), event.getMultiBufferSource(), player.m_21205_())) {
                    event.setCanceled(true);
                }
            } else if (blockAt instanceof SluiceBlock && (blockEntity = level.m_7702_(pos)) instanceof SluiceBlockEntity) {
                BlockPos posAbove;
                BlockState stateAbove;
                SluiceBlockEntity sluice = (SluiceBlockEntity)blockEntity;
                BlockPos waterPos = sluice.getWaterOutputPos();
                if (!((Boolean)stateAt.m_61143_((Property)SluiceBlock.UPPER)).booleanValue()) {
                    waterPos = waterPos.m_121945_(((Direction)stateAt.m_61143_((Property)SluiceBlock.FACING)).m_122424_());
                }
                if (!level.m_8055_(waterPos).m_247087_()) {
                    IHighlightHandler.drawBox(poseStack, Shapes.m_83144_(), event.getMultiBufferSource(), waterPos, camera.m_90583_(), 0.0f, 0.0f, 1.0f, 0.4f);
                }
                if (!(stateAbove = level.m_8055_(posAbove = pos.m_7494_())).m_60819_().m_76178_()) {
                    IHighlightHandler.drawBox(poseStack, stateAbove.m_60819_().m_76183_((BlockGetter)level, posAbove), event.getMultiBufferSource(), posAbove, camera.m_90583_(), 1.0f, 0.0f, 0.0f, 0.4f);
                }
            }
        }
    }

    public static void onFogRender(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && event.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            FogType fluid = event.getCamera().m_167685_();
            BlockPos pos = event.getCamera().m_90588_();
            if (fluid == FogType.NONE) {
                float fog = Climate.getFogginess((Level)mc.f_91073_, pos);
                if (fog != 0.0f) {
                    float renderDistance = mc.f_91063_.m_109152_();
                    float density = renderDistance * (1.0f - Math.min(0.86f, fog));
                    event.setNearPlaneDistance(density - Mth.m_14036_((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f));
                    event.setFarPlaneDistance(density);
                    event.setCanceled(true);
                }
            } else if (fluid == FogType.WATER) {
                LocalPlayer player = mc.f_91074_;
                float fog = Climate.getWaterFogginess((Level)mc.f_91073_, pos);
                if (fog != 1.0f) {
                    waterFogLevel = player != null && player.m_21023_(MobEffects.f_19611_) ? 1.0f : Mth.m_14179_((float)0.01f, (float)waterFogLevel, (float)fog);
                    event.scaleFarPlaneDistance(waterFogLevel);
                    event.setCanceled(true);
                } else {
                    waterFogLevel = 1.0f;
                }
            }
        }
    }

    public static void onHandRender(RenderHandEvent event) {
        Player player = ClientHelpers.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof PanItem || mainHand.m_41720_() instanceof EmptyPanItem) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                PoseStack poseStack = event.getPoseStack();
                poseStack.m_85836_();
                RenderHelpers.renderTwoHandedItem(poseStack, event.getMultiBufferSource(), event.getPackedLight(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), mainHand);
                poseStack.m_85849_();
            }
            event.setCanceled(true);
        }
    }

    public static void onToast(ToastAddEvent event) {
        if (!((Boolean)TFCConfig.CLIENT.enableVanillaTutorialToasts.get()).booleanValue() && event.getToast() instanceof TutorialToast) {
            event.setCanceled(true);
        }
    }

    public static void onEffectRender(ScreenEvent.RenderInventoryMobEffects event) {
        event.addHorizontalOffset(((Integer)TFCConfig.CLIENT.effectHorizontalAdjustment.get()).intValue());
    }
}

