/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.BowlBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCCandleCakeBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.BurningLogPileBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.common.blocks.wood.TFCLecternBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.EggHandler;
import net.dries007.tfc.common.capabilities.food.DynamicBowlHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodDefinition;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.capabilities.glass.GlassWorkData;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.HeatDefinition;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.heat.IHeatBlock;
import net.dries007.tfc.common.capabilities.player.PlayerData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.commands.TFCCommands;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.entities.Fauna;
import net.dries007.tfc.common.entities.misc.HoldingMinecart;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.BlowpipeItem;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.ChunkAccessAccessor;
import net.dries007.tfc.mixin.accessor.RecipeManagerAccessor;
import net.dries007.tfc.network.EffectExpirePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.PlayerDrinkPacket;
import net.dries007.tfc.network.UpdateClimateModelPacket;
import net.dries007.tfc.util.AxeLoggingHelper;
import net.dries007.tfc.util.Drinkable;
import net.dries007.tfc.util.EntityDamageResistance;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.InteractionManager;
import net.dries007.tfc.util.ItemDamageResistance;
import net.dries007.tfc.util.KnappingType;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Pannable;
import net.dries007.tfc.util.PhysicalDamageType;
import net.dries007.tfc.util.SelfTests;
import net.dries007.tfc.util.Sluiceable;
import net.dries007.tfc.util.Support;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.events.DouseFireEvent;
import net.dries007.tfc.util.events.LoggingEvent;
import net.dries007.tfc.util.events.SelectClimateModelEvent;
import net.dries007.tfc.util.events.StartFireEvent;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataCapability;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ForgeEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final BlockHitResult FAKE_MISS = BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.UP, (BlockPos)BlockPos.f_121853_);

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ForgeEventHandler::onCreateWorldSpawn);
        bus.addGenericListener(LevelChunk.class, ForgeEventHandler::attachChunkCapabilities);
        bus.addGenericListener(Level.class, ForgeEventHandler::attachWorldCapabilities);
        bus.addGenericListener(ItemStack.class, ForgeEventHandler::attachItemCapabilities);
        bus.addGenericListener(Entity.class, ForgeEventHandler::attachEntityCapabilities);
        bus.addListener(ForgeEventHandler::onChunkWatch);
        bus.addListener(ForgeEventHandler::onChunkDataSave);
        bus.addListener(ForgeEventHandler::onChunkDataLoad);
        bus.addListener(ForgeEventHandler::registerCommands);
        bus.addListener(ForgeEventHandler::onBlockBroken);
        bus.addListener(ForgeEventHandler::onBlockPlace);
        bus.addListener(ForgeEventHandler::onBreakSpeed);
        bus.addListener(ForgeEventHandler::onNeighborUpdate);
        bus.addListener(ForgeEventHandler::onExplosionDetonate);
        bus.addListener(ForgeEventHandler::onWorldTick);
        bus.addListener(ForgeEventHandler::onWorldLoad);
        bus.addListener(ForgeEventHandler::onCreateNetherPortal);
        bus.addListener(ForgeEventHandler::onFluidPlaceBlock);
        bus.addListener(ForgeEventHandler::onFluidCreateSource);
        bus.addListener(ForgeEventHandler::onFireStart);
        bus.addListener(ForgeEventHandler::onFireStop);
        bus.addListener(ForgeEventHandler::onProjectileImpact);
        bus.addListener(ForgeEventHandler::onPlayerTick);
        bus.addListener(ForgeEventHandler::onEffectRemove);
        bus.addListener(ForgeEventHandler::onEffectExpire);
        bus.addListener(ForgeEventHandler::onLivingJump);
        bus.addListener(ForgeEventHandler::onLivingHurt);
        bus.addListener(ForgeEventHandler::onShieldBlock);
        bus.addListener(ForgeEventHandler::onLivingSpawnCheck);
        bus.addListener(ForgeEventHandler::onItemStacked);
        bus.addListener(ForgeEventHandler::onEntityJoinLevel);
        bus.addListener(ForgeEventHandler::onItemExpire);
        bus.addListener(ForgeEventHandler::onPlayerLoggedIn);
        bus.addListener(ForgeEventHandler::onPlayerRespawn);
        bus.addListener(ForgeEventHandler::onPlayerDeath);
        bus.addListener(ForgeEventHandler::onPlayerChangeDimension);
        bus.addListener(ForgeEventHandler::onServerChat);
        bus.addListener(ForgeEventHandler::onPlayerRightClickBlock);
        bus.addListener(EventPriority.LOWEST, true, ForgeEventHandler::onPlayerRightClickBlockLowestPriority);
        bus.addListener(ForgeEventHandler::onPlayerRightClickItem);
        bus.addListener(ForgeEventHandler::onPlayerRightClickEmpty);
        bus.addListener(ForgeEventHandler::onItemUseFinish);
        bus.addListener(ForgeEventHandler::addReloadListeners);
        bus.addListener(ForgeEventHandler::onDataPackSync);
        bus.addListener(ForgeEventHandler::onTagsUpdated);
        bus.addListener(ForgeEventHandler::onBoneMeal);
        bus.addListener(ForgeEventHandler::onSelectClimateModel);
        bus.addListener(ForgeEventHandler::onAnimalTame);
        bus.addListener(ForgeEventHandler::onContainerOpen);
        bus.addListener(ForgeEventHandler::onCropsGrow);
        bus.addListener(ForgeEventHandler::onMount);
        bus.addListener(ForgeEventHandler::onEntityInteract);
    }

    public static void onCreateWorldSpawn(LevelEvent.CreateSpawnPosition event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (levelAccessor = (level = (ServerLevel)levelAccessor).m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)levelAccessor;
            ChunkGenerator generator = extension.self();
            ServerLevelData levelData = event.getSettings();
            XoroshiroRandomSource random = new XoroshiroRandomSource(level.m_7328_());
            ChunkPos chunkPos = new ChunkPos(extension.findSpawnBiome((RandomSource)random));
            levelData.m_7250_(chunkPos.m_45615_().m_7918_(8, generator.m_142051_((LevelHeightAccessor)level), 8), 0.0f);
            boolean foundExactSpawn = false;
            int x = 0;
            int z = 0;
            int xStep = 0;
            int zStep = -1;
            for (int tries = 0; tries < 1024; ++tries) {
                BlockPos spawnPos;
                if (x > -16 && x <= 16 && z > -16 && z <= 16 && (spawnPos = PlayerRespawnLogic.m_183932_((ServerLevel)level, (ChunkPos)new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z))) != null) {
                    levelData.m_7250_(spawnPos, 0.0f);
                    foundExactSpawn = true;
                    break;
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = xStep;
                    xStep = -zStep;
                    zStep = swap;
                }
                x += xStep;
                z += zStep;
            }
            if (!foundExactSpawn) {
                LOGGER.warn("Unable to find a suitable spawn location!");
            }
            if (level.m_7654_().m_129910_().m_246337_().m_245100_()) {
                LOGGER.warn("No bonus chest for you, you cheaty cheater!");
            }
            event.setCanceled(true);
        }
    }

    public static void attachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        LevelChunk chunk = (LevelChunk)event.getObject();
        if (!chunk.m_6430_()) {
            ChunkData data;
            Level level = ((LevelChunk)event.getObject()).m_62953_();
            ChunkPos chunkPos = ((LevelChunk)event.getObject()).m_7697_();
            if (level.m_5776_()) {
                data = ChunkData.dequeueClientChunkData(chunkPos);
            } else {
                ChunkData chunkData;
                ServerLevel serverLevel;
                ChunkGenerator chunkGenerator;
                if (level instanceof ServerLevel && (chunkGenerator = (serverLevel = (ServerLevel)level).m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
                    ChunkGeneratorExtension ex = (ChunkGeneratorExtension)chunkGenerator;
                    chunkData = ex.chunkDataProvider().create(chunkPos);
                } else {
                    chunkData = new ChunkData(chunkPos);
                }
                data = chunkData;
            }
            event.addCapability(ChunkDataCapability.KEY, (ICapabilityProvider)new ChunkDataCapability(data));
        }
    }

    public static void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(WorldTrackerCapability.KEY, (ICapabilityProvider)new WorldTracker((Level)event.getObject()));
    }

    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (!stack.m_41619_()) {
            FoodDefinition food;
            event.addCapability(ForgingCapability.KEY, (ICapabilityProvider)new Forging(stack));
            HeatDefinition def = HeatCapability.getDefinition(stack);
            if (def != null) {
                event.addCapability(HeatCapability.KEY, def.create());
            }
            if ((food = FoodCapability.getDefinition(stack)) != null) {
                event.addCapability(FoodCapability.KEY, (ICapabilityProvider)FoodDefinition.getHandler(food, stack));
            }
            if (stack.m_41720_() == Items.f_42521_) {
                event.addCapability(EggCapability.KEY, (ICapabilityProvider)new EggHandler(stack));
            }
        }
    }

    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(PlayerDataCapability.KEY, (ICapabilityProvider)new PlayerData(player));
        }
    }

    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ChunkData chunkData = ChunkData.get(event.getChunk());
        if (chunkData.status() == ChunkData.Status.FULL) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((ChunkWatchEvent.Watch)event).getPlayer()), chunkData.getUpdatePacket());
        }
    }

    public static void onChunkDataSave(ChunkDataEvent.Save event) {
        ChunkAccess chunkAccess;
        if (event.getChunk().m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK && (chunkAccess = event.getChunk()) instanceof ProtoChunk) {
            ChunkGeneratorExtension ex;
            CompoundTag nbt;
            ProtoChunk chunk = (ProtoChunk)chunkAccess;
            chunkAccess = ((ServerChunkCache)event.getLevel().m_7726_()).m_8481_();
            if (chunkAccess instanceof ChunkGeneratorExtension && (nbt = (ex = (ChunkGeneratorExtension)chunkAccess).chunkDataProvider().savePartial(chunk)) != null) {
                event.getData().m_128365_("tfc_protochunk_data", (Tag)nbt);
            }
        }
    }

    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        ServerLevel level;
        ProtoChunk chunk;
        ChunkAccess chunkAccess;
        if (event.getChunk().m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK && event.getData().m_128425_("tfc_protochunk_data", 10) && (chunkAccess = event.getChunk()) instanceof ProtoChunk && (chunkAccess = ((ChunkAccessAccessor)(chunk = (ProtoChunk)chunkAccess)).accessor$getLevelHeightAccessor()) instanceof ServerLevel && (chunkAccess = (level = (ServerLevel)chunkAccess).m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension generator = (ChunkGeneratorExtension)chunkAccess;
            generator.chunkDataProvider().loadPartial(chunk, event.getData().m_128469_("tfc_protochunk_data"));
        }
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        LOGGER.debug("Registering TFC Commands");
        TFCCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        BlockPos pos;
        LevelAccessor levelAccess = event.getLevel();
        BlockState state = levelAccess.m_8055_(pos = event.getPos());
        if (Helpers.isBlock(state, TFCTags.Blocks.CAN_TRIGGER_COLLAPSE) && levelAccess instanceof Level) {
            Level level = (Level)levelAccess;
            CollapseRecipe.tryTriggerCollapse(level, pos);
            return;
        }
        ItemStack stack = event.getPlayer().m_21205_();
        if (AxeLoggingHelper.shouldLog(levelAccess, pos, state, stack) && !MinecraftForge.EVENT_BUS.post((Event)new LoggingEvent(levelAccess, pos, state, stack))) {
            event.setCanceled(true);
            AxeLoggingHelper.doLogging(levelAccess, pos, event.getPlayer(), stack);
        }
    }

    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            if (Helpers.isBlock(state, TFCTags.Blocks.CAN_LANDSLIDE)) {
                WorldTracker.get((Level)world).addLandslidePos(pos);
            }
            if (Helpers.isBlock(state, TFCTags.Blocks.BREAKS_WHEN_ISOLATED)) {
                WorldTracker.get((Level)world).addIsolatedPos(pos);
            }
        }
    }

    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ForgingBonus bonus = ForgingBonus.get(event.getEntity().m_21205_());
        if (bonus != ForgingBonus.NONE) {
            event.setNewSpeed(event.getNewSpeed() * bonus.efficiency());
        }
    }

    public static void onNeighborUpdate(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            for (Direction direction : event.getNotifiedSides()) {
                BlockPos pos = event.getPos().m_121945_(direction);
                BlockState state = level.m_8055_(pos);
                if (Helpers.isBlock(state, TFCTags.Blocks.CAN_LANDSLIDE)) {
                    WorldTracker.get((Level)level).addLandslidePos(pos);
                }
                if (!Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.BREAKS_WHEN_ISOLATED)) continue;
                WorldTracker.get((Level)level).addIsolatedPos(pos);
            }
        }
    }

    public static void onExplosionDetonate(ExplosionEvent event) {
        Level level = event.getLevel();
        if (!level.f_46443_) {
            WorldTracker.get(level).addCollapsePositions(BlockPos.m_274446_((Position)event.getExplosion().getPosition()), event.getExplosion().m_46081_());
        }
    }

    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.START && (level = event.level) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WeatherHelpers.preAdvancedWeatherCycle(level2);
            WorldTracker.get((Level)level2).tick();
        }
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            MinecraftServer server = level.m_7654_();
            if (((Boolean)TFCConfig.SERVER.enableForcedTFCGameRules.get()).booleanValue()) {
                GameRules rules = level.m_46469_();
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46139_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46155_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46124_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46125_)).m_46246_(false, server);
                LOGGER.info("Updating TFC Relevant Game Rules for level {}.", (Object)level.m_46472_().m_135782_());
            }
            Climate.onWorldLoad(level);
            if (level.m_46472_() == Level.f_46428_) {
                ItemSizeManager.applyItemStackSizeOverrides();
                SelfTests.runServerSelfTests();
            }
        }
    }

    public static void onCreateNetherPortal(BlockEvent.PortalSpawnEvent event) {
        if (!((Boolean)TFCConfig.SERVER.enableNetherPortals.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onFluidPlaceBlock(BlockEvent.FluidPlaceBlockEvent event) {
        BlockState state = event.getNewState();
        if (Helpers.isBlock(state, Blocks.f_50069_)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GABBRO).get((Object)Rock.BlockType.HARDENED).get()).m_49966_());
        } else if (Helpers.isBlock(state, Blocks.f_50652_)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.RHYOLITE).get((Object)Rock.BlockType.HARDENED).get()).m_49966_());
        } else if (Helpers.isBlock(state, Blocks.f_50137_)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.HARDENED).get()).m_49966_());
        }
    }

    public static void onFluidCreateSource(BlockEvent.CreateFluidSourceEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (state.m_60734_() instanceof AqueductBlock) {
            event.setResult(Event.Result.DENY);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos relPos = pos.m_121945_(direction).m_7494_();
            BlockState relState = level.m_8055_(relPos);
            if (!(relState.m_60734_() instanceof SluiceBlock) || ((Boolean)relState.m_61143_((Property)SluiceBlock.UPPER)).booleanValue() || relState.m_61143_((Property)SluiceBlock.FACING) != direction.m_122424_()) continue;
            event.setResult(Event.Result.DENY);
        }
    }

    public static void onFireStart(StartFireEvent event) {
        ItemStack stack;
        BowlBlockEntity bowl;
        IItemHandler inv;
        BlockEntity bloomery2;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if ((block == TFCBlocks.FIREPIT.get() || block == TFCBlocks.POT.get() || block == TFCBlocks.GRILL.get()) && event.isStrong()) {
            AbstractFirepitBlockEntity firepit;
            BlockEntity entity2 = level.m_7702_(pos);
            if (entity2 instanceof AbstractFirepitBlockEntity && (firepit = (AbstractFirepitBlockEntity)entity2).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.TORCH.get() || block == TFCBlocks.WALL_TORCH.get()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.DEAD_TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.TORCH.get()).m_49966_());
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.DEAD_WALL_TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.WALL_TORCH.get()).m_152465_(state));
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.LOG_PILE.get() && event.isStrong()) {
            BurningLogPileBlock.lightLogPile(level, pos);
            event.setCanceled(true);
        } else if (block == TFCBlocks.PIT_KILN.get() && (Integer)state.m_61143_((Property)PitKilnBlock.STAGE) == 15 && event.isStrong()) {
            PitKilnBlockEntity kiln;
            BlockEntity firepit = level.m_7702_(pos);
            if (firepit instanceof PitKilnBlockEntity && (kiln = (PitKilnBlockEntity)firepit).tryLight()) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.CHARCOAL_PILE.get() && (Integer)state.m_61143_((Property)CharcoalPileBlock.LAYERS) >= 7 && CharcoalForgeBlock.isValid((LevelAccessor)level, pos) && event.isStrong()) {
            CharcoalForgeBlockEntity.createFromCharcoalPile(level, pos);
            event.setCanceled(true);
        } else if (block == TFCBlocks.CHARCOAL_FORGE.get() && CharcoalForgeBlock.isValid((LevelAccessor)level, pos) && event.isStrong()) {
            CharcoalForgeBlockEntity forge;
            BlockEntity entity3 = level.m_7702_(pos);
            if (entity3 instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)entity3).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.CRUCIBLE.get() && CharcoalForgeBlock.isValid((LevelAccessor)level, pos.m_7495_()) && event.isStrong()) {
            CharcoalForgeBlockEntity forge;
            BlockEntity entity4 = level.m_7702_(pos.m_7495_());
            if (entity4 instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)entity4).light(level.m_8055_(pos.m_7495_()))) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.BLOOMERY.get() && !((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue() && event.isStrong()) {
            BloomeryBlockEntity bloomery2;
            BlockEntity entity5 = level.m_7702_(pos);
            if (entity5 instanceof BloomeryBlockEntity && (bloomery2 = (BloomeryBlockEntity)entity5).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.POWDERKEG.get() && ((Boolean)state.m_61143_((Property)PowderkegBlock.SEALED)).booleanValue() && event.isStrong()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(entity -> {
                entity.setLit(true, (Entity)event.getPlayer());
                event.setCanceled(true);
            });
        } else if (block == TFCBlocks.BLAST_FURNACE.get() && !((Boolean)state.m_61143_((Property)BlastFurnaceBlock.LIT)).booleanValue() && event.isStrong()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).ifPresent(blastFurnace -> {
                if (blastFurnace.light(level, pos, state)) {
                    event.setCanceled(true);
                }
            });
        } else if (block instanceof LampBlock) {
            if (!((Boolean)state.m_61143_((Property)LampBlock.LIT)).booleanValue()) {
                level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).ifPresent(lamp -> {
                    if (lamp.getFuel() != null && !((Boolean)state.m_61143_((Property)LampBlock.LIT)).booleanValue()) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
                        lamp.resetCounter();
                    }
                });
                event.setCanceled(true);
            }
        } else if (block instanceof TFCCandleBlock || block instanceof TFCCandleCakeBlock) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TFCCandleBlock.f_152791_, (Comparable)Boolean.valueOf(true)), 11);
            TickCounterBlockEntity.reset(level, pos);
            event.setCanceled(true);
        } else if (block == Blocks.f_50143_ || block == TFCBlocks.JACK_O_LANTERN.get()) {
            level.m_46597_(pos, Helpers.copyProperty(((Block)TFCBlocks.JACK_O_LANTERN.get()).m_49966_(), state, HorizontalDirectionalBlock.f_54117_));
            TickCounterBlockEntity.reset(level, pos);
            event.setCanceled(true);
        } else if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(state, level, pos, event.getTargetedFace(), (LivingEntity)event.getPlayer());
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            event.setCanceled(true);
        } else if (block == TFCBlocks.CERAMIC_BOWL.get() && (bloomery2 = level.m_7702_(pos)) instanceof BowlBlockEntity && (inv = Helpers.getCapability((ICapabilityProvider)(bowl = (BowlBlockEntity)bloomery2), Capabilities.ITEM)) != null && (stack = inv.getStackInSlot(0)).m_41720_() == Items.f_42403_) {
            Helpers.removeStack(inv, 0);
            level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (float)stack.m_41613_() / 6.0f + 2.0f, Level.ExplosionInteraction.BLOCK);
            event.setCanceled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void onFireStop(DouseFireEvent event) {
        BlastFurnaceBlockEntity furnace;
        PowderkegBlockEntity keg;
        CharcoalForgeBlockEntity forge;
        AbstractFirepitBlockEntity firepit;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        Player player = event.getPlayer();
        if (state.m_60795_()) {
            return;
        }
        if (state.m_204336_(BlockTags.f_13076_)) {
            level.m_7471_(pos, false);
            Helpers.playSound(level, pos, SoundEvents.f_11937_);
            event.setCanceled(true);
        } else if (AbstractCandleBlock.m_151933_((BlockState)state)) {
            AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            event.setCanceled(true);
        } else if (CampfireBlock.m_51319_((BlockState)state)) {
            level.m_5898_(player, 1009, pos, 0);
            CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
            event.setCanceled(true);
        } else if (block == TFCBlocks.WALL_TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.DEAD_WALL_TORCH.get()).m_152465_(state));
            event.setCanceled(true);
        } else if (block == TFCBlocks.TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.DEAD_TORCH.get()).m_152465_(state));
            event.setCanceled(true);
        }
        if (block == TFCBlocks.WALL_TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.DEAD_WALL_TORCH.get()).m_152465_(state));
            event.setCanceled(true);
        }
        if (block instanceof JackOLanternBlock) {
            JackOLanternBlock lantern = (JackOLanternBlock)block;
            lantern.extinguish(level, pos, state);
            event.setCanceled(true);
        }
        if (event.isCanceled()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LampBlockEntity) {
            LampBlockEntity lamp = (LampBlockEntity)blockEntity;
            if (((Boolean)state.m_61143_((Property)LampBlock.LIT)).booleanValue()) {
                Helpers.playSound(level, pos, SoundEvents.f_11937_);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)));
                lamp.resetCounter();
                event.setCanceled(true);
                return;
            }
        }
        if (blockEntity instanceof AbstractFirepitBlockEntity && (firepit = (AbstractFirepitBlockEntity)blockEntity).getTemperature() > 0.0f) {
            firepit.extinguish(state);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)blockEntity).getTemperature() > 0.0f) {
            forge.extinguish(state);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof PowderkegBlockEntity && (keg = (PowderkegBlockEntity)blockEntity).isLit()) {
            keg.setLit(false, (Entity)player);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof BlastFurnaceBlockEntity && (furnace = (BlastFurnaceBlockEntity)blockEntity).getTemperature() > 0.0f) {
            furnace.extinguish(state);
            event.setCanceled(true);
            return;
        }
        if (!(blockEntity instanceof CrucibleBlockEntity)) return;
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
        IHeatBlock cap = Helpers.getCapability((ICapabilityProvider)crucible, HeatCapability.BLOCK_CAPABILITY);
        if (cap == null) return;
        cap.setTemperature(0.0f);
    }

    public static void onProjectileImpact(ProjectileImpactEvent event) {
        ThrownPotion potion;
        Projectile projectile = event.getProjectile();
        HitResult result = event.getRayTraceResult();
        Level level = projectile.m_9236_();
        if (projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)(potion = (ThrownPotion)projectile).m_7846_()) == Potions.f_43599_ && PotionUtils.m_43547_((ItemStack)potion.m_7846_()).isEmpty()) {
            Player player;
            boolean lingering = potion.m_7846_().m_41720_() instanceof LingeringPotionItem;
            Entity entity = projectile.m_19749_();
            DouseFireEvent.douse(level, potion.m_20191_().m_82377_(lingering ? 4.0 : 2.0, 2.0, lingering ? 4.0 : 2.0), entity instanceof Player ? (player = (Player)entity) : null);
        }
        if (!((Boolean)TFCConfig.SERVER.enableFireArrowSpreading.get()).booleanValue()) {
            return;
        }
        if (result.m_6662_() == HitResult.Type.BLOCK && projectile.m_6060_()) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.m_82425_();
            StartFireEvent.startFire(projectile.m_9236_(), pos, projectile.m_9236_().m_8055_(pos), blockResult.m_82434_(), null, ItemStack.f_41583_);
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        FoodData foodData;
        Player player = event.player;
        Level level = player.m_9236_();
        float angle = Mth.m_14177_((float)player.m_146909_());
        if (angle <= -80.0f && !level.m_5776_() && level.m_46758_(player.m_20183_().m_7494_()) && (foodData = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData foodData2 = (TFCFoodData)foodData;
            foodData2.addThirst(((Double)TFCConfig.SERVER.thirstGainedFromDrinkingInTheRain.get()).floatValue());
        }
        if (!level.m_5776_() && !player.m_150110_().f_35934_ && ((Boolean)TFCConfig.SERVER.enableOverburdening.get()).booleanValue() && level.m_46467_() % 20L == 0L) {
            int hugeHeavyCount = Helpers.countOverburdened((Container)player.m_150109_());
            if (hugeHeavyCount >= 1) {
                player.m_7292_(Helpers.getExhausted(false));
            }
            if (hugeHeavyCount == 2) {
                player.m_7292_(Helpers.getOverburdened(false));
            }
        }
    }

    public static void onEffectRemove(MobEffectEvent.Remove event) {
        MobEffectInstance inst = event.getEffectInstance();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (inst != null) {
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new EffectExpirePacket(inst.m_19544_()));
                if (inst.m_19544_() == TFCEffects.PINNED.get()) {
                    player.setForcedPose(null);
                }
            }
        }
    }

    public static void onEffectExpire(MobEffectEvent.Expired event) {
        LivingEntity livingEntity;
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new EffectExpirePacket(instance.m_19544_()));
            if (instance.m_19544_() == TFCEffects.PINNED.get()) {
                player.setForcedPose(null);
            }
        }
    }

    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)TFCEffects.PINNED.get()) || entity.m_21023_((MobEffect)TFCEffects.OVERBURDENED.get())) {
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.f_19812_ = false;
        }
    }

    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity;
        float amount = event.getAmount();
        Entity attackerEntity = event.getSource().m_7639_();
        if (attackerEntity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)attackerEntity;
            amount *= ForgingBonus.get(livingEntity2.m_21205_()).damage();
            livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player2 = (Player)livingEntity;
                Helpers.maybeDisableShield(livingEntity2.m_21205_(), player2.m_6117_() ? player2.m_21211_() : ItemStack.f_41583_, player2, livingEntity2);
            }
        }
        amount *= PhysicalDamageType.calculateMultiplier(event.getSource(), (Entity)event.getEntity());
        livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).m_36324_()) instanceof TFCFoodData) {
            TFCFoodData foodData = (TFCFoodData)livingEntity;
            amount /= foodData.getHealthModifier();
        }
        event.setAmount(amount);
    }

    public static void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity livingEntity;
        float damageModifier = 1.0f;
        Item useItem = event.getEntity().m_21211_().m_41720_();
        Entity entity = event.getDamageSource().m_7640_();
        if (entity instanceof LivingEntity && (entity = (livingEntity = (LivingEntity)entity).m_21205_().m_41720_()) instanceof TieredItem) {
            TieredItem attackWeapon = (TieredItem)entity;
            if (useItem instanceof TieredItem) {
                TieredItem shieldItem = (TieredItem)useItem;
                if (TierSortingRegistry.getTiersLowerThan((Tier)attackWeapon.m_43314_()).contains(shieldItem.m_43314_())) {
                    damageModifier = 0.3f;
                }
            }
        }
        if (useItem.equals(Items.f_42740_)) {
            damageModifier = 0.25f;
        }
        event.setBlockedDamage(event.getOriginalBlockedDamage() * damageModifier);
    }

    public static void onItemStacked(ItemStackedOnOtherEvent event) {
        ItemStack batch = event.getCarriedItem();
        ItemStack pipe = event.getStackedOnItem();
        if (event.getClickAction() == ClickAction.SECONDARY && pipe.m_41613_() == 1 && Helpers.isItem(pipe, TFCTags.Items.BLOWPIPES) && Helpers.isItem(batch.m_41720_(), TFCTags.Items.GLASS_BATCHES)) {
            ItemStack newItem = new ItemStack((ItemLike)BlowpipeItem.transform(pipe.m_41720_()));
            GlassWorkData.createNewBatch(newItem, batch);
            event.getCarriedSlotAccess().m_142104_(newItem);
            event.getSlot().m_7993_().m_41774_(1);
            event.setCanceled(true);
        }
    }

    public static void onLivingSpawnCheck(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        MobSpawnType spawn = event.getSpawnType();
        if ((spawn == MobSpawnType.NATURAL || spawn == MobSpawnType.CHUNK_GENERATION || spawn == MobSpawnType.REINFORCEMENT) && Helpers.isEntity((Entity)entity, TFCTags.Entities.VANILLA_MONSTERS)) {
            if (((Boolean)TFCConfig.SERVER.enableVanillaMonsters.get()).booleanValue()) {
                if (!((Boolean)TFCConfig.SERVER.enableVanillaMonstersOnSurface.get()).booleanValue()) {
                    BlockPos pos = entity.m_20183_();
                    if (entity.m_6095_() != EntityType.f_20526_ && level.m_45524_(pos, 0) != 0) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    } else if (level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_()) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    } else if (!Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.MONSTER_SPAWNS_ON)) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    }
                }
            } else {
                event.setSpawnCancelled(true);
                event.setCanceled(true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        block24: {
            block26: {
                block25: {
                    if (event.loadedFromDisk()) {
                        return;
                    }
                    level = event.getLevel();
                    entity = event.getEntity();
                    if (!(entity instanceof ItemEntity)) ** GOTO lbl-1000
                    itemEntity = (ItemEntity)entity;
                    if (!level.f_46443_ && ((Boolean)TFCConfig.SERVER.coolHotItemEntities.get()).booleanValue()) {
                        item = itemEntity.m_32055_();
                        if (HeatCapability.isHot(item)) {
                            itemEntity.lifespan = (Integer)TFCConfig.SERVER.ticksBeforeItemCool.get();
                        }
                    } else if (entity instanceof LightningBolt) {
                        lightning = (LightningBolt)entity;
                        if (!level.f_46443_ && !event.isCanceled()) {
                            if (!((Boolean)TFCConfig.SERVER.enableLightning.get()).booleanValue()) {
                                event.setCanceled(true);
                                return;
                            }
                            if (((Boolean)TFCConfig.SERVER.enableLightningStrippingLogs.get()).booleanValue() && level.f_46441_.m_188501_() < 0.2f) {
                                mutable = new BlockPos.MutableBlockPos();
                                pos = lightning.m_20183_();
                                for (x = -5; x <= 5; ++x) {
                                    for (y = -5; y <= 5; ++y) {
                                        for (z = -5; z <= 5; ++z) {
                                            if (level.f_46441_.m_188503_(3) != 0 || x * x + y * y + z * z > 25) continue;
                                            mutable.m_122154_((Vec3i)pos, x, y, z);
                                            state = level.m_8055_((BlockPos)mutable);
                                            modified = state.getToolModifiedState(new UseOnContext(level, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42391_), new BlockHitResult(Vec3.m_82539_((Vec3i)mutable), Direction.DOWN, (BlockPos)mutable, false)), ToolActions.AXE_STRIP, true);
                                            if (modified == null) continue;
                                            level.m_46597_((BlockPos)mutable, modified);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (entity instanceof Monster) {
                        monster = (Monster)entity;
                        if (!((Boolean)TFCConfig.SERVER.enableVanillaMobsSpawningWithVanillaEquipment.get()).booleanValue()) {
                            if (Helpers.isItem(monster.m_21120_(InteractionHand.MAIN_HAND), TFCTags.Items.DISABLED_MONSTER_HELD_ITEMS)) {
                                monster.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                            }
                            if (Helpers.isItem(monster.m_21120_(InteractionHand.OFF_HAND), TFCTags.Items.DISABLED_MONSTER_HELD_ITEMS)) {
                                monster.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                            }
                        }
                    }
                    if (((Boolean)TFCConfig.SERVER.enableChickenJockies.get()).booleanValue()) break block24;
                    if (!(entity instanceof Chicken)) break block25;
                    chicken = (Chicken)entity;
                    if (chicken.f_28232_) break block26;
                }
                if (entity.m_20202_() == null || !((var5_4 = entity.m_20202_()) instanceof Chicken)) break block24;
                vehicleChicken = (Chicken)var5_4;
                if (!vehicleChicken.f_28232_) break block24;
            }
            event.setCanceled(true);
        }
        if (entity.m_6095_() == EntityType.f_20524_) {
            entity.m_8061_(EquipmentSlot.MAINHAND, Helpers.randomItem(TFCTags.Items.SKELETON_WEAPONS, entity.m_9236_().m_213780_()).orElse(Items.f_42411_).m_7968_());
        } else if (entity.m_6095_() == EntityType.f_20525_ && !((Boolean)TFCConfig.SERVER.enableVanillaSkeletonHorseSpawning.get()).booleanValue()) {
            event.setCanceled(true);
        } else if ((entity instanceof IronGolem || entity instanceof SnowGolem) && !((Boolean)TFCConfig.SERVER.enableVanillaGolems.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onItemExpire(ItemExpireEvent event) {
        if (!((Boolean)TFCConfig.SERVER.coolHotItemEntities.get()).booleanValue()) {
            return;
        }
        ItemEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        ItemStack stack = entity.m_32055_();
        BlockPos pos = entity.m_20183_();
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            int lifespan = stack.m_41720_().getEntityLifespan(stack, (Level)level);
            if (entity.lifespan >= lifespan) {
                return;
            }
            float itemTemp = heat.getTemperature();
            if (itemTemp > 0.0f) {
                float coolAmount = 0.0f;
                BlockState state = level.m_8055_(pos);
                if (FluidHelpers.canFluidExtinguishFire(state.m_60819_().m_76152_())) {
                    coolAmount = 50.0f;
                    if (level.f_46441_.m_188501_() < 0.001f && FluidHelpers.isAirOrEmptyFluid(state)) {
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                } else if (Helpers.isBlock(state, Blocks.f_50125_)) {
                    coolAmount = 70.0f;
                    if (level.f_46441_.m_188501_() < 0.1f) {
                        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                        if (layers > 1) {
                            level.m_46961_(pos, false);
                            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers - 1)));
                        } else {
                            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        }
                    }
                } else {
                    BlockPos belowPos = pos.m_7495_();
                    BlockState belowState = level.m_8055_(belowPos);
                    if (Helpers.isBlock(belowState, Blocks.f_50127_)) {
                        coolAmount = 75.0f;
                        if (level.f_46441_.m_188501_() < 0.1f) {
                            level.m_46961_(belowPos, false);
                        }
                    } else if (belowState.m_60734_() == Blocks.f_50126_ || belowState.m_60734_() == Blocks.f_50449_) {
                        coolAmount = 100.0f;
                        if (level.f_46441_.m_188501_() < 0.01f) {
                            level.m_46597_(belowPos, Helpers.isBlock(belowState, (Block)TFCBlocks.SEA_ICE.get()) ? ((LiquidBlock)TFCBlocks.SALT_WATER.get()).m_49966_() : Blocks.f_49990_.m_49966_());
                        }
                    } else if (belowState.m_60734_() == Blocks.f_50354_ || belowState.m_60734_() == Blocks.f_50568_) {
                        coolAmount = 125.0f;
                        if (level.f_46441_.m_188501_() < 0.005f) {
                            level.m_46597_(belowPos, Blocks.f_49990_.m_49966_());
                        }
                    }
                }
                if (coolAmount > 0.0f) {
                    heat.setTemperature(Math.max(0.0f, heat.getTemperature() - coolAmount));
                    Helpers.playSound((Level)level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                }
                event.setExtraLife(heat.getTemperature() == 0.0f ? lifespan : (Integer)TFCConfig.SERVER.ticksBeforeItemCool.get());
            } else {
                event.setExtraLife(lifespan);
            }
            event.setCanceled(true);
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getEntity());
    }

    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getEntity());
    }

    public static void onPlayerDeath(PlayerEvent.Clone event) {
        if (((Boolean)TFCConfig.SERVER.keepNutritionAfterDeath.get()).booleanValue() && event.isWasDeath()) {
            TFCFoodData.restoreFoodStatsAfterDeath(event.getOriginal(), event.getEntity());
        }
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getEntity());
    }

    private static void onNewPlayerInWorld(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TFCFoodData.replaceFoodStats((Player)serverPlayer);
            WorldTracker.get((Level)serverPlayer.m_284548_()).syncTo(serverPlayer);
            PlayerData.get((Player)serverPlayer).sync();
            ClimateModel model = Climate.model(serverPlayer.m_9236_());
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new UpdateClimateModelPacket(model));
        }
    }

    public static void onServerChat(ServerChatEvent event) {
        long intoxicatedTicks = PlayerData.get((Player)event.getPlayer()).getIntoxicatedTicks() - 6000L;
        if (intoxicatedTicks > 0L) {
            float intoxicationChance = Mth.m_14036_((float)((float)(intoxicatedTicks - 6000L) / 36000.0f), (float)0.0f, (float)0.7f);
            RandomSource random = event.getPlayer().m_217043_();
            String originalMessage = event.getMessage().getString();
            CharSequence[] words = originalMessage.split(" ");
            for (int i = 0; i < words.length; ++i) {
                int pos;
                Object word = words[i];
                if (((String)word).length() == 0) continue;
                if (random.m_188501_() < intoxicationChance && ((String)word).length() >= 2) {
                    pos = random.m_188503_(((String)word).length() - 1);
                    word = ((String)word).substring(0, pos) + ((String)word).charAt(pos + 1) + ((String)word).charAt(pos) + ((String)word).substring(pos + 2);
                }
                if (random.m_188501_() < intoxicationChance) {
                    pos = random.m_188503_(((String)word).length());
                    char repeat = ((String)word).charAt(pos);
                    int amount = 1 + random.m_188503_(3);
                    word = ((String)word).substring(0, pos) + new String(new char[amount]).replace('\u0000', repeat) + (pos + 1 < ((String)word).length() ? ((String)word).substring(pos + 1) : "");
                }
                if (random.m_188501_() < intoxicationChance) {
                    pos = random.m_188503_(((String)word).length());
                    char replacement = ALPHABET.charAt(random.m_188503_(ALPHABET.length()));
                    if (Character.isUpperCase(((String)word).charAt(random.m_188503_(((String)word).length())))) {
                        replacement = Character.toUpperCase(replacement);
                    }
                    word = ((String)word).substring(0, pos) + replacement + (pos + 1 < ((String)word).length() ? ((String)word).substring(pos + 1) : "");
                }
                words[i] = word;
            }
            event.setMessage((Component)Component.m_237113_((String)String.join((CharSequence)" ", words)));
        }
    }

    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PestContainer test;
        BaseContainerBlockEntity container;
        BlockEntity blockEntity;
        Level level = event.getLevel();
        BlockState state = level.m_8055_(event.getPos());
        ItemStack stack = event.getItemStack();
        if ((Helpers.isItem(stack, Items.f_42614_) || Helpers.isItem(stack, Items.f_42615_)) && state.m_60734_() instanceof TFCLecternBlock && LecternBlock.m_269125_((Entity)event.getEntity(), (Level)level, (BlockPos)event.getPos(), (BlockState)state, (ItemStack)stack)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if ((blockEntity = level.m_7702_(event.getPos())) instanceof BaseContainerBlockEntity && (container = (BaseContainerBlockEntity)blockEntity).m_7525_(event.getEntity()) && container instanceof PestContainer && (test = (PestContainer)container).canBeInfested()) {
            int infestation = 0;
            for (int i = 0; !(i >= container.m_6643_() || Helpers.isItem(container.m_8020_(i), TFCTags.Items.FOODS) && ++infestation == 5); ++i) {
            }
            Helpers.tickInfestation(level, container.m_58899_(), infestation, event.getEntity());
        }
    }

    public static void onPlayerRightClickBlockLowestPriority(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockState state = level.m_8055_(event.getPos());
        ItemStack stack = event.getItemStack();
        if (!event.isCanceled() && event.getHand() == InteractionHand.MAIN_HAND && stack.m_41619_()) {
            InteractionResult useBlockResult = state.m_60664_(level, event.getEntity(), event.getHand(), event.getHitVec());
            if (useBlockResult.m_19077_()) {
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, event.getPos(), stack);
                }
                event.setCanceled(true);
                event.setCancellationResult(useBlockResult);
            } else {
                InteractionResult result = Drinkable.attemptDrink(level, event.getEntity(), true);
                if (result != InteractionResult.PASS) {
                    event.setCanceled(true);
                    event.setCancellationResult(result);
                }
            }
        }
        if (state.m_60734_() instanceof AnvilBlock || state.m_60734_() instanceof RockAnvilBlock || Fertilizer.get(stack) != null || state.m_60734_() instanceof BarrelBlock && !((Boolean)state.m_61143_((Property)BarrelBlock.RACK)).booleanValue() && ((Direction)state.m_61143_(BarrelBlock.FACING)).m_122434_().m_122479_() && stack.m_41720_() == ((Block)TFCBlocks.BARREL_RACK.get()).m_5456_()) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), FAKE_MISS);
        InteractionManager.onItemUse(event.getItemStack(), context, true).ifPresent(result -> {
            event.setCanceled(true);
            event.setCancellationResult(result);
        });
    }

    public static void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        InteractionResult result;
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().m_41619_() && (result = Drinkable.attemptDrink(event.getLevel(), event.getEntity(), false)) == InteractionResult.SUCCESS) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PlayerDrinkPacket());
        }
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        @Nullable IFood food = FoodCapability.get(stack);
        if (food instanceof DynamicBowlHandler) {
            event.setResultStack(DynamicBowlHandler.onItemUse(stack, event.getResultStack(), event.getEntity()));
        }
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(Metal.MANAGER);
        event.addListener(KnappingType.MANAGER);
        event.addListener(Fuel.MANAGER);
        event.addListener(Drinkable.MANAGER);
        event.addListener(Support.MANAGER);
        event.addListener(Pannable.MANAGER);
        event.addListener(Sluiceable.MANAGER);
        event.addListener(LampFuel.MANAGER);
        event.addListener(Fertilizer.MANAGER);
        event.addListener(ItemSizeManager.MANAGER);
        event.addListener(ClimateRange.MANAGER);
        event.addListener(Fauna.MANAGER);
        event.addListener(HeatCapability.MANAGER);
        event.addListener(FoodCapability.MANAGER);
        event.addListener(EntityDamageResistance.MANAGER);
        event.addListener(ItemDamageResistance.MANAGER);
        Helpers.setCachedRecipeManager(event.getServerResources().m_206887_());
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        PacketHandler.send(target, Metal.MANAGER.createSyncPacket());
        PacketHandler.send(target, KnappingType.MANAGER.createSyncPacket());
        PacketHandler.send(target, Fuel.MANAGER.createSyncPacket());
        PacketHandler.send(target, Fertilizer.MANAGER.createSyncPacket());
        PacketHandler.send(target, ItemDamageResistance.MANAGER.createSyncPacket());
        PacketHandler.send(target, HeatCapability.MANAGER.createSyncPacket());
        PacketHandler.send(target, FoodCapability.MANAGER.createSyncPacket());
        PacketHandler.send(target, ItemSizeManager.MANAGER.createSyncPacket());
        PacketHandler.send(target, ClimateRange.MANAGER.createSyncPacket());
        PacketHandler.send(target, Drinkable.MANAGER.createSyncPacket());
        PacketHandler.send(target, LampFuel.MANAGER.createSyncPacket());
        PacketHandler.send(target, Pannable.MANAGER.createSyncPacket());
        PacketHandler.send(target, Sluiceable.MANAGER.createSyncPacket());
        PacketHandler.send(target, Support.MANAGER.createSyncPacket());
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData()) {
            RecipeManager manager = Helpers.getUnsafeRecipeManager();
            IndirectHashCollection.reloadAllCaches(manager);
            Support.updateMaximumSupportRange();
            Metal.updateMetalFluidMap();
            ItemSizeManager.applyItemStackSizeOverrides();
            FoodCapability.markRecipeOutputsAsNonDecaying(event.getRegistryAccess(), manager);
            if (((Boolean)TFCConfig.COMMON.enableDatapackTests.get()).booleanValue()) {
                SelfTests.runDataPackTests(manager);
            }
            RecipeManagerAccessor accessor = (RecipeManagerAccessor)manager;
            for (RecipeType type : BuiltInRegistries.f_256990_) {
                LOGGER.debug("Loaded {} recipes of type {}", (Object)accessor.invoke$byType(type).size(), (Object)BuiltInRegistries.f_256990_.m_7981_((Object)type));
            }
        }
    }

    public static void onBoneMeal(BonemealEvent event) {
        if (!((Boolean)TFCConfig.SERVER.enableVanillaBonemeal.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    public static void onSelectClimateModel(SelectClimateModelEvent event) {
        ServerLevel level = event.level();
        if (event.level().m_46472_() == Level.f_46428_ && level.m_7726_().m_8481_() instanceof ChunkGeneratorExtension) {
            event.setModel(new OverworldClimateModel());
        }
    }

    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        if (event.getTarget().m_6095_() == EntityType.f_20469_ && (entity = event.getTarget()) instanceof Minecart) {
            BlockItem bi;
            ItemStack held;
            Item item;
            Minecart oldCart = (Minecart)entity;
            if (player.m_6144_() && player.m_36341_() && (item = (held = player.m_21120_(event.getHand())).m_41720_()) instanceof BlockItem && Helpers.isBlock((bi = (BlockItem)item).m_40614_(), TFCTags.Blocks.MINECART_HOLDABLE)) {
                ItemStack holdingItem = held.m_41620_(1);
                if (!player.m_9236_().f_46443_) {
                    HoldingMinecart minecart = new HoldingMinecart(player.m_9236_(), oldCart.m_20185_(), oldCart.m_20186_(), oldCart.m_20189_());
                    HoldingMinecart.copyMinecart((AbstractMinecart)oldCart, minecart);
                    minecart.setHoldItem(holdingItem);
                    oldCart.m_146870_();
                    player.m_9236_().m_7967_((Entity)minecart);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    public static void onMount(EntityMountEvent event) {
        if (event.getEntityBeingMounted() instanceof Boat && event.getEntityMounting() instanceof Predator) {
            event.setCanceled(true);
        }
    }

    public static void onAnimalTame(AnimalTameEvent event) {
        if (Helpers.isEntity((Entity)event.getEntity(), TFCTags.Entities.HORSES)) {
            event.setCanceled(true);
        }
    }

    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof BlockEntityContainer) {
            PestContainer test;
            BlockEntityContainer container = (BlockEntityContainer)abstractContainerMenu;
            abstractContainerMenu = event.getContainer();
            if (abstractContainerMenu instanceof PestContainer && (test = (PestContainer)abstractContainerMenu).canBeInfested()) {
                Player player = event.getEntity();
                Level level = player.m_9236_();
                if (level.f_46443_) {
                    return;
                }
                int amount = 0;
                if (((Boolean)TFCConfig.SERVER.enableInfestations.get()).booleanValue()) {
                    for (Slot slot : container.f_38839_) {
                        if (container.typeOf(slot.f_40219_) != Container.IndexType.CONTAINER || !Helpers.isItem(slot.m_7993_(), TFCTags.Items.FOODS) || ++amount != 5) continue;
                        break;
                    }
                }
                Helpers.tickInfestation(level, container.getBlockEntity().m_58899_(), amount, player);
            }
        }
    }

    public static void onCropsGrow(BlockEvent.CropGrowEvent event) {
        BlockState state = event.getState();
        LevelAccessor level = event.getLevel();
        if (state.m_60734_() instanceof BambooStalkBlock && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if ((double)server.f_46441_.m_188501_() > (Double)TFCConfig.SERVER.plantLongGrowthChance.get()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

