/*
 * Decompiled with CFR 0.152.
 */
package tfchotornot;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.dries007.tfc.common.capabilities.DelegateHeatHandler;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfchotornot.Config;
import tfchotornot.common.HNTags;

public final class EventHandler {
    public static final String MESSAGE_ITEM_GETTING_HOT = "message.tfchotornot.item_getting_hot";
    public static final String TOOLTIP_TOO_HOT = "tooltip.tfchotornot.toohot";
    public static final String TOOLTIP_TOO_COLD = "tooltip.tfchotornot.toocold";
    public static final String TOOLTIP_TOO_LIGHT = "tooltip.tfchotornot.toolight";

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventPriority.HIGHEST, EventHandler::onTick);
    }

    public static void onTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.phase == TickEvent.Phase.START) {
            for (Player player : event.level.m_6907_()) {
                if (!(player instanceof ServerPlayer) || player.m_6060_() || player.m_7500_() || player.m_21023_(MobEffects.f_19607_) || player.m_21023_(MobEffects.f_19606_)) continue;
                LazyOptional handler = player.getCapability(ForgeCapabilities.ITEM_HANDLER);
                handler.ifPresent(h -> {
                    for (int i = 0; i < h.getSlots(); ++i) {
                        ItemStack stack = h.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        LazyOptional fluidHandlerItem = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                        if (fluidHandlerItem.isPresent()) {
                            fluidHandlerItem.ifPresent(fh -> {
                                FluidStack fluidStack = fh.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                                if (fluidStack != FluidStack.EMPTY && Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.FLUID_WHITELIST)) {
                                    if (Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.COLD_WHITELIST) || fluidStack.getFluid().getFluidType().getTemperature(fluidStack) <= (Integer)Config.COMMON.coldFluidTemperature.get()) {
                                        EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.COLD, event);
                                    }
                                    if (Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.GASEOUS_WHITELIST) || Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.GASEOUS_WHITELIST) && ((Boolean)Config.COMMON.enableGaseous.get()).booleanValue()) {
                                        EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.GAS, event);
                                    }
                                    if (Helpers.isFluid((Fluid)fluidStack.getFluid(), HNTags.Fluids.HOT_WHITELIST) || fluidStack.getFluid().getFluidType().getTemperature(fluidStack) >= (Integer)Config.COMMON.hotFluidTemperature.get()) {
                                        EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.HOT, event);
                                    }
                                }
                            });
                            continue;
                        }
                        if (HeatCapability.has((ItemStack)stack)) {
                            IHeat heat = HeatCapability.get((ItemStack)stack);
                            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.COLD_WHITELIST) || heat.getTemperature() <= (float)((Integer)Config.COMMON.coldTemperature.get()).intValue()) {
                                EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.COLD, event);
                            }
                            if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.GASEOUS_WHITELIST) && ((Boolean)Config.COMMON.enableGaseous.get()).booleanValue()) {
                                EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.GAS, event);
                            }
                            if (!Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.HOT_WHITELIST) && !(heat.getTemperature() >= (float)((Integer)Config.COMMON.hotTemperature.get()).intValue())) continue;
                            EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.HOT, event);
                            continue;
                        }
                        if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.COLD_WHITELIST)) {
                            EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.COLD, event);
                        }
                        if (Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.GASEOUS_WHITELIST) && ((Boolean)Config.COMMON.enableGaseous.get()).booleanValue()) {
                            EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.GAS, event);
                        }
                        if (!Helpers.isItem((Item)stack.m_41720_(), HNTags.Items.HOT_WHITELIST)) continue;
                        EventHandler.applyEffectAndDamageMitts(stack, player, FluidEffect.HOT, event);
                    }
                });
            }
        }
    }

    public static void yeetItem(ItemStack stack, Player player, FluidEffect effect, TickEvent.LevelTickEvent event) {
        if (event.level.m_46467_() % 20L == 0L && !player.m_5842_()) {
            effect.interactPlayer.accept(player);
            if (((Boolean)Config.COMMON.yeet.get()).booleanValue()) {
                player.m_7197_(stack, false, true);
                player.m_150109_().m_36057_(stack);
            }
        }
    }

    public static void manageHeldItem(ItemStack held, ItemStack stack, Player player, TickEvent.LevelTickEvent event) {
        float currentHeat;
        float nextHeat;
        float factor = 1.0f;
        IHeat heatOffhand = HeatCapability.get((ItemStack)held);
        IHeat heat = HeatCapability.get((ItemStack)stack);
        HeatingRecipe recipeOffhand = HeatingRecipe.getRecipe((ItemStack)held);
        Item item = stack.m_41720_();
        if (item instanceof DelegateHeatHandler) {
            DelegateHeatHandler vessel = (DelegateHeatHandler)item;
            heat = vessel.getHeatHandler();
        }
        float heatDelta = ((Double)Config.COMMON.itemTemperatureModifier.get()).floatValue() / heatOffhand.getHeatCapacity();
        float targetHeat = heat.getTemperature();
        float f = nextHeat = targetHeat > (currentHeat = heatOffhand.getTemperature()) ? Math.min(targetHeat, currentHeat + heatDelta) : Math.max(targetHeat, currentHeat - heatDelta);
        if (heat.getTemperature() > 0.0f) {
            if (recipeOffhand != null) {
                factor = Mth.m_14036_((float)(heat.getTemperature() / (recipeOffhand.getTemperature() * 1.5f) / heatOffhand.getHeatCapacity()), (float)1.0f, (float)4.0f);
            }
            if (event.level.m_46467_() % (long)((Integer)Config.COMMON.itemHeatTimeInterval.get()).intValue() == 0L) {
                heatOffhand.addTemperatureFromSourceWithHeatCapacity(nextHeat, heatOffhand.getHeatCapacity());
            }
        }
        if (factor > 0.0f && event.level.m_46467_() % (long)((Integer)Config.COMMON.itemDamageTimeInterval.get()).intValue() == 0L) {
            held.m_41622_(Mth.m_14143_((float)(1.0f * factor)), (LivingEntity)player, consumer -> {});
        }
    }

    public static void meltItem(ItemStack held, Player player) {
        IHeat heatHeld = HeatCapability.get((ItemStack)held);
        HeatingRecipe recipe = HeatingRecipe.getRecipe((ItemStack)held);
        if (recipe != null) {
            if (heatHeld.getTemperature() >= recipe.getTemperature() * 0.7f) {
                player.m_5661_((Component)Component.m_237115_((String)MESSAGE_ITEM_GETTING_HOT).m_130940_(ChatFormatting.RED), true);
            }
            if (heatHeld.getTemperature() >= recipe.getTemperature()) {
                ItemStack recipeItem = recipe.assembleStacked(new ItemStackInventory(held), 64, recipe.getChance());
                FluidStack recipeFluid = recipe.assembleFluid(new ItemStackInventory(held));
                if (!recipeItem.m_41619_()) {
                    player.m_7197_(recipe.assembleStacked(new ItemStackInventory(held), held.m_41741_(), recipe.getChance()), false, true);
                }
                if (!recipeFluid.isEmpty() && ((Boolean)Config.COMMON.toggleFluidPuddle.get()).booleanValue() && recipeFluid.getFluid().m_76145_().m_76188_().m_61138_((Property)BlockStateProperties.f_61422_)) {
                    player.m_9236_().m_46597_(player.m_20183_(), (BlockState)recipeFluid.getFluid().m_76145_().m_76188_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(Math.round(Mth.m_14036_((float)Mth.m_184631_((float)recipeFluid.getAmount(), (float)0.0f, (float)1000.0f, (float)0.0f, (float)15.0f), (float)0.0f, (float)15.0f)))));
                }
                player.m_150109_().m_36057_(held);
            }
        }
    }

    public static void manageHotItemsInHand(ItemStack held, ItemStack stack, Player player, TickEvent.LevelTickEvent event) {
        if (HeatCapability.has((ItemStack)held)) {
            EventHandler.meltItem(held, player);
            if (HeatCapability.has((ItemStack)stack) && EventHandler.isWorkingWithGlass(stack, held) && EventHandler.isHoldingInsulatingItem(stack, held)) {
                EventHandler.manageHeldItem(held, stack, player, event);
            }
        }
    }

    public static boolean isWorkingWithGlass(ItemStack stack, ItemStack held) {
        TagKey blowpipeWithGlass = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Helpers.identifier((String)"glass_blowpipes"));
        return Helpers.isItem((ItemStack)held, (TagKey)blowpipeWithGlass) && HeatCapability.has((ItemStack)held) && HeatCapability.get((ItemStack)held).getTemperature() > 0.0f && stack != held;
    }

    public static boolean isGlassBlowpipe(ItemStack held) {
        TagKey blowpipeWithGlass = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Helpers.identifier((String)"glass_blowpipes"));
        return Helpers.isItem((ItemStack)held, (TagKey)blowpipeWithGlass) && HeatCapability.has((ItemStack)held) && HeatCapability.get((ItemStack)held).getTemperature() > 0.0f;
    }

    public static boolean isHoldingInsulatingItem(ItemStack stack, ItemStack held) {
        return Helpers.isItem((ItemStack)held, HNTags.Items.INSULATING) && stack != held;
    }

    public static void applyEffectAndDamageMitts(ItemStack stack, Player player, FluidEffect effect, TickEvent.LevelTickEvent event) {
        ItemStack offHand = player.m_21206_();
        ItemStack mainHand = player.m_21205_();
        EventHandler.manageHotItemsInHand(offHand, stack, player, event);
        EventHandler.manageHotItemsInHand(mainHand, stack, player, event);
        if (!Helpers.isItem((ItemStack)offHand, HNTags.Items.INSULATING) && !Helpers.isItem((ItemStack)mainHand, HNTags.Items.INSULATING)) {
            ItemStack itemToYeet;
            ItemStack itemStack = itemToYeet = EventHandler.manageYeetingForHand(offHand, stack) ^ EventHandler.manageYeetingForHand(mainHand, stack) ? null : stack;
            if (itemToYeet != null) {
                EventHandler.yeetItem(itemToYeet, player, effect, event);
            }
        }
    }

    public static boolean manageYeetingForHand(ItemStack held, ItemStack stack) {
        return stack == held && EventHandler.isGlassBlowpipe(held);
    }

    public static enum FluidEffect {
        HOT(Objects::nonNull, player -> player.m_20254_(1), (Component)Component.m_237115_((String)"tooltip.tfchotornot.toohot").m_130940_(ChatFormatting.RED)),
        COLD(Objects::nonNull, player -> {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 21, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 21, 1));
        }, (Component)Component.m_237115_((String)"tooltip.tfchotornot.toocold").m_130940_(ChatFormatting.AQUA)),
        GAS(fluidStack -> fluidStack.getFluid().getFluidType().isLighterThanAir() && (Boolean)Config.COMMON.enableGaseous.get() != false, player -> player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 21, 1)), (Component)Component.m_237115_((String)"tooltip.tfchotornot.toolight").m_130940_(ChatFormatting.YELLOW));

        public final Predicate<FluidStack> isValid;
        public final Consumer<Player> interactPlayer;
        public final Component tooltip;

        private FluidEffect(Predicate<FluidStack> isValid, Consumer<Player> interactPlayer, Component component) {
            this.isValid = isValid;
            this.interactPlayer = interactPlayer;
            this.tooltip = component;
        }
    }
}

