/*
 * Decompiled with CFR 0.152.
 */
package tfcdesirepaths.mixin;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.recipes.inventory.BlockInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tfcdesirepaths.Config;
import tfcdesirepaths.PathEvent;
import tfcdesirepaths.TFCDesirePaths;
import tfcdesirepaths.common.DPTags;
import tfcdesirepaths.common.recipes.CompactionRecipe;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private double xOld;
    @Unique
    private double zOld;
    @Unique
    private static double speed = 0.001;
    @Unique
    private static int entityDebugCooldown = 1000;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void inject$tick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (((Boolean)Config.COMMON.toggleCarts.get()).booleanValue() && ModList.get().isLoaded("astikorcarts") && entity != null && Helpers.isEntity((Entity)entity, DPTags.Entities.TRAMPLING_ENTITIES)) {
            Level level;
            BlockPos posEntity = entity.m_20183_();
            double entityDistX = entity.m_20185_() - this.xOld;
            double entityDistZ = entity.m_20189_() - this.zOld;
            double speedCurrent = Math.sqrt(entityDistX * entityDistX + entityDistZ * entityDistZ);
            this.xOld = entity.m_20185_();
            this.zOld = entity.m_20189_();
            if (speedCurrent > 0.0) {
                speed = speedCurrent;
            }
            if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
                if (entityDebugCooldown == 0) {
                    TFCDesirePaths.LOGGER.debug("[Cart] Pos Y: " + posEntity.m_123342_());
                    TFCDesirePaths.LOGGER.debug("[Cart] Speed: " + speed);
                    entityDebugCooldown = 100;
                } else {
                    --entityDebugCooldown;
                }
            }
            if ((level = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (speed > (Double)Config.COMMON.cartSpeedThreshold.get()) {
                    for (int i = 0; i < 3; ++i) {
                        if (i == 1) continue;
                        float offset = 38.0f - (float)i * 38.0f;
                        double blockPosX = entity.m_20185_() + Math.sin(Math.toRadians(entity.m_146908_() - offset)) * 1.7;
                        double blockPosZ = entity.m_20189_() - Math.cos(Math.toRadians(entity.m_146908_() - offset)) * 1.7;
                        Vec3 vec3 = new Vec3(blockPosX, (double)posEntity.m_123342_(), blockPosZ);
                        BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
                        BlockPos blockPosBelow = blockPos.m_7495_();
                        CompactionRecipe recipeIn = CompactionRecipe.getRecipe((Level)server, new BlockInventory(blockPos, server.m_8055_(blockPos)));
                        if (recipeIn != null && recipeIn.isSnow()) {
                            EntityMixin.compactBlockEntity(recipeIn, blockPos, server, entity);
                            continue;
                        }
                        CompactionRecipe recipe = CompactionRecipe.getRecipe((Level)server, new BlockInventory(blockPosBelow, server.m_8055_(blockPosBelow)));
                        EntityMixin.compactBlockEntity(recipe, blockPosBelow, server, entity);
                    }
                }
            }
        }
    }

    @Unique
    private static void compactBlockEntity(CompactionRecipe recipe, BlockPos pos, ServerLevel level, Entity entity) {
        if (recipe != null && CompactionRecipe.getRecipe((Level)level, new BlockInventory(pos, level.m_8055_(pos))) != null) {
            BlockState state = level.m_8055_(pos);
            double chance = (double)(1 + recipe.getChance() + recipe.getChanceFactor()) / (speed + (Double)Config.COMMON.cartCompactFactor.get());
            if (((Boolean)Config.COMMON.destroyVegetation.get()).booleanValue() && level.m_213780_().m_188503_(1 + Mth.m_14107_((double)chance)) == 0) {
                for (int y = 0; y <= Mth.m_14167_((float)entity.m_20206_()); ++y) {
                    BlockPos posUp = pos.m_6630_(1 + y);
                    Block block = level.m_8055_(posUp).m_60734_();
                    if (!(block instanceof BushBlock) && !(block instanceof GroundcoverBlock) && !(block instanceof PlacedItemBlock) && !Helpers.isBlock((Block)block, (TagKey)TFCTags.Blocks.SINGLE_BLOCK_REPLACEABLE) && !Helpers.isBlock((Block)block, DPTags.Blocks.TRAMPLE_WHITELIST) || Helpers.isBlock((Block)block, DPTags.Blocks.TRAMPLE_BLACKLIST)) continue;
                    level.m_46961_(posUp, true);
                }
            }
            if (((Boolean)Config.COMMON.toggleDynamicGrass.get()).booleanValue() && state.m_60734_() instanceof ConnectedGrassBlock && state.m_61138_((Property)PathEvent.DEGRADATION)) {
                if (level.m_213780_().m_188503_(1 + Mth.m_14107_((double)chance)) == 0) {
                    if ((Integer)state.m_61143_((Property)PathEvent.DEGRADATION) < 5) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)PathEvent.DEGRADATION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PathEvent.DEGRADATION) + 1)));
                    } else {
                        CompactionRecipe.compactBlock((Level)level, pos, state, chance);
                    }
                }
            } else {
                CompactionRecipe.compactBlock((Level)level, pos, state, chance);
            }
        }
    }
}

