/*
 * Decompiled with CFR 0.152.
 */
package tfcdesirepaths.mixin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tfcdesirepaths.Config;
import tfcdesirepaths.PathEvent;

@Mixin(value={ConnectedGrassBlock.class})
public abstract class ConnectedGrassBlockMixin
extends Block
implements IGrassBlock {
    @Shadow
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    @Shadow
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    @Shadow
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    @Shadow
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    @Shadow
    public static final BooleanProperty SNOWY = BlockStateProperties.f_61451_;
    @Shadow
    private static final Map<Direction, BooleanProperty> PROPERTIES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.EAST, (Object)EAST, (Object)Direction.WEST, (Object)WEST, (Object)Direction.SOUTH, (Object)SOUTH);
    @Unique
    private static final IntegerProperty DEGRADATION = PathEvent.DEGRADATION;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void inject$init(CallbackInfo ci) {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf(0)));
    }

    public ConnectedGrassBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="TAIL")})
    private void inject$createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.m_61104_(new Property[]{DEGRADATION});
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (((Boolean)Config.COMMON.toggleDynamicGrass.get()).booleanValue()) {
            int potentialDegradation = this.getPotentialDegradationForLightLevel(level, pos);
            if (state.m_61138_((Property)DEGRADATION) && potentialDegradation != (Integer)state.m_61143_((Property)DEGRADATION) && level.m_213780_().m_188503_(64) == 0) {
                Month currentMonth = Calendars.get((LevelReader)level).getCalendarMonthOfYear();
                Season season = currentMonth.getSeason();
                if (season != Season.WINTER && (Integer)state.m_61143_((Property)DEGRADATION) > 0 && potentialDegradation < (Integer)state.m_61143_((Property)DEGRADATION)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DEGRADATION) - 1)));
                }
                if (potentialDegradation > (Integer)state.m_61143_((Property)DEGRADATION)) {
                    int newDegradationLevel = (Integer)state.m_61143_((Property)DEGRADATION) + 1;
                    if (newDegradationLevel > 5) {
                        level.m_46597_(pos, this.getDirt());
                    } else {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf(newDegradationLevel)));
                    }
                }
            }
            if (!this.canBeGrass(state, (LevelReader)level, pos)) {
                if (level.isAreaLoaded(pos, 3)) {
                    if (state.m_61138_((Property)DEGRADATION)) {
                        if (potentialDegradation > (Integer)state.m_61143_((Property)DEGRADATION)) {
                            int newDegradationLevel = (Integer)state.m_61143_((Property)DEGRADATION) + 1;
                            if (newDegradationLevel > 5) {
                                level.m_46597_(pos, this.getDirt());
                            } else {
                                level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf(newDegradationLevel)));
                            }
                        }
                    } else {
                        level.m_46597_(pos, this.getDirt());
                    }
                }
            } else {
                BlockPos.MutableBlockPos posAt = pos.m_122032_();
                posAt.m_122184_(0, 1, 0);
                if (level.m_46803_((BlockPos)posAt) >= 9) {
                    for (int i = 0; i < 4; ++i) {
                        posAt.m_122154_((Vec3i)pos, random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                        BlockState stateAt = level.m_8055_((BlockPos)posAt);
                        Block block = stateAt.m_60734_();
                        if (!(block instanceof IDirtBlock)) continue;
                        IDirtBlock dirt = (IDirtBlock)block;
                        BlockState grassState = dirt.getGrass();
                        if (grassState.m_61138_((Property)DEGRADATION)) {
                            if (!this.canPropagate(grassState, (LevelReader)level, (BlockPos)posAt) || this.getPotentialDegradationForLightLevel(level, (BlockPos)posAt) >= 6) continue;
                            level.m_46597_((BlockPos)posAt, this.updateStateFromNeighbors((BlockGetter)level, (BlockPos)posAt, (BlockState)grassState.m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf(5))));
                            continue;
                        }
                        level.m_46597_((BlockPos)posAt, this.updateStateFromNeighbors((BlockGetter)level, (BlockPos)posAt, grassState));
                    }
                }
                PlantRegrowth.placeRisingRock((ServerLevel)level, (BlockPos)pos.m_7494_(), (RandomSource)random);
            }
            ci.cancel();
        }
    }

    @Shadow
    public BlockState getDirt() {
        return null;
    }

    @Shadow
    protected BlockState updateStateFromNeighbors(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return state;
    }

    @Unique
    private int getPotentialDegradationForLightLevel(ServerLevel level, BlockPos pos) {
        int lightLevel = level.m_45517_(LightLayer.SKY, pos.m_7494_());
        if (lightLevel <= 7) {
            return 6;
        }
        if (lightLevel <= 8) {
            return 5;
        }
        if (lightLevel <= 9) {
            return 4;
        }
        if (lightLevel <= 10) {
            return 3;
        }
        if (lightLevel <= 11) {
            return 2;
        }
        if (lightLevel <= 12) {
            return 1;
        }
        return 0;
    }
}

