/*
 * Decompiled with CFR 0.152.
 */
package tfcdesirepaths;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.recipes.inventory.BlockInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import tfcdesirepaths.Config;
import tfcdesirepaths.TFCDesirePaths;
import tfcdesirepaths.common.DPTags;
import tfcdesirepaths.common.recipes.CompactionRecipe;

public final class PathEvent {
    public static final IntegerProperty DEGRADATION = IntegerProperty.m_61631_((String)"degradation", (int)0, (int)5);
    public static int playerDebugCooldown = 100;
    public static int mobDebugCooldown = 1000;
    public static double speed = 0.001;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventPriority.HIGHEST, PathEvent::createPathPlayer);
        bus.addListener(EventPriority.HIGHEST, PathEvent::createPathMob);
    }

    public static void createPathPlayer(TickEvent.PlayerTickEvent event) {
        double playerDistZ;
        Player player = event.player;
        BlockPos posPlayer = player.m_20183_();
        BlockPos posPlayerBelow = posPlayer.m_7495_();
        Level level = player.m_9236_();
        double playerDistX = player.m_20185_() - player.f_19790_;
        double speedCurrent = Math.sqrt(playerDistX * playerDistX + (playerDistZ = player.m_20189_() - player.f_19792_) * playerDistZ);
        if (speedCurrent > 0.0) {
            speed = speedCurrent;
        }
        if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
            if (playerDebugCooldown == 0) {
                TFCDesirePaths.LOGGER.debug("[Player] Pos Y: " + posPlayerBelow.m_123342_());
                TFCDesirePaths.LOGGER.debug("[Player] Speed: " + speed);
                playerDebugCooldown = 100;
            } else {
                --playerDebugCooldown;
            }
        }
        if (!player.m_20163_() && !player.m_5833_() && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (speed > (Double)Config.COMMON.playerSpeedThreshold.get()) {
                CompactionRecipe recipeIn = CompactionRecipe.getRecipe((Level)server, new BlockInventory(posPlayer, server.m_8055_(posPlayer)));
                if (recipeIn != null && recipeIn.isSnow()) {
                    PathEvent.compactBlockPlayer(recipeIn, posPlayer, server, player);
                } else {
                    CompactionRecipe recipe = CompactionRecipe.getRecipe((Level)server, new BlockInventory(posPlayerBelow, server.m_8055_(posPlayerBelow)));
                    PathEvent.compactBlockPlayer(recipe, posPlayerBelow, server, player);
                }
            }
        }
    }

    public static void compactBlockPlayer(CompactionRecipe recipe, BlockPos pos, ServerLevel level, Player player) {
        if (recipe != null) {
            BlockState state = level.m_8055_(pos);
            if (((Boolean)Config.COMMON.destroyVegetation.get()).booleanValue() && level.m_213780_().m_188503_(1 + recipe.getChance()) == 0) {
                for (int y = 0; y <= Mth.m_14167_((float)player.m_20206_()); ++y) {
                    BlockPos posUp = pos.m_6630_(1 + y);
                    Block block = level.m_8055_(posUp).m_60734_();
                    if (!(block instanceof BushBlock) && !(block instanceof GroundcoverBlock) && !(block instanceof PlacedItemBlock) && !Helpers.isBlock((Block)block, (TagKey)TFCTags.Blocks.SINGLE_BLOCK_REPLACEABLE) && !Helpers.isBlock((Block)block, DPTags.Blocks.TRAMPLE_WHITELIST) || Helpers.isBlock((Block)block, DPTags.Blocks.TRAMPLE_BLACKLIST)) continue;
                    level.m_46961_(posUp, true);
                }
            }
            double sprintingFactor = player.m_20142_() ? Mth.m_14008_((double)(0.1 + speed * 8.0), (double)1.0, (double)25.0) : 1.0;
            double chance = (double)(1 + recipe.getChance() + recipe.getChanceFactor()) / sprintingFactor;
            if (((Boolean)Config.COMMON.toggleDynamicGrass.get()).booleanValue() && state.m_60734_() instanceof ConnectedGrassBlock && state.m_61138_((Property)DEGRADATION)) {
                if (level.m_213780_().m_188503_(1 + Mth.m_14107_((double)chance)) == 0) {
                    if ((Integer)state.m_61143_((Property)DEGRADATION) < 5) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DEGRADATION) + 1)));
                    } else {
                        CompactionRecipe.compactBlock((Level)level, pos, state, chance);
                    }
                }
            } else {
                CompactionRecipe.compactBlock((Level)level, pos, state, chance);
            }
        }
    }

    public static void createPathMob(LivingEvent.LivingTickEvent event) {
        if (((Boolean)Config.COMMON.allMobs.get()).booleanValue() && event.getEntity() != null && !(event.getEntity() instanceof Player) && !Helpers.isEntity((Entity)event.getEntity(), DPTags.Entities.ENTITY_BLACKLIST)) {
            double mobDistZ;
            LivingEntity entity = event.getEntity();
            BlockPos posEntity = entity.m_20183_();
            BlockPos posEntityBelow = entity.m_20183_().m_7495_();
            Level level = event.getEntity().m_9236_();
            double mobDistX = entity.m_20185_() - entity.f_19790_;
            double speedCurrent = Math.sqrt(mobDistX * mobDistX + (mobDistZ = entity.m_20189_() - entity.f_19792_) * mobDistZ);
            if (speedCurrent > 0.0) {
                speed = speedCurrent;
            }
            if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
                if (mobDebugCooldown == 0) {
                    TFCDesirePaths.LOGGER.debug("[Mob] Pos Y: " + posEntity.m_123342_());
                    TFCDesirePaths.LOGGER.debug("[Mob] Speed: " + speed);
                    mobDebugCooldown = 100;
                } else {
                    --mobDebugCooldown;
                }
            }
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (speed > (Double)Config.COMMON.mobSpeedThreshold.get()) {
                    CompactionRecipe recipeIn = CompactionRecipe.getRecipe((Level)server, new BlockInventory(posEntity, server.m_8055_(posEntity)));
                    if (recipeIn != null && recipeIn.isSnow()) {
                        PathEvent.compactBlockEntity(recipeIn, posEntity, server, entity);
                    } else {
                        CompactionRecipe recipe = CompactionRecipe.getRecipe((Level)server, new BlockInventory(posEntityBelow, server.m_8055_(posEntityBelow)));
                        PathEvent.compactBlockEntity(recipe, posEntityBelow, server, entity);
                    }
                }
            }
        }
    }

    public static void compactBlockEntity(CompactionRecipe recipe, BlockPos pos, ServerLevel level, LivingEntity entity) {
        if (recipe != null) {
            BlockState state = level.m_8055_(pos);
            if (((Boolean)Config.COMMON.destroyVegetation.get()).booleanValue() && level.m_213780_().m_188503_(1 + recipe.getChance()) == 0) {
                for (int y = 0; y <= Mth.m_14167_((float)entity.m_20206_()); ++y) {
                    BlockPos posUp = pos.m_6630_(1 + y);
                    Block block = level.m_8055_(posUp).m_60734_();
                    if (!(block instanceof BushBlock) && !(block instanceof GroundcoverBlock) && !(block instanceof PlacedItemBlock) && !Helpers.isBlock((Block)block, (TagKey)TFCTags.Blocks.SINGLE_BLOCK_REPLACEABLE) && !Helpers.isBlock((Block)block, DPTags.Blocks.TRAMPLE_WHITELIST) || Helpers.isBlock((Block)block, DPTags.Blocks.TRAMPLE_BLACKLIST)) continue;
                    level.m_46961_(posUp, true);
                }
            }
            double chance = recipe.getChance();
            if (((Boolean)Config.COMMON.toggleDynamicGrass.get()).booleanValue() && state.m_60734_() instanceof ConnectedGrassBlock && state.m_61138_((Property)DEGRADATION)) {
                if (level.m_213780_().m_188503_(1 + Mth.m_14107_((double)chance)) == 0) {
                    if ((Integer)state.m_61143_((Property)DEGRADATION) < 5) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEGRADATION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DEGRADATION) + 1)));
                    } else {
                        CompactionRecipe.compactBlock((Level)level, pos, state, chance);
                    }
                }
            } else {
                CompactionRecipe.compactBlock((Level)level, pos, state, chance);
            }
        }
    }
}

