/*
 * Decompiled with CFR 0.152.
 */
package tfcdesirepaths;

import java.util.function.Function;
import net.dries007.tfc.util.Helpers;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue enableDebug;
    public final ForgeConfigSpec.BooleanValue allMobs;
    public final ForgeConfigSpec.BooleanValue toggleCarts;
    public final ForgeConfigSpec.BooleanValue toggleRockBlocks;
    public final ForgeConfigSpec.BooleanValue destroyVegetation;
    public final ForgeConfigSpec.BooleanValue toggleDynamicGrass;
    public final ForgeConfigSpec.DoubleValue playerSpeedThreshold;
    public final ForgeConfigSpec.DoubleValue mobSpeedThreshold;
    public final ForgeConfigSpec.DoubleValue cartSpeedThreshold;
    public final ForgeConfigSpec.DoubleValue cartCompactFactor;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        if (!Helpers.BOOTSTRAP_ENVIRONMENT) {
            ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        }
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("tfcdesirepaths.config.common." + name);
        innerBuilder.comment(new String[]{"You can change the block compaction (paths) chance via a datapack, as this uses recipes,", "this means you can create custom desire path recipes, e.g. coal to diamond blocks, and set a custom chance"});
        innerBuilder.comment("");
        innerBuilder.push("general");
        this.enableDebug = builder.apply("enableDebug").comment("When enabled, prints debug values to console").define("enableDebug", false);
        this.allMobs = builder.apply("allMobs").comment("When enabled, all animals create paths (possibly performance intensive depending on the amount)").define("allMobs", true);
        this.toggleCarts = builder.apply("toggleCarts").comment("Should carts be able to compact blocks and create desire paths? True = enabled").define("toggleCarts", true);
        this.toggleRockBlocks = builder.apply("toggleRockBlocks").comment("If enabled, all rocky blocks as cobble, raw and hardened can be worn down. True = enabled").define("toggleRockBlocks", true);
        this.destroyVegetation = builder.apply("destroyVegetation").comment("When enabled, vegetation like tall grass or loose rocks gets destroyed").define("destroyVegetation", true);
        this.toggleDynamicGrass = builder.apply("toggleDynamicGrass").comment("Should grass naturally and incrementally decay or regrow according to the local light level? This makes e.g. forest more dynamic, simulating sparse undergrowth. Applies to the desire path mechanic too. True = enabled").define("toggleDynamicGrass", true);
        this.playerSpeedThreshold = builder.apply("playerSpeedThreshold").comment(new String[]{"The minimum speed the player should move at, in order for blocks to compact.", "Player sneaking is about 0.06, walking is about 0.215 and sprinting is above 0.26."}).defineInRange("playerSpeedThreshold", 0.15, 0.0, Double.MAX_VALUE);
        this.mobSpeedThreshold = builder.apply("mobSpeedThreshold").comment("The minimum speed a mob should move at, in order for blocks to compact").defineInRange("mobSpeedThreshold", 0.15, 0.0, Double.MAX_VALUE);
        this.cartSpeedThreshold = builder.apply("cartSpeedThreshold").comment("The minimum speed a cart should move at, in order for blocks to compact").defineInRange("cartSpeedThreshold", 0.07, 0.0, Double.MAX_VALUE);
        this.cartCompactFactor = builder.apply("cartCompactFactor").comment("The factor that affects the chance of path creation. Higher value equals higher chance").defineInRange("cartCompactFactor", 10.0, 1.0, Double.MAX_VALUE);
    }
}

