/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.util;

import java.util.Random;
import tfccaelum.util.MurmurHash3;
import tfccaelum.util.SplitMax;

public final class XorShiftRandom
extends Random {
    public static final double DOUBLE_UNIT = (double)1.110223E-16f;
    public static final float FLOAT_UNIT = 5.9604645E-8f;
    public static final int A = 24;
    public static final int B = 16;
    public static final int C = 37;
    public static final ThreadLocal<XorShiftRandom> localRandom = ThreadLocal.withInitial(XorShiftRandom::new);
    public long s0;
    public long s1;
    public boolean hasGaussian;
    public double nextGaussian;

    public XorShiftRandom() {
        this(SplitMax.current().next());
    }

    public XorShiftRandom(long seed) {
        super(0L);
        this.setSeed0(seed);
    }

    public static Random current() {
        return localRandom.get();
    }

    public void setSeed0(long seed) {
        this.s0 = seed == 0L ? 3735928559L : seed;
        this.s1 = MurmurHash3.hash(this.s0);
    }

    @Override
    public void setSeed(long seed) {
        this.setSeed0(seed);
        this.hasGaussian = false;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            long rnd = this.nextInt();
            int n = Math.min(len - i, 8);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    protected double genGaussian() {
        double v2;
        double v1;
        double s;
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextGaussian = v2 * multiplier;
        this.hasGaussian = true;
        return v1 * multiplier;
    }

    @Override
    public double nextGaussian() {
        if (!this.hasGaussian) {
            return this.genGaussian();
        }
        this.hasGaussian = false;
        return this.nextGaussian;
    }

    @Override
    public long nextLong() {
        long result = this.s0 + this.s1;
        long s1 = this.s1 ^ this.s0;
        this.s0 = Long.rotateLeft(this.s0, 24) ^ s1 ^ s1 << 16;
        this.s1 = Long.rotateLeft(s1, 37);
        return result;
    }

    @Override
    protected int next(int bits) {
        return (int)this.nextLong() >>> 32 - bits;
    }
}

