/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders.aurora;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfccaelum.shaders.aurora.AuroraShaderBand;
import tfccaelum.shaders.aurora.IAurora;

@OnlyIn(value=Dist.CLIENT)
public final class AuroraFactory {
    @Nonnull
    public static IAurora produce(long seed) {
        return new AuroraShaderBand(seed);
    }

    public static final class AuroraGeometry {
        public final int length;
        public final float nodeLength;
        public final float nodeWidth;
        public final int alphaLimit;
        public static final List<AuroraGeometry> PRESET = new ArrayList<AuroraGeometry>();

        public AuroraGeometry(int length, float nodeLength, float nodeWidth, int alphaLimit) {
            this.length = length;
            this.nodeLength = nodeLength;
            this.nodeWidth = nodeWidth;
            this.alphaLimit = alphaLimit;
        }

        @Nonnull
        public static AuroraGeometry get(@Nonnull Random random) {
            int idx = random.nextInt(PRESET.size());
            return PRESET.get(idx);
        }

        @Nonnull
        public String toString() {
            return "bandLength:" + this.length + ";nodeLength:" + this.nodeLength + ";nodeWidth:" + this.nodeWidth + ";alphaLimit:" + this.alphaLimit;
        }

        static {
            PRESET.add(new AuroraGeometry(128, 30.0f, 2.0f, 96));
            PRESET.add(new AuroraGeometry(128, 15.0f, 2.0f, 96));
            PRESET.add(new AuroraGeometry(64, 30.0f, 2.0f, 96));
            PRESET.add(new AuroraGeometry(64, 15.0f, 2.0f, 96));
            PRESET.add(new AuroraGeometry(128, 30.0f, 2.0f, 80));
            PRESET.add(new AuroraGeometry(128, 15.0f, 2.0f, 80));
            PRESET.add(new AuroraGeometry(64, 30.0f, 2.0f, 80));
            PRESET.add(new AuroraGeometry(64, 15.0f, 2.0f, 80));
            PRESET.add(new AuroraGeometry(128, 30.0f, 2.0f, 64));
            PRESET.add(new AuroraGeometry(128, 15.0f, 2.0f, 64));
            PRESET.add(new AuroraGeometry(64, 30.0f, 2.0f, 64));
            PRESET.add(new AuroraGeometry(64, 15.0f, 2.0f, 64));
        }
    }
}

