/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders.aurora;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfccaelum.Config;
import tfccaelum.gui.Color;
import tfccaelum.shaders.aurora.AuroraBand;
import tfccaelum.shaders.aurora.AuroraColor;
import tfccaelum.shaders.aurora.AuroraFactory;
import tfccaelum.shaders.aurora.AuroraLifeTracker;
import tfccaelum.shaders.aurora.IAurora;
import tfccaelum.util.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public abstract class AuroraBase
implements IAurora {
    public final Random random;
    public final AuroraBand band;
    public final int bandCount;
    public final double offset;
    public final AuroraLifeTracker tracker;
    public final AuroraColor colors;
    public final Player player;

    public AuroraBase(long seed) {
        this(new XorShiftRandom(seed));
    }

    public AuroraBase(Random rand) {
        this.random = rand;
        this.bandCount = Math.min(this.random.nextInt(3) + 1, (Integer)Config.COMMON.maxBands.get());
        this.offset = this.random.nextInt(20) + 20;
        this.colors = AuroraColor.get(this.random);
        AuroraFactory.AuroraGeometry geo = AuroraFactory.AuroraGeometry.get(this.random);
        this.band = new AuroraBand(this.random, geo);
        this.tracker = new AuroraLifeTracker(512, 1);
        this.player = Minecraft.m_91087_().f_91074_;
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public void update() {
        this.tracker.update();
    }

    @Override
    public boolean isComplete() {
        return !this.isAlive();
    }

    public double getAlpha() {
        return this.tracker.ageRatio() * (double)this.band.getAlphaLimit() / 255.0;
    }

    public double getTranslationX(double partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.player.f_19790_, (double)this.player.m_20185_());
    }

    public double getTranslationZ(double partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.player.f_19792_, (double)this.player.m_20189_()) - 150.0;
    }

    public double getTranslationY(LevelAccessor level, double partialTick) {
        double posY = Mth.m_14139_((double)partialTick, (double)this.player.f_19791_, (double)this.player.m_20186_()) + 64.0;
        double limit = (double)(level.m_151558_() + level.m_151558_()) / 2.0;
        return Mth.m_14008_((double)posY, (double)64.0, (double)limit);
    }

    @Nonnull
    public Color getBaseColor() {
        return this.colors.baseColor;
    }

    @Nonnull
    public Color getFadeColor() {
        return this.colors.fadeColor;
    }

    @Nonnull
    public Color getMiddleColor() {
        return this.colors.middleColor;
    }

    @Override
    public abstract void render(LevelAccessor var1, @Nonnull PoseStack var2, double var3);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("bands: ").append(this.bandCount);
        builder.append(", off: ").append(this.offset);
        builder.append(", len: ").append(this.band.length);
        builder.append(", base: ").append(this.getBaseColor().toString());
        builder.append(", fade: ").append(this.getFadeColor().toString());
        builder.append(", alpha: ").append((int)(this.getAlpha() * 255.0));
        if (!this.tracker.isAlive()) {
            builder.append(", DEAD");
        } else if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }
}

