/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders;

import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;
import tfccaelum.gui.Color;
import tfccaelum.shaders.ShaderProgram;

@OnlyIn(value=Dist.CLIENT)
public final class ShaderCallContext {
    private final ShaderProgram program;

    ShaderCallContext(@Nonnull ShaderProgram program) {
        this.program = program;
    }

    public void set(@Nonnull String uniform, double value) {
        GL20.glUniform1f((int)this.getUniform(uniform), (float)((float)value));
    }

    public void set(@Nonnull String uniform, double v1, double v2) {
        GL20.glUniform2f((int)this.getUniform(uniform), (float)((float)v1), (float)((float)v2));
    }

    public void set(@Nonnull String uniform, @Nonnull Color color) {
        this.set(uniform, color, 1.0);
    }

    public void set(@Nonnull String uniform, @Nonnull Color color, double alpha) {
        float[] params = new float[]{color.red(), color.green(), color.blue(), (float)alpha};
        GL20.glUniform4fv((int)this.getUniform(uniform), (float[])params);
    }

    public void set(@Nonnull String uniform, int ... values) {
        GL20.glUniform1iv((int)this.getUniform(uniform), (int[])values);
    }

    private int getUniform(@Nonnull String name) {
        return this.program.getUniform(name);
    }
}

