/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tfccaelum.Config;
import tfccaelum.Helpers;

@Mixin(value={LevelRenderer.class}, priority=10000)
public abstract class LevelRendererMixin {
    @Shadow
    private static final ResourceLocation f_109454_ = new ResourceLocation("textures/environment/moon_phases.png");
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    private double f_109421_;
    @Shadow
    private Minecraft f_109461_;

    @ModifyConstant(method={"renderSky"}, constant={@Constant(floatValue=30.0f)})
    private float rescaleSun(float sunSize) {
        return sunSize * ((Double)Config.COMMON.sunScale.get()).floatValue();
    }

    @ModifyConstant(method={"renderSky"}, constant={@Constant(floatValue=20.0f)})
    private float setSuperMoonSize(float moonSize) {
        float moonScale = (float)Helpers.supermoonCycle((LevelAccessor)this.f_109465_) * ((Double)Config.COMMON.moonScale.get()).floatValue();
        return moonSize * moonScale;
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=2)}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void inject$addPlanets(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (((Boolean)Config.COMMON.enablePlanets.get()).booleanValue()) {
            Helpers.renderPlanetsSpirograph((Level)this.f_109465_, poseStack, camera, partialTicks);
        }
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=2)}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void inject$addRainbows(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (((Boolean)Config.COMMON.enableRainbow.get()).booleanValue()) {
            Helpers.renderRainbow((Level)this.f_109465_, poseStack, partialTicks, camera);
        }
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=5)}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void inject$addMoonEclipse(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        Helpers.renderMoon((Level)this.f_109465_, poseStack, partialTicks, camera);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=2)}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void inject$solarEclipse(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f - this.f_109465_.m_46722_(partialTicks);
        float eclipseValue = (float)Mth.m_14008_((double)(Helpers.moonInclinationFactor((LevelAccessor)this.f_109465_) + Helpers.eclipseBrightness((LevelAccessor)this.f_109465_, 128.0, 4.0, 0.5, 16.0)), (double)0.0, (double)1.0);
        if (eclipseValue < 1.0f) {
            r /= eclipseValue;
            g *= eclipseValue;
            b *= eclipseValue;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getMoonPhase()I")}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void inject$changeMoonColor(PoseStack poseStack, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        double moonPosition = Helpers.moonPosition((LevelAccessor)this.f_109465_);
        float rainLevel = 1.0f - this.f_109465_.m_46722_(partialTicks);
        float rainStar = this.f_109465_.m_104811_(partialTicks) * rainLevel;
        int phase = this.f_109465_.m_46941_();
        if (phase == 4) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(rainStar > 0.0f ? rainStar : 1.0f));
        }
        if (Helpers.bloodmoonValue((LevelAccessor)this.f_109465_, partialTicks) > 0.0) {
            float moonEclipticFactor = (float)(1.0 - Helpers.moonInclinationBloodmoonFactor((LevelAccessor)this.f_109465_));
            float moonModifier = (float)Mth.m_14008_((double)(64.0 * Math.sin(-moonPosition * 0.5 * Math.PI) - 63.0), (double)0.0, (double)1.0) * moonEclipticFactor;
            float r = 1.0f + moonModifier * 0.25f;
            float g = 1.0f - moonModifier * 0.675f;
            float b = 1.0f - moonModifier * 0.85f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(10.0f * rainLevel));
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)Helpers.moonInclinationAngle((LevelAccessor)this.f_109465_)));
    }
}

