/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.mixin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import nuparu.caelum.client.SkyUtils;
import nuparu.caelum.config.ClientConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import tfccaelum.Config;
import tfccaelum.Helpers;

@Mixin(value={SkyUtils.class})
public abstract class SkyUtilsMixin {
    @Shadow
    private static Double starLatitudeRotation = null;

    @Overwrite(remap=false)
    public static double calculateStarLatitudeRotation(Level level, double z) {
        double solsticeFraction = Helpers.solsticeFraction(level);
        long scale = 20000L;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)server.m_7726_().m_8481_();
            scale = extension.settings().temperatureScale();
        }
        double seasonalMargin = -((double)scale * (solsticeFraction * (Double)Config.COMMON.earthSeasonalTilt.get()) * 0.01);
        double northPole = -((double)scale * 0.5);
        double southPole = (double)scale + (double)scale * 0.5;
        BigDecimal minZ = BigDecimal.valueOf(northPole).subtract(BigDecimal.valueOf(seasonalMargin));
        BigDecimal maxZ = BigDecimal.valueOf(southPole).add(BigDecimal.valueOf(seasonalMargin)).subtract(minZ);
        BigDecimal bigZ = BigDecimal.valueOf(z).subtract(minZ);
        double minZz = northPole - seasonalMargin;
        double maxZz = southPole + seasonalMargin - minZz;
        double bigZz = z - minZz;
        starLatitudeRotation = Mth.m_14008_((double)bigZ.divide(maxZ, RoundingMode.HALF_DOWN).doubleValue(), (double)0.0, (double)1.0) - 0.5;
        return starLatitudeRotation;
    }

    @Overwrite(remap=false)
    public static double yearRotation(Level level) {
        ICalendar calendar = Calendars.get((LevelReader)level);
        return (Long)ClientConfig.earthOrbitPeriod.get() == 0L ? 0.0 : (double)ICalendar.getFractionOfYear((long)calendar.getCalendarTicks(), (long)calendar.getCalendarDaysInMonth());
    }

    @Overwrite(remap=false)
    public static double apparentTimeOfDay(Level level, double z, float partialTicks) {
        double eclipseBrightness = Mth.m_14008_((double)(Helpers.moonInclinationFactor((LevelAccessor)level) + Helpers.eclipseBrightness((LevelAccessor)level, 128.0, 4.0, 0.0, 16.0)), (double)0.0, (double)1.0);
        double sunHeight = SkyUtils.sunHeight((Level)level, (double)z, (float)partialTicks);
        return 0.75 + sunHeight * eclipseBrightness / 4.0;
    }
}

