/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.mixin;

import net.dries007.tfc.ForgeEventHandler;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import tfccaelum.Config;
import tfccaelum.Helpers;

@Mixin(value={ForgeEventHandler.class})
public abstract class ForgeEventHandlerMixin {
    @Overwrite(remap=false)
    public static void onLivingSpawnCheck(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        MobSpawnType spawn = event.getSpawnType();
        if ((spawn == MobSpawnType.NATURAL || spawn == MobSpawnType.CHUNK_GENERATION || spawn == MobSpawnType.REINFORCEMENT) && net.dries007.tfc.util.Helpers.isEntity((Entity)entity, (TagKey)TFCTags.Entities.VANILLA_MONSTERS)) {
            if (((Boolean)TFCConfig.SERVER.enableVanillaMonsters.get()).booleanValue()) {
                double bloodmoonValue = Helpers.bloodmoonValue((LevelAccessor)level);
                if (!(bloodmoonValue > 0.2) || !((Boolean)Config.COMMON.enableBloodmoonSurfaceMonsters.get()).booleanValue()) {
                    BlockPos pos = entity.m_20183_();
                    if (entity.m_6095_() != EntityType.f_20526_ && level.m_45524_(pos, 0) != 0) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    } else if (level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_()) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    } else if (!net.dries007.tfc.util.Helpers.isBlock((BlockState)level.m_8055_(pos.m_7495_()), (TagKey)TFCTags.Blocks.MONSTER_SPAWNS_ON)) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    }
                }
            } else {
                event.setSpawnCancelled(true);
                event.setCanceled(true);
            }
        }
    }
}

