/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.gui;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfccaelum.util.Utilities;

@OnlyIn(value=Dist.CLIENT)
public class Color {
    protected float red;
    protected float green;
    protected float blue;
    protected float alpha;

    public Color(@Nonnull String fmt) {
        String[] parts = fmt.split(",");
        Preconditions.checkArgument((parts.length > 2 ? 1 : 0) != 0);
        int r = Integer.getInteger(parts[0]);
        int g = Integer.getInteger(parts[1]);
        int b = Integer.getInteger(parts[2]);
        int a = parts.length == 4 ? Integer.getInteger(parts[3]) : 255;
        this.red = Mth.m_14036_((float)((float)r / 255.0f), (float)0.0f, (float)1.0f);
        this.green = Mth.m_14036_((float)((float)g / 255.0f), (float)0.0f, (float)1.0f);
        this.blue = Mth.m_14036_((float)((float)b / 255.0f), (float)0.0f, (float)1.0f);
        this.alpha = Mth.m_14036_((float)((float)a / 255.0f), (float)0.0f, (float)1.0f);
    }

    public Color(@Nonnull ChatFormatting fmt) {
        Preconditions.checkArgument((boolean)fmt.m_126664_());
        Preconditions.checkNotNull((Object)fmt.m_126665_());
        int color = fmt.m_126665_();
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.green = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(color & 0xFF) / 255.0f;
        this.alpha = 1.0f;
    }

    public Color(@Nonnull Color color) {
        this(color.red, color.green, color.blue, color.alpha);
    }

    public Color(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public Color(int red, int green, int blue, int alpha) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public Color(@Nonnull Vec3 vec) {
        this((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    public Color(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgb >> 24 & 0xFF);
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
        this.green = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
        this.blue = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
        this.alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
    }

    public Color(double red, double green, double blue, double alpha) {
        this((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static Color parse(@Nonnull String input) {
        if (input.startsWith("#")) {
            return new Color(Integer.parseInt(input.substring(1), 16));
        }
        int[] parts = Utilities.splitToInts(input, ',');
        if (parts.length < 3) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid color definition", input));
        }
        return new Color(Mth.m_14045_((int)parts[0], (int)0, (int)255), Mth.m_14045_((int)parts[1], (int)0, (int)255), Mth.m_14045_((int)parts[2], (int)0, (int)255));
    }

    protected static float blnd(float c1, float c2, float factor) {
        return Mth.m_14036_((float)((float)Math.sqrt((1.0f - factor) * c1 * c1 + factor * c2 * c2)), (float)0.0f, (float)1.0f);
    }

    public float red() {
        return this.red;
    }

    public float green() {
        return this.green;
    }

    public float blue() {
        return this.blue;
    }

    @Nonnull
    public Vec3 toVec3d() {
        return new Vec3((double)this.red, (double)this.green, (double)this.blue);
    }

    @Nonnull
    public Vec3 transitionTo(@Nonnull Color target, int iterations) {
        double deltaRed = (target.red - this.red) / (float)iterations;
        double deltaGreen = (target.green - this.green) / (float)iterations;
        double deltaBlue = (target.blue - this.blue) / (float)iterations;
        return new Vec3(deltaRed, deltaGreen, deltaBlue);
    }

    @Nonnull
    public Color scale(float scaleFactor) {
        return this.scale(scaleFactor, scaleFactor, scaleFactor);
    }

    @Nonnull
    public Color scale(float scaleRed, float scaleGreen, float scaleBlue) {
        return new Color(this.red * scaleRed, this.green * scaleGreen, this.blue * scaleBlue, this.alpha);
    }

    @Nonnull
    public Color add(@Nonnull Color color) {
        return this.add(color.red, color.green, color.blue);
    }

    @Nonnull
    public Color add(float red, float green, float blue) {
        return new Color(this.red + red, this.green + green, this.blue + blue, this.alpha);
    }

    @Nonnull
    public Color blend(@Nonnull Color color, float factor) {
        return new Color(Color.blnd(this.red, color.red, factor), Color.blnd(this.green, color.green, factor), Color.blnd(this.blue, color.blue, factor), this.alpha);
    }

    @Nonnull
    public Color mix(@Nonnull Color color) {
        return this.mix(color.red, color.green, color.blue);
    }

    @Nonnull
    public Color mix(float red, float green, float blue) {
        return new Color((this.red + red) / 2.0f, (this.green + green) / 2.0f, (this.blue + blue) / 2.0f, this.alpha);
    }

    @Nonnull
    public Color luminance(float percent) {
        float r = Mth.m_14036_((float)(this.red + this.red * percent), (float)0.0f, (float)1.0f);
        float g = Mth.m_14036_((float)(this.green + this.green * percent), (float)0.0f, (float)1.0f);
        float b = Mth.m_14036_((float)(this.blue + this.blue * percent), (float)0.0f, (float)1.0f);
        return new Color(r, g, b, this.alpha);
    }

    public int rgb() {
        int iRed = (int)(this.red * 255.0f);
        int iGreen = (int)(this.green * 255.0f);
        int iBlue = (int)(this.blue * 255.0f);
        int iAlpha = (int)(this.alpha * 255.0f);
        return iAlpha << 24 | iRed << 16 | iGreen << 8 | iBlue;
    }

    public int rgbWithAlpha(float alpha) {
        return this.rgbWithAlpha(alpha * 255.0f);
    }

    public int rgbWithAlpha(int alpha) {
        int iRed = (int)(this.red * 255.0f);
        int iGreen = (int)(this.green * 255.0f);
        int iBlue = (int)(this.blue * 255.0f);
        int iAlpha = (int)(this.alpha * 255.0f);
        return alpha * 255 << 24 | iRed << 16 | iGreen << 8 | iBlue;
    }

    public int hashCode() {
        int result = Float.hashCode(this.red);
        result = 31 * result + Float.hashCode(this.green);
        result = 31 * result + Float.hashCode(this.blue);
        result = 31 * result + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof Color)) {
            return false;
        }
        Color color = (Color)anObject;
        return this.red == color.red && this.green == color.green && this.blue == color.blue && this.alpha == this.alpha;
    }

    @Nonnull
    public MutableColor asMutable() {
        return new MutableColor(this);
    }

    @Nonnull
    public String toString() {
        return "[r:" + (int)(this.red * 255.0f) + ",g:" + (int)(this.green * 255.0f) + ",b:" + (int)(this.blue * 255.0f) + ",a:" + (int)(this.alpha * 255.0f) + "]";
    }

    public static final class MutableColor
    extends Color {
        MutableColor(@Nonnull Color color) {
            super(color);
        }

        @Override
        @Nonnull
        public Color add(float red, float green, float blue) {
            this.red = Mth.m_14036_((float)(this.red + red), (float)0.0f, (float)1.0f);
            this.green = Mth.m_14036_((float)(this.green + green), (float)0.0f, (float)1.0f);
            this.blue = Mth.m_14036_((float)(this.blue + blue), (float)0.0f, (float)1.0f);
            return this;
        }

        @Override
        @Nonnull
        public Color blend(@Nonnull Color color, float factor) {
            this.red = MutableColor.blnd(this.red, color.red, factor);
            this.green = MutableColor.blnd(this.green, color.green, factor);
            this.blue = MutableColor.blnd(this.blue, color.blue, factor);
            return this;
        }

        @Override
        @Nonnull
        public Color scale(float scaleRed, float scaleGreen, float scaleBlue) {
            this.red = Mth.m_14036_((float)(this.red * scaleRed), (float)0.0f, (float)1.0f);
            this.green = Mth.m_14036_((float)(this.green * scaleGreen), (float)0.0f, (float)1.0f);
            this.blue = Mth.m_14036_((float)(this.blue * scaleBlue), (float)0.0f, (float)1.0f);
            return this;
        }

        @Override
        @Nonnull
        public Color mix(float red, float green, float blue) {
            this.red = Mth.m_14036_((float)((this.red + red) / 2.0f), (float)0.0f, (float)1.0f);
            this.green = Mth.m_14036_((float)((this.green + green) / 2.0f), (float)0.0f, (float)1.0f);
            this.blue = Mth.m_14036_((float)((this.blue + blue) / 2.0f), (float)0.0f, (float)1.0f);
            return this;
        }

        @Nonnull
        public Color adjust(@Nonnull Vec3 adjust, @Nonnull Color target) {
            this.red = (float)((double)this.red + adjust.f_82479_);
            if (adjust.f_82479_ < 0.0 && this.red < target.red || adjust.f_82479_ > 0.0 && this.red > target.red) {
                this.red = target.red;
            }
            this.green = (float)((double)this.green + adjust.f_82480_);
            if (adjust.f_82480_ < 0.0 && this.green < target.green || adjust.f_82480_ > 0.0 && this.green > target.green) {
                this.green = target.green;
            }
            this.blue = (float)((double)this.blue + adjust.f_82481_);
            if (adjust.f_82481_ < 0.0 && this.blue < target.blue || adjust.f_82481_ > 0.0 && this.blue > target.blue) {
                this.blue = target.blue;
            }
            return this;
        }

        @Nonnull
        public Color asImmutable() {
            return new Color(this);
        }
    }
}

