/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import nuparu.caelum.client.MoonController;
import nuparu.caelum.client.SkyUtils;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import tfccaelum.Config;
import tfccaelum.util.Planets;

public class Helpers {
    public static long pastTick;
    public static int rainbowTicker;
    public static long oldGameTime;
    public static final ResourceLocation textureRainbow;
    public static final ResourceLocation textureRainbowOuter;
    public static final ResourceLocation[] eclipseTextures;
    public static final ResourceLocation[] planetTextures;

    public static ResourceLocation identifier(String name) {
        return new ResourceLocation("tfccaelum", name);
    }

    public static double moonInclinationOscillation(LevelAccessor level) {
        double yearTime = 1000L + Calendars.get((LevelReader)level).getTicks() / (12L * (long)Calendars.get((LevelReader)level).getCalendarDaysInMonth() * 24000L);
        double yearPeriod = 18.6;
        double avgInclination = (Double)Config.COMMON.moonEarthEquatorInclination.get();
        return 5.15 * Math.sin(Math.PI * 2 / yearPeriod * yearTime) + avgInclination;
    }

    public static double moonInclinationAngle(LevelAccessor level) {
        double yearFraction = Math.cos(Math.PI * 2 * (double)Calendars.get((LevelReader)level).getCalendarFractionOfYear());
        return Helpers.moonInclinationOscillation(level) * yearFraction;
    }

    public static double moonInclinationFactor(LevelAccessor level) {
        double maxValue = Helpers.moonInclinationOscillation(level);
        return Math.abs(Helpers.moonInclinationAngle(level) / maxValue);
    }

    public static double moonInclinationEclipseFactor(LevelAccessor level) {
        return Mth.m_14008_((double)(-Math.pow(1.0 - Helpers.moonInclinationFactor(level), 100.0) + 1.0), (double)0.0, (double)1.0);
    }

    public static double moonInclinationBloodmoonFactor(LevelAccessor level) {
        return Mth.m_14008_((double)(-Math.pow(1.075 - Helpers.moonInclinationFactor(level), 20.0) + 1.0), (double)0.0, (double)1.0);
    }

    public static double supermoonCycle(LevelAccessor level) {
        double time = Calendars.get((LevelReader)level).getCalendarTicks();
        double orbit = Helpers.moonOrbitInTicks();
        return 1.0 + 0.07 * Math.sin(Math.PI * 2 * time / orbit);
    }

    public static double moonOrbitInTicks() {
        return (Double)Config.COMMON.moonOrbitalPeriod.get() * 24000.0;
    }

    public static double moonOrbitScaled() {
        return (double)Calendars.CLIENT.getCalendarDaysInMonth() * ((Double)Config.COMMON.moonOrbitalPeriod.get() / (Double)Config.COMMON.averageDaysPerMonth.get());
    }

    public static double moonOrbitScaledInTicks() {
        return Helpers.moonOrbitScaled() * 24000.0;
    }

    public static double moonOrbitScaled(LevelAccessor level) {
        return (double)Calendars.get((LevelReader)level).getCalendarDaysInMonth() * ((Double)Config.COMMON.moonOrbitalPeriod.get() / (Double)Config.COMMON.averageDaysPerMonth.get());
    }

    public static double moonOrbitScaledInTicks(LevelAccessor level) {
        return Helpers.moonOrbitScaled(level) * 24000.0;
    }

    public static double yearScaled(LevelAccessor level) {
        return (Double)Config.COMMON.earthOrbitalPeriod.get() * ((Double)Config.COMMON.earthOrbitalPeriod.get() / (double)Calendars.get((LevelReader)level).getTotalCalendarDays());
    }

    public static Vector2f orbitalSpirographicPosition(LevelAccessor level, Vector2f parentPos, float semiMajorAxis, double earthYear, double orbitalPeriod, float partialTicks, boolean isRetrograde) {
        double position = earthYear / orbitalPeriod * ((double)Calendars.get((LevelReader)level).getCalendarTicks() / (24000.0 * (Double)Config.COMMON.planetOrbit.get()));
        Vector2f newVec = new Vector2f(0.0f, 0.0f).set((Vector2fc)parentPos);
        if (!isRetrograde) {
            return newVec.add((Vector2fc)new Vector2f((float)Math.sin(position), (float)Math.cos(position)).mul(semiMajorAxis));
        }
        return newVec.add((Vector2fc)new Vector2f((float)Math.cos(position), (float)Math.sin(position)).mul(semiMajorAxis));
    }

    public static double synodicOrbitTime(LevelAccessor level, double daysToOrbit) {
        return (double)Calendars.get((LevelReader)level).getCalendarDaysInMonth() * (daysToOrbit / (Double)Config.COMMON.averageDaysPerMonth.get());
    }

    public static double synodicOrbitTimeInTicks(LevelAccessor level, double daysToOrbit) {
        return Helpers.synodicOrbitTime(level, daysToOrbit) * 24000.0;
    }

    public static double synodicOrbitPosition(LevelAccessor level, double daysToOrbit) {
        return (double)Calendars.get((LevelReader)level).getCalendarTicks() % Helpers.synodicOrbitTimeInTicks(level, daysToOrbit) / Helpers.synodicOrbitTimeInTicks(level, daysToOrbit);
    }

    public static double sunPosition(LevelAccessor level, float partialTicks) {
        return Mth.m_14089_((float)(level.m_46942_(partialTicks) * ((float)Math.PI * 2)));
    }

    public static double moonPosition(LevelAccessor level) {
        return -Math.cos((double)Calendars.get((LevelReader)level).getCalendarTicks() % Helpers.moonOrbitScaledInTicks(level) / Helpers.moonOrbitScaledInTicks(level) * 6.2831854820251465);
    }

    public static double solsticeFraction(Level level) {
        return -Math.cos((double)(Calendars.get((LevelReader)level).getCalendarFractionOfYear() * 2.0f) * Math.PI + Math.PI + 0.2);
    }

    public static double timeOfDay(LevelAccessor level) {
        double d0 = Mth.m_14185_((double)((double)(Calendars.get((LevelReader)level).getCalendarDayTime() / 24000L) - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (d0 * 2.0 + d1) / 3.0;
    }

    public static double bloodmoonValue(LevelAccessor level) {
        double sunPosition = Mth.m_14008_((double)(-1.5 * Math.sin(Helpers.sunPosition(level, 1.0f) * 0.5 * Math.PI) + 0.2), (double)0.0, (double)1.0);
        if (sunPosition > 0.0) {
            double moonInclinationFactor = 1.0 - Helpers.moonInclinationBloodmoonFactor(level);
            return Mth.m_14008_((double)(64.0 * Math.sin(-Helpers.moonPosition(level) * 0.5 * Math.PI) - 63.0), (double)0.0, (double)1.0) * moonInclinationFactor;
        }
        return 0.0;
    }

    public static double bloodmoonValue(LevelAccessor level, float partialTicks) {
        return Mth.m_14008_((double)(-1.5 * Math.sin(Helpers.sunPosition(level, partialTicks) * 0.5 * Math.PI) + 0.2), (double)0.0, (double)1.0);
    }

    public static double eclipseBrightness(LevelAccessor level) {
        double moonPosition = Helpers.moonPosition(level);
        moonPosition = moonPosition < 0.0 ? 0.0 : moonPosition;
        double moonScale = Helpers.supermoonCycle(level) * (double)((Double)Config.COMMON.moonScale.get()).floatValue();
        return Mth.m_14008_((double)((0.5 * Math.cos(moonPosition * Math.PI) + 0.5) * (500.0 / moonScale)), (double)0.0, (double)1.0);
    }

    public static double supermoonCycle() {
        double time = Calendars.CLIENT.getCalendarTicks();
        double orbit = Helpers.moonOrbitInTicks();
        return 1.0 + 0.07 * Math.sin(Math.PI * 2 * time / orbit);
    }

    public static boolean isSupermoonEvent(double minSizePercent) {
        return Helpers.supermoonCycle() > 1.0 + minSizePercent;
    }

    public static double moonPosition() {
        return -Math.cos((double)Calendars.CLIENT.getCalendarTicks() % Helpers.moonOrbitScaledInTicks() / Helpers.moonOrbitScaledInTicks() * 6.2831854820251465);
    }

    public static double eclipseBrightness(LevelAccessor level, double constant, double power, double minValue, double spread) {
        double moonInclinationFactor = 1.0 - Helpers.moonInclinationEclipseFactor(level);
        double moonPosition = Helpers.moonPosition(level) - 0.001;
        moonPosition = moonPosition < 0.0 ? 0.0 : moonPosition;
        double moonScaleValue = constant / (Helpers.supermoonCycle(level) * (double)((Double)Config.COMMON.moonScale.get()).floatValue() * 1.5);
        return Mth.m_14008_((double)(Math.pow(moonPosition * moonScaleValue - moonScaleValue, power) * spread + minValue + moonInclinationFactor), (double)0.0, (double)1.0);
    }

    public static float getStarBrightness(LevelAccessor level, float partialTicks) {
        float f = level.m_46942_(partialTicks);
        float f1 = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public static final Vec3 calculateViewVector(double xRot, double yRot) {
        double f = xRot * (Math.PI / 180);
        double f1 = -yRot * (Math.PI / 180);
        double f2 = Math.cos(f1);
        double f3 = Math.sin(f1);
        double f4 = Math.cos(f);
        double f5 = Math.sin(f);
        return new Vec3(f3 * f4, -f5, f2 * f4);
    }

    public static void renderPlanets(Level level, PoseStack poseStack, float partialTicks) {
        Tesselator tessellator = Tesselator.m_85913_();
        float rain = 1.0f - level.m_46722_(partialTicks);
        float starBrightness = Helpers.getStarBrightness((LevelAccessor)level, partialTicks) * rain;
        float planetScaleFactor = ((Double)Config.COMMON.planetScale.get()).floatValue();
        float planetDistanceFactor = ((Double)Config.COMMON.planetDistance.get()).floatValue();
        float scale = 1.0f;
        float distance = 1.0f;
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightness);
        for (Planets planet : Planets.values()) {
            switch (planet) {
                case MERCURY: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.mercurySynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.mercuryEclipticPlane.get()).floatValue()));
                    scale = 1.0f * planetScaleFactor;
                    distance = 250.0f * planetDistanceFactor;
                    break;
                }
                case VENUS: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.venusSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.venusEclipticPlane.get()).floatValue()));
                    scale = 1.0f * planetScaleFactor;
                    distance = 200.0f * planetDistanceFactor;
                    break;
                }
                case MARS: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.marsSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.marsEclipticPlane.get()).floatValue()));
                    scale = 1.0f * planetScaleFactor;
                    distance = 100.0f * planetDistanceFactor;
                    break;
                }
                case JUPITER: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.jupiterSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.jupiterEclipticPlane.get()).floatValue()));
                    scale = 2.0f * planetScaleFactor;
                    distance = 180.0f * planetDistanceFactor;
                    break;
                }
                case SATURN: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.saturnSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.saturnEclipticPlane.get()).floatValue()));
                    scale = 1.0f * planetScaleFactor;
                    distance = 180.0f * planetDistanceFactor;
                    break;
                }
                case URANUS: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.uranusSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.uranusEclipticPlane.get()).floatValue()));
                    scale = 1.0f * planetScaleFactor;
                    distance = 380.0f * planetDistanceFactor;
                    break;
                }
                case NEPTUNE: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.neptuneSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.neptuneEclipticPlane.get()).floatValue()));
                    scale = 1.0f * planetScaleFactor;
                    distance = 400.0f * planetDistanceFactor;
                    break;
                }
                case PLUTO: {
                    poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Helpers.synodicOrbitPosition((LevelAccessor)level, ((Double)Config.COMMON.plutoSynodicPeriod.get()).floatValue()) * (Math.PI * 2))));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(((Double)Config.COMMON.plutoEclipticPlane.get()).floatValue()));
                    scale = 0.6f * planetScaleFactor;
                    distance = 400.0f * planetDistanceFactor;
                }
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)planet.getTexture());
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            tessellator.m_85915_().m_252986_(mat, -scale, distance, -scale).m_7421_(0.0f, 0.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, scale, distance, -scale).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, scale, distance, scale).m_7421_(1.0f, 1.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, -scale, distance, scale).m_7421_(0.0f, 1.0f).m_5752_();
            tessellator.m_85914_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderPlanetsSpirograph(Level level, PoseStack poseStack, Camera camera, float partialTicks) {
        Tesselator tessellator = Tesselator.m_85913_();
        float rain = 1.0f - level.m_46722_(partialTicks);
        float starBrightness = Helpers.getStarBrightness((LevelAccessor)level, partialTicks) * rain;
        float distance = 100.0f;
        float timeOfDay = level.m_46942_(partialTicks) * 360.0f;
        for (Planets planet : Planets.values()) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightness);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)planet.getInclination()));
            float angleToSun = planet.getIsMoon() ? (float)planet.getParentBody().getAngleToSun(level, partialTicks) : (float)planet.getAngleToSun(level, partialTicks);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(timeOfDay + angleToSun));
            if (planet.getIsMoon()) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)planet.getMoonInclination()));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)planet.getAngleToParent(level, partialTicks)));
            }
            float scale = (float)planet.getScale(level, partialTicks);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)planet.getTexture());
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            tessellator.m_85915_().m_252986_(mat, -scale, distance, -scale).m_7421_(0.0f, 0.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, scale, distance, -scale).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, scale, distance, scale).m_7421_(1.0f, 1.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, -scale, distance, scale).m_7421_(0.0f, 1.0f).m_5752_();
            tessellator.m_85914_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public static void renderRainbow(Level level, PoseStack poseStack, float partialTicks, Camera camera) {
        long dayTime = Calendars.get((LevelReader)level).getCalendarDayTime();
        int startTick = 5000;
        float rain = level.m_46722_(partialTicks);
        float rainPast = level.m_46722_(partialTicks - 100.0f);
        float rainFuture = level.m_46722_(partialTicks + 100.0f);
        if (rain < 0.5f && rainPast > rain && rainFuture < rain && dayTime >= 0L && dayTime <= 9000L && rainbowTicker == 0) {
            rainbowTicker = 5000;
        }
        if (rainbowTicker > 0 && dayTime < 13000L) {
            if (oldGameTime < level.m_46467_()) {
                --rainbowTicker;
            }
            float eclipseValue = (float)Helpers.eclipseBrightness((LevelAccessor)level, 128.0, 4.0, 0.0, 16.0);
            float rainTransparency = (float)Math.sin(Math.pow((double)rainbowTicker * 3.544658838845707E-4, 2.0)) * eclipseValue;
            Tesselator tessellator = Tesselator.m_85913_();
            float distance = 200.0f;
            float time = level.m_46942_(partialTicks);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(time * 360.0f - (180.0f - (time <= 0.5f ? 40.0f : -40.0f))));
            for (int i = 1; i <= 2; ++i) {
                float scale = 35.0f * ((float)i * 0.8f) * 5.0f;
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)((i == 1 ? 0.6f : 0.05f) * rainTransparency));
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)(i == 1 ? textureRainbow : textureRainbowOuter));
                Matrix4f mat = poseStack.m_85850_().m_252922_();
                tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                tessellator.m_85915_().m_252986_(mat, -scale, distance + (float)i, -scale).m_7421_(0.0f, 0.0f).m_5752_();
                tessellator.m_85915_().m_252986_(mat, scale, distance + (float)i, -scale).m_7421_(1.0f, 0.0f).m_5752_();
                tessellator.m_85915_().m_252986_(mat, scale, distance + (float)i, scale).m_7421_(1.0f, 1.0f).m_5752_();
                tessellator.m_85915_().m_252986_(mat, -scale, distance + (float)i, scale).m_7421_(0.0f, 1.0f).m_5752_();
                tessellator.m_85914_();
            }
            poseStack.m_85849_();
        }
        oldGameTime = level.m_46467_();
    }

    public static void renderMoon(Level level, PoseStack poseStack, float partialTicks, Camera camera) {
        double proximity = Helpers.moonInclinationFactor((LevelAccessor)level);
        if (level.m_46941_() == 4 && proximity < 0.15) {
            Tesselator tessellator = Tesselator.m_85913_();
            float distance = 100.0f;
            float scale = 20.0f * (float)Helpers.supermoonCycle((LevelAccessor)level) * ((Double)Config.COMMON.moonScale.get()).floatValue();
            float eclipseValue = (float)Helpers.eclipseBrightness((LevelAccessor)level, 128.0, 4.0, 0.0, 16.0);
            int phase = (int)Math.round(Helpers.eclipseBrightness((LevelAccessor)level, 128.0, 4.0, 0.0, 32.0) * 7.0);
            if (phase != 0) {
                RenderSystem.enableBlend();
            } else {
                RenderSystem.disableBlend();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(-180.0 * SkyUtils.starLatitudeRotation((Level)level, (double)camera.m_90583_().m_7094_()))));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTicks) * 360.0f - 180.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252961_(-MoonController.MOON.getMoonOrbitPosition(level.m_46468_()) * ((float)Math.PI * 2)));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(-Helpers.moonInclinationAngle((LevelAccessor)level))));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - eclipseValue));
            RenderSystem.setShader(GameRenderer::m_172817_);
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)eclipseTextures[phase]);
            tessellator.m_85915_().m_252986_(mat, -scale, distance, -scale).m_7421_(0.0f, 0.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, scale, distance, -scale).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, scale, distance, scale).m_7421_(1.0f, 1.0f).m_5752_();
            tessellator.m_85915_().m_252986_(mat, -scale, distance, scale).m_7421_(0.0f, 1.0f).m_5752_();
            tessellator.m_85914_();
            poseStack.m_85849_();
        }
    }

    public static double dot(Vector2f v1, Vector2f v2) {
        return v1.x() * v2.x() + v1.y() * v2.y();
    }

    public static double det(Vector2f v1, Vector2f v2) {
        return v1.x() * v2.y() - v1.y() * v2.x();
    }

    public static double angle(Vector2f v1, Vector2f v2) {
        return Math.atan2(Helpers.det(v1, v2), Helpers.dot(v1, v2));
    }

    static {
        rainbowTicker = 0;
        oldGameTime = 0L;
        textureRainbow = Helpers.identifier("sky/rainbow.png");
        textureRainbowOuter = Helpers.identifier("sky/rainbow_outer.png");
        eclipseTextures = new ResourceLocation[]{Helpers.identifier("sky/eclipse/new_moon_0.png"), Helpers.identifier("sky/eclipse/new_moon_1.png"), Helpers.identifier("sky/eclipse/new_moon_2.png"), Helpers.identifier("sky/eclipse/new_moon_3.png"), Helpers.identifier("sky/eclipse/new_moon_4.png"), Helpers.identifier("sky/eclipse/new_moon_5.png"), Helpers.identifier("sky/eclipse/new_moon_6.png"), Helpers.identifier("sky/eclipse/new_moon_7.png")};
        planetTextures = new ResourceLocation[]{Helpers.identifier("sky/planets/mercury.png"), Helpers.identifier("sky/planets/venus.png"), Helpers.identifier("sky/planets/mars.png"), Helpers.identifier("sky/planets/jupiter.png"), Helpers.identifier("sky/planets/saturn.png"), Helpers.identifier("sky/planets/uranus.png"), Helpers.identifier("sky/planets/neptune.png"), Helpers.identifier("sky/planets/pluto.png")};
    }
}

