/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum;

import java.util.function.Function;
import net.dries007.tfc.util.Helpers;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue enableDebug;
    public final ForgeConfigSpec.BooleanValue enableRainbow;
    public final ForgeConfigSpec.BooleanValue enablePlanets;
    public final ForgeConfigSpec.BooleanValue enableBloodmoonSurfaceMonsters;
    public final ForgeConfigSpec.BooleanValue enableSunBlindness;
    public final ForgeConfigSpec.BooleanValue enableAurora;
    public final ForgeConfigSpec.IntValue maxBands;
    public final ForgeConfigSpec.DoubleValue averageDaysPerMonth;
    public final ForgeConfigSpec.DoubleValue moonOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue moonScale;
    public final ForgeConfigSpec.DoubleValue sunScale;
    public final ForgeConfigSpec.DoubleValue planetScale;
    public final ForgeConfigSpec.DoubleValue planetDistance;
    public final ForgeConfigSpec.DoubleValue planetOrbit;
    public final ForgeConfigSpec.DoubleValue earthSeasonalTilt;
    public final ForgeConfigSpec.DoubleValue bloodmoonSpawnCountMultiplier;
    public final ForgeConfigSpec.DoubleValue moonEarthEquatorInclination;
    public final ForgeConfigSpec.DoubleValue mercuryDiameter;
    public final ForgeConfigSpec.DoubleValue venusDiameter;
    public final ForgeConfigSpec.DoubleValue earthDiameter;
    public final ForgeConfigSpec.DoubleValue marsDiameter;
    public final ForgeConfigSpec.DoubleValue jupiterDiameter;
    public final ForgeConfigSpec.DoubleValue saturnDiameter;
    public final ForgeConfigSpec.DoubleValue uranusDiameter;
    public final ForgeConfigSpec.DoubleValue neptuneDiameter;
    public final ForgeConfigSpec.DoubleValue plutoDiameter;
    public final ForgeConfigSpec.DoubleValue mercuryOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue venusOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue earthOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue marsOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue jupiterOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue saturnOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue uranusOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue neptuneOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue plutoOrbitalPeriod;
    public final ForgeConfigSpec.DoubleValue mercurySemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue venusSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue earthSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue marsSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue jupiterSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue saturnSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue uranusSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue neptuneSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue plutoSemiMajorAxis;
    public final ForgeConfigSpec.DoubleValue mercurySynodicPeriod;
    public final ForgeConfigSpec.DoubleValue venusSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue marsSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue jupiterSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue saturnSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue uranusSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue neptuneSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue plutoSynodicPeriod;
    public final ForgeConfigSpec.DoubleValue mercuryEclipticPlane;
    public final ForgeConfigSpec.DoubleValue venusEclipticPlane;
    public final ForgeConfigSpec.DoubleValue marsEclipticPlane;
    public final ForgeConfigSpec.DoubleValue jupiterEclipticPlane;
    public final ForgeConfigSpec.DoubleValue saturnEclipticPlane;
    public final ForgeConfigSpec.DoubleValue uranusEclipticPlane;
    public final ForgeConfigSpec.DoubleValue neptuneEclipticPlane;
    public final ForgeConfigSpec.DoubleValue plutoEclipticPlane;
    public final ForgeConfigSpec.DoubleValue xFactor;
    public final ForgeConfigSpec.DoubleValue yFactor;
    public final ForgeConfigSpec.DoubleValue zFactor;
    public final ForgeConfigSpec.BooleanValue enableBlend;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        if (!Helpers.BOOTSTRAP_ENVIRONMENT) {
            ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        }
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("tfccaelum.config.common." + name);
        innerBuilder.push("general");
        this.enableRainbow = builder.apply("enableRainbow").comment("Enable rainbows").define("enableRainbow", true);
        this.enablePlanets = builder.apply("enablePlanets").comment("Enable planets").define("enablePlanets", true);
        this.enableBloodmoonSurfaceMonsters = builder.apply("enableBloodmoonSurfaceMonsters").comment("Enable monsters spawning on the surface during a blood moon event? Overwrites TFC's config for surface monsters").define("enableBloodmoonSurfaceMonsters", true);
        this.enableSunBlindness = builder.apply("enableSunBlindness").comment("Enable sun blindness? Looking at the sun for too long will make you blind for a period").define("enableSunBlindness", true);
        this.averageDaysPerMonth = builder.apply("averageDaysPerMonth").comment("Amount of days per real Earth month").defineInRange("averageDaysPerMonth", 30.436875, 0.0, Double.MAX_VALUE);
        this.moonOrbitalPeriod = builder.apply("moonOrbitalPeriod").comment("Synodic period of the moon in days").defineInRange("moonOrbitalPeriod", 29.530588, 0.0, Double.MAX_VALUE);
        this.moonScale = builder.apply("moonScale").comment("Moon scale factor").defineInRange("moonScale", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.sunScale = builder.apply("sunScale").comment("Sun scale factor").defineInRange("sunScale", 0.725, -1.7976931348623157E308, Double.MAX_VALUE);
        this.planetScale = builder.apply("planetScale").comment("Planet scale factor").defineInRange("planetScale", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.planetDistance = builder.apply("planetDistance").comment("Planet distance factor").defineInRange("planetDistance", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.planetOrbit = builder.apply("planetOrbit").comment("Planet orbit velocity factor").defineInRange("planetOrbit", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.earthSeasonalTilt = builder.apply("earthSeasonalTilt").comment("Seasonal tilt of Earth").defineInRange("earthSeasonalTilt", 23.44, -1.7976931348623157E308, Double.MAX_VALUE);
        this.bloodmoonSpawnCountMultiplier = builder.apply("bloodmoonSpawnCountMultiplier").comment("Bloodmoon spawn count multiplier").defineInRange("bloodmoonSpawnCountMultiplier", 3.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.moonEarthEquatorInclination = builder.apply("moonEarthEquatorInclination").comment("Average inclination to Earth equator for the Moon (in degrees).\nThe closer to 0 this value is, the more frequent lunar and solar eclipses will be").defineInRange("moonEarthEquatorInclination", 23.43, -1.7976931348623157E308, Double.MAX_VALUE);
        this.mercuryDiameter = builder.apply("mercuryDiameter").comment("Diameter of Mercury (km)").defineInRange("mercuryDiameter", 4879.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.venusDiameter = builder.apply("venusDiameter").comment("Diameter of Venus (km)").defineInRange("venusDiameter", 12104.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.earthDiameter = builder.apply("earthDiameter").comment("Diameter of Earth (km)").defineInRange("earthDiameter", 12742.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.marsDiameter = builder.apply("marsDiameter").comment("Diameter of Mars (km)").defineInRange("marsDiameter", 6792.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.jupiterDiameter = builder.apply("jupiterDiameter").comment("Diameter of Jupiter (km)").defineInRange("jupiterDiameter", 142984.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.saturnDiameter = builder.apply("saturnDiameter").comment("Diameter of Saturn (km)").defineInRange("saturnDiameter", 120536.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.uranusDiameter = builder.apply("uranusDiameter").comment("Diameter of Uranus (km)").defineInRange("uranusDiameter", 51118.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.neptuneDiameter = builder.apply("neptuneDiameter").comment("Diameter of Neptune (km)").defineInRange("neptuneDiameter", 49528.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.plutoDiameter = builder.apply("plutoDiameter").comment("Diameter of Pluto (km)").defineInRange("plutoDiameter", 2376.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.mercuryOrbitalPeriod = builder.apply("mercuryOrbitalPeriod").comment("Tropical orbit period for Mercury (in real Earth days)").defineInRange("mercuryOrbitalPeriod", 87.968, -1.7976931348623157E308, Double.MAX_VALUE);
        this.venusOrbitalPeriod = builder.apply("venusOrbitalPeriod").comment("Tropical orbit period for Venus (in real Earth days)").defineInRange("venusOrbitalPeriod", 224.695, -1.7976931348623157E308, Double.MAX_VALUE);
        this.earthOrbitalPeriod = builder.apply("earthOrbitalPeriod").comment("Tropical orbit period for Earth (in real Earth days)").defineInRange("earthOrbitalPeriod", 365.242, -1.7976931348623157E308, Double.MAX_VALUE);
        this.marsOrbitalPeriod = builder.apply("marsOrbitalPeriod").comment("Tropical orbit period for Mars (in real Earth days)").defineInRange("marsOrbitalPeriod", 779.94, -1.7976931348623157E308, Double.MAX_VALUE);
        this.jupiterOrbitalPeriod = builder.apply("jupiterOrbitalPeriod").comment("Tropical orbit period for Jupiter (in real Earth days)").defineInRange("jupiterOrbitalPeriod", 4330.595, -1.7976931348623157E308, Double.MAX_VALUE);
        this.saturnOrbitalPeriod = builder.apply("saturnOrbitalPeriod").comment("Tropical orbit period for Saturn (in real Earth days)").defineInRange("saturnOrbitalPeriod", 10746.94, -1.7976931348623157E308, Double.MAX_VALUE);
        this.uranusOrbitalPeriod = builder.apply("uranusOrbitalPeriod").comment("Tropical orbit period for Uranus (in real Earth days)").defineInRange("uranusOrbitalPeriod", 30588.74, -1.7976931348623157E308, Double.MAX_VALUE);
        this.neptuneOrbitalPeriod = builder.apply("neptuneOrbitalPeriod").comment("Tropical orbit period for Neptune (in real Earth days)").defineInRange("neptuneOrbitalPeriod", 59799.9, -1.7976931348623157E308, Double.MAX_VALUE);
        this.plutoOrbitalPeriod = builder.apply("plutoOrbitalPeriod").comment("Sidereal orbit period for Pluto (in real Earth days)").defineInRange("plutoOrbitalPeriod", 90560.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.mercurySemiMajorAxis = builder.apply("mercurySemiMajorAxis").comment("Semi major axis for Mercury (10^6 km)").defineInRange("mercurySemiMajorAxis", 57.909, -1.7976931348623157E308, Double.MAX_VALUE);
        this.venusSemiMajorAxis = builder.apply("venusSemiMajorAxis").comment("Semi major axis for Venus (10^6 km)").defineInRange("venusSemiMajorAxis", 108.21, -1.7976931348623157E308, Double.MAX_VALUE);
        this.earthSemiMajorAxis = builder.apply("earthSemiMajorAxis").comment("Semi major axis for Earth (10^6 km)").defineInRange("earthSemiMajorAxis", 149.598, -1.7976931348623157E308, Double.MAX_VALUE);
        this.marsSemiMajorAxis = builder.apply("marsSemiMajorAxis").comment("Semi major axis for Mars (10^6 km)").defineInRange("marsSemiMajorAxis", 227.956, -1.7976931348623157E308, Double.MAX_VALUE);
        this.jupiterSemiMajorAxis = builder.apply("jupiterSemiMajorAxis").comment("Semi major axis for Jupiter (10^6 km)").defineInRange("jupiterSemiMajorAxis", 778.479, -1.7976931348623157E308, Double.MAX_VALUE);
        this.saturnSemiMajorAxis = builder.apply("saturnSemiMajorAxis").comment("Semi major axis for Saturn (10^6 km)").defineInRange("saturnSemiMajorAxis", 1432.041, -1.7976931348623157E308, Double.MAX_VALUE);
        this.uranusSemiMajorAxis = builder.apply("uranusSemiMajorAxis").comment("Semi major axis for Uranus (10^6 km)").defineInRange("uranusSemiMajorAxis", 2867.043, -1.7976931348623157E308, Double.MAX_VALUE);
        this.neptuneSemiMajorAxis = builder.apply("neptuneSemiMajorAxis").comment("Semi major axis for Neptune (10^6 km)").defineInRange("neptuneSemiMajorAxis", 4514.953, -1.7976931348623157E308, Double.MAX_VALUE);
        this.plutoSemiMajorAxis = builder.apply("plutoSemiMajorAxis").comment("Semi major axis for Pluto (10^6 km)").defineInRange("plutoSemiMajorAxis", 5869.656, -1.7976931348623157E308, Double.MAX_VALUE);
        this.mercurySynodicPeriod = builder.apply("mercurySynodicPeriod").comment("Synodic period for Mercury (in real Earth days)").defineInRange("mercurySynodicPeriod", 115.88, -1.7976931348623157E308, Double.MAX_VALUE);
        this.venusSynodicPeriod = builder.apply("venusSynodicPeriod").comment("Synodic period for Venus (in real Earth days)").defineInRange("venusSynodicPeriod", 583.92, -1.7976931348623157E308, Double.MAX_VALUE);
        this.marsSynodicPeriod = builder.apply("marsSynodicPeriod").comment("Synodic period for Mars (in real Earth days)").defineInRange("marsSynodicPeriod", 779.94, -1.7976931348623157E308, Double.MAX_VALUE);
        this.jupiterSynodicPeriod = builder.apply("jupiterSynodicPeriod").comment("Synodic period for Jupiter (in real Earth days)").defineInRange("jupiterSynodicPeriod", 4330.595, -1.7976931348623157E308, Double.MAX_VALUE);
        this.saturnSynodicPeriod = builder.apply("saturnSynodicPeriod").comment("Synodic period for Saturn (in real Earth days)").defineInRange("saturnSynodicPeriod", 378.09, -1.7976931348623157E308, Double.MAX_VALUE);
        this.uranusSynodicPeriod = builder.apply("uranusSynodicPeriod").comment("Synodic period for Uranus (in real Earth days)").defineInRange("uranusSynodicPeriod", 369.66, -1.7976931348623157E308, Double.MAX_VALUE);
        this.neptuneSynodicPeriod = builder.apply("neptuneSynodicPeriod").comment("Synodic period for Neptune (in real Earth days)").defineInRange("neptuneSynodicPeriod", 367.49, -1.7976931348623157E308, Double.MAX_VALUE);
        this.plutoSynodicPeriod = builder.apply("plutoSynodicPeriod").comment("Synodic period for Pluto (in real Earth days)").defineInRange("plutoSynodicPeriod", 366.73, -1.7976931348623157E308, Double.MAX_VALUE);
        this.mercuryEclipticPlane = builder.apply("mercuryEclipticPlane").comment("Ecliptic plane for Mercury (in degrees)").defineInRange("mercuryEclipticPlane", 7.004, -1.7976931348623157E308, Double.MAX_VALUE);
        this.venusEclipticPlane = builder.apply("venusEclipticPlane").comment("Ecliptic plane for Venus (in degrees)").defineInRange("venusEclipticPlane", 3.395, -1.7976931348623157E308, Double.MAX_VALUE);
        this.marsEclipticPlane = builder.apply("marsEclipticPlane").comment("Ecliptic plane for Mars (in degrees)").defineInRange("marsEclipticPlane", 1.848, -1.7976931348623157E308, Double.MAX_VALUE);
        this.jupiterEclipticPlane = builder.apply("jupiterEclipticPlane").comment("Ecliptic plane for Jupiter (in degrees)").defineInRange("jupiterEclipticPlane", 1.304, -1.7976931348623157E308, Double.MAX_VALUE);
        this.saturnEclipticPlane = builder.apply("saturnEclipticPlane").comment("Ecliptic plane for Saturn (in degrees)").defineInRange("saturnEclipticPlane", 2.486, -1.7976931348623157E308, Double.MAX_VALUE);
        this.uranusEclipticPlane = builder.apply("uranusEclipticPlane").comment("Ecliptic plane for Uranus (in degrees)").defineInRange("uranusEclipticPlane", 0.77, -1.7976931348623157E308, Double.MAX_VALUE);
        this.neptuneEclipticPlane = builder.apply("neptuneEclipticPlane").comment("Ecliptic plane for Neptune (in degrees)").defineInRange("neptuneEclipticPlane", 1.77, -1.7976931348623157E308, Double.MAX_VALUE);
        this.plutoEclipticPlane = builder.apply("plutoEclipticPlane").comment("Ecliptic plane for Pluto (in degrees)").defineInRange("plutoEclipticPlane", 17.16, -1.7976931348623157E308, Double.MAX_VALUE);
        this.enableAurora = builder.apply("enableAurora").comment("Enable auroras").define("enableAurora", true);
        this.maxBands = builder.apply("maxBands").comment("The maximum aurora bands that will be rendered").defineInRange("maxBands", 3, 0, 3);
        innerBuilder.pop().push("debug");
        this.enableDebug = builder.apply("enableDebug").comment("When enabled, prints debug values to console.").define("enableDebug", false);
        this.xFactor = builder.apply("xFactor").comment("x value factor.").defineInRange("xFactor", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.yFactor = builder.apply("yFactor").comment("y value factor.").defineInRange("yFactor", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.zFactor = builder.apply("zFactor").comment("z value factor.").defineInRange("zFactor", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.enableBlend = builder.apply("enableBlend").comment("Toggle blend.").define("enableBlend", false);
    }
}

