/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.mixin;

import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import de.mennomax.astikorcarts.util.CartWheel;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

@Mixin(value={AbstractDrawnEntity.class})
public abstract class AbstractDrawnEntityMixin
extends Entity {
    @Shadow
    protected List<CartWheel> wheels;
    @Shadow
    protected double spacing = 1.7;
    @Shadow
    public Entity pulling;
    @Shadow
    protected AbstractDrawnEntity drawn;

    public AbstractDrawnEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Overwrite(remap=false)
    public void pulledTick() {
        if (this.pulling == null) {
            return;
        }
        Vec3 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        if (this.pulling.m_20096_()) {
            targetVec = new Vec3(targetVec.f_82479_, 0.0, targetVec.f_82481_);
        }
        double targetVecLength = targetVec.m_82553_();
        double r = 0.2;
        double relativeSpacing = Math.max(this.spacing + 0.5 * (double)this.pulling.m_20205_(), 1.0);
        double diff = targetVecLength - relativeSpacing;
        Vec3 move = Math.abs(diff) < 0.2 ? this.m_20184_() : this.m_20184_().m_82549_(targetVec.m_82546_(targetVec.m_82541_().m_82490_(relativeSpacing + 0.2 * Math.signum(diff))));
        this.m_20096_();
        double startX = this.m_20185_();
        double startY = this.m_20186_();
        double startZ = this.m_20189_();
        this.m_6478_(MoverType.SELF, move);
        if (!this.m_6084_()) {
            return;
        }
        this.addStats(this.m_20185_() - startX, this.m_20186_() - startY, this.m_20189_() - startZ);
        if (this.m_9236_().f_46443_) {
            for (CartWheel wheel : this.wheels) {
                wheel.tick();
            }
        } else {
            targetVec = this.getRelativeTargetVec(1.0f);
            if (targetVec.m_82553_() > relativeSpacing + 1.0 + (Double)TFCAstikorCartsConfig.COMMON.pullingDistanceModifier.get()) {
                this.setPulling(null);
            }
        }
        this.updatePassengers();
        if (this.drawn != null) {
            this.drawn.pulledTick();
        }
    }

    @Shadow
    public Vec3 getRelativeTargetVec(float delta) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    @Shadow
    public void handleRotation(Vec3 target) {
    }

    @Shadow
    private void addStats(double x, double y, double z) {
    }

    @Shadow
    public void setPulling(Entity entityIn) {
    }

    @Shadow
    public void updatePassengers() {
    }
}

