/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.config;

import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.config.ConfigBuilder;
import net.minecraftforge.common.ForgeConfigSpec;
import tfcastikorcarts.common.container.ContainerList;

public class TFCACCommonConfig {
    public final ForgeConfigSpec.DoubleValue maxAnimalSize;
    public final ForgeConfigSpec.IntValue maxPassengerCount;
    public final ForgeConfigSpec.EnumValue<Size> maxItemSize;
    public final ForgeConfigSpec.BooleanValue canPushIntoPlayers;
    public final ForgeConfigSpec.BooleanValue canCarryWaterEntities;
    public final ForgeConfigSpec.DoubleValue exhaustedThreshold;
    public final ForgeConfigSpec.DoubleValue overburdenedThreshold;
    public final ForgeConfigSpec.DoubleValue pinnedThreshold;
    public final ForgeConfigSpec.DoubleValue pullingDistanceModifier;
    public final ForgeConfigSpec.EnumValue<ContainerList> supplyCartInventorySize;
    public final ForgeConfigSpec.BooleanValue toggleFoodSpeed;

    TFCACCommonConfig(ConfigBuilder builder) {
        builder.push("general");
        this.maxAnimalSize = builder.comment(new String[]{"Max animal size that the animal cart can carry."}).define("maxAnimalSize", 3.0, 0.0, Double.MAX_VALUE);
        this.maxPassengerCount = builder.comment(new String[]{"Amount of animals the animal cart can carry."}).define("maxPassengerCount", 2, 0, Integer.MAX_VALUE);
        this.maxItemSize = builder.comment(new String[]{"The largest (inclusive) size of an item that is allowed in a supply cart."}).define("maxItemSize", (Enum)Size.VERY_LARGE);
        this.canPushIntoPlayers = builder.comment(new String[]{"Can the animal cart pick up players by pushing it into them?"}).define("canPushIntoPlayers", true);
        this.canCarryWaterEntities = builder.comment(new String[]{"Can the animal cart pick up water animals?"}).define("canCarryWaterEntities", true);
        this.pullingDistanceModifier = builder.comment(new String[]{"Pulling distance modifier for carts. Higher => farther/greater break tolerance."}).define("pullingDistanceModifier", 2.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.toggleFoodSpeed = builder.comment(new String[]{"Should the player's average nutrient level and thirst affect the pulling speed of carts?"}).define("toggleFoodSpeed", true);
        builder.comment(new String[]{"A very heavy huge item has a combined weight/size factor of 35, thus if a threshold is 140, then the player can carry 4 items."});
        this.exhaustedThreshold = builder.comment(new String[]{"Threshold at which the player carrying a cart will get exhausted. Higher => can carry more."}).define("exhaustedThreshold", 140.0, 0.0, Double.MAX_VALUE);
        this.overburdenedThreshold = builder.comment(new String[]{"Threshold at which the player carrying a cart will get overburdened. Higher => can carry more."}).define("overburdenedThreshold", 280.0, 0.0, Double.MAX_VALUE);
        this.pinnedThreshold = builder.comment(new String[]{"Threshold at which the player carrying a cart will get pinned. Higher => can carry more."}).define("pinnedThreshold", 420.0, 0.0, Double.MAX_VALUE);
        this.supplyCartInventorySize = builder.comment(new String[]{"How big the supply cart inventory should be."}).define("supplyCartInventorySize", (Enum)ContainerList.SIZE_6);
        builder.pop();
    }
}

