/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.google.common.collect.ImmutableList;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.PlowContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import de.mennomax.astikorcarts.util.ProxyItemUseContext;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import tfcastikorcarts.common.AstikorTags;
import tfcastikorcarts.config.TFCAstikorCartsConfig;
import tfcastikorcarts.util.AstikorHelpers;

public class TFCPlowEntity
extends AbstractDrawnInventoryEntity
implements ISlotCallback {
    public final Supplier<? extends Item> drop;
    public static final int SLOT_COUNT = 3;
    public static final double BLADEOFFSET = 1.7;
    public static final EntityDataAccessor<Boolean> PLOWING = SynchedEntityData.m_135353_(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final ImmutableList<EntityDataAccessor<ItemStack>> TOOLS = ImmutableList.of((Object)SynchedEntityData.m_135353_(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_));

    public static boolean isValid(ItemStack stack) {
        return ItemSizeManager.get((ItemStack)stack).getSize(stack).isEqualOrSmallerThan((Size)TFCAstikorCartsConfig.COMMON.maxItemSize.get());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return TFCPlowEntity.isValid(stack);
    }

    public TFCPlowEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn, Supplier<? extends Item> drop) {
        super(entityTypeIn, worldIn);
        this.spacing = 1.3;
        this.drop = drop;
    }

    public AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.get().plow;
    }

    public ItemStackHandler initInventory() {
        return new CartItemStackHandler<TFCPlowEntity>(3, this){

            public void onLoad() {
                for (int i = 0; i < TOOLS.size(); ++i) {
                    ((TFCPlowEntity)this.cart).m_20088_().m_135381_((EntityDataAccessor)TOOLS.get(i), (Object)this.getStackInSlot(i));
                }
            }

            public void onContentsChanged(int slot) {
                ((TFCPlowEntity)this.cart).updateSlot(slot);
            }
        };
    }

    public boolean getPlowing() {
        return (Boolean)this.f_19804_.m_135370_(PLOWING);
    }

    public void pulledTick() {
        Player pl;
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        Player player = null;
        Entity entity = this.getPulling();
        if (entity instanceof Player) {
            Player pl2;
            player = pl2 = (Player)entity;
        } else {
            entity = this.getPulling().m_6688_();
            if (entity instanceof Player) {
                player = pl = (Player)entity;
            }
        }
        if (player != null && !this.m_9236_().f_46443_ && ((Boolean)this.f_19804_.m_135370_(PLOWING)).booleanValue() && (this.f_19854_ != this.m_20185_() || this.f_19856_ != this.m_20189_())) {
            this.plow(player);
        }
        if (player != null && (pl = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData foodData = (TFCFoodData)pl;
            double healthFactor = (Boolean)TFCAstikorCartsConfig.COMMON.toggleFoodSpeed.get() != false ? Mth.m_144914_((double)foodData.getNutrition().getAverageNutrition(), (double)0.0, (double)1.0, (double)0.75, (double)1.0) * Mth.m_144914_((double)foodData.getThirst(), (double)0.0, (double)100.0, (double)0.5, (double)1.0) : 1.0;
            double speedFactor = Mth.m_14008_((double)(healthFactor * Mth.m_144914_((double)this.countOverburdened(), (double)0.0, (double)35.0, (double)0.5, (double)1.0)), (double)0.25, (double)1.0);
            player.m_20256_(player.m_20184_().m_82542_(speedFactor, 1.0, speedFactor));
        }
    }

    public float countOverburdened() {
        float count = 0.0f;
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            IItemSize item = ItemSizeManager.get((ItemStack)stack);
            float weightFactor = AstikorHelpers.getWeightFactor(item.getWeight(stack), item.getSize(stack));
            count += weightFactor;
        }
        return count;
    }

    public void plow(Player player) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof TieredItem)) continue;
            float offset = 38.0f - (float)i * 38.0f;
            double blockPosX = this.m_20185_() + (double)Mth.m_14031_((float)((float)Math.toRadians(this.m_146908_() - offset))) * 1.7;
            double blockPosZ = this.m_20189_() - (double)Mth.m_14089_((float)((float)Math.toRadians(this.m_146908_() - offset))) * 1.7;
            Vec3 vec3 = new Vec3(blockPosX, this.m_20186_() - 0.5, blockPosZ);
            BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
            Level level = this.m_9236_();
            BlockPos upPos = blockPos.m_7494_();
            BlockPos upUpPos = upPos.m_7494_();
            BlockState blockStateAt = level.m_8055_(blockPos);
            BlockState blockStateAtUp = level.m_8055_(upPos);
            BlockState blockStateAtUpUp = level.m_8055_(upUpPos);
            boolean damageable = stack.m_41763_();
            int count = stack.m_41613_();
            stack.m_41720_().m_6225_((UseOnContext)new ProxyItemUseContext(player, stack, new BlockHitResult(Vec3.f_82478_, Direction.UP, blockPos, false)));
            if (Helpers.isItem((Item)stack.m_41720_(), (TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Helpers.identifier((String)"scythes")))) {
                if (Helpers.isBlock((BlockState)blockStateAt, AstikorTags.Blocks.MINEABLE_PLOW_SCYTHE)) {
                    level.m_46961_(blockPos, true);
                }
                if (Helpers.isBlock((BlockState)blockStateAtUp, AstikorTags.Blocks.MINEABLE_PLOW_SCYTHE)) {
                    level.m_46961_(upPos, true);
                }
                if (Helpers.isBlock((BlockState)blockStateAtUpUp, AstikorTags.Blocks.MINEABLE_PLOW_SCYTHE)) {
                    level.m_46961_(upUpPos, true);
                }
            } else if (Helpers.isItem((Item)stack.m_41720_(), (TagKey)TFCTags.Items.KNIVES)) {
                if (Helpers.isBlock((BlockState)blockStateAt, AstikorTags.Blocks.MINEABLE_PLOW_KNIFE)) {
                    level.m_46961_(blockPos, true);
                }
                if (Helpers.isBlock((BlockState)blockStateAtUp, AstikorTags.Blocks.MINEABLE_PLOW_KNIFE)) {
                    level.m_46961_(upPos, true);
                }
                if (Helpers.isBlock((BlockState)blockStateAtUpUp, AstikorTags.Blocks.MINEABLE_PLOW_KNIFE)) {
                    level.m_46961_(upUpPos, true);
                }
            } else if (Helpers.isItem((Item)stack.m_41720_(), (TagKey)TFCTags.Items.HOES)) {
                if (Helpers.isBlock((BlockState)blockStateAt, AstikorTags.Blocks.MINEABLE_PLOW_HOE)) {
                    level.m_46961_(blockPos, true);
                }
                if (Helpers.isBlock((BlockState)blockStateAtUp, AstikorTags.Blocks.MINEABLE_PLOW_HOE)) {
                    level.m_46961_(upPos, true);
                }
                if (Helpers.isBlock((BlockState)blockStateAtUpUp, AstikorTags.Blocks.MINEABLE_PLOW_HOE)) {
                    level.m_46961_(upUpPos, true);
                }
            }
            if (!damageable || stack.m_41613_() >= count) continue;
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            this.updateSlot(i);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            this.openContainer(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(PLOWING, (Object)((Boolean)this.f_19804_.m_135370_(PLOWING) == false ? 1 : 0));
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public void updateSlot(int slot) {
        if (!this.m_9236_().f_46443_) {
            if (this.inventory.getStackInSlot(slot).m_41619_()) {
                this.f_19804_.m_135381_((EntityDataAccessor)TOOLS.get(slot), (Object)ItemStack.f_41583_);
            } else {
                this.f_19804_.m_135381_((EntityDataAccessor)TOOLS.get(slot), (Object)this.inventory.getStackInSlot(slot));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.f_19804_.m_135370_((EntityDataAccessor)TOOLS.get(i));
    }

    public Item getCartItem() {
        return this.drop.get();
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLOWING, (Object)false);
        for (EntityDataAccessor param : TOOLS) {
            this.f_19804_.m_135372_(param, (Object)ItemStack.f_41583_);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(PLOWING, (Object)compound.m_128471_("Plowing"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Plowing", ((Boolean)this.f_19804_.m_135370_(PLOWING)).booleanValue());
    }

    public void openContainer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> new PlowContainer(windowId, playerInventory, (AbstractDrawnInventoryEntity)this), this.m_5446_()), buf -> buf.writeInt(this.m_19879_()));
        }
    }
}

