/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import tfcastikorcarts.common.entities.AstikorEntities;
import tfcastikorcarts.common.entities.carts.TFCPostilionEntity;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

public class TFCAnimalCartEntity
extends AbstractDrawnEntity
implements ISlotCallback {
    public final RegistryWood wood;
    public final Supplier<? extends Item> drop;
    public TFCPostilionEntity postilionEntity = null;

    public static boolean isValid(ItemStack stack) {
        return ItemSizeManager.get((ItemStack)stack).getSize(stack).isEqualOrSmallerThan((Size)TFCAstikorCartsConfig.COMMON.maxItemSize.get());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return TFCAnimalCartEntity.isValid(stack);
    }

    public TFCAnimalCartEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn, Supplier<? extends Item> drop, RegistryWood wood) {
        super(entityTypeIn, worldIn);
        this.drop = drop;
        this.wood = wood;
    }

    public AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.get().animalCart;
    }

    public void pulledTick() {
        Player pl;
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        Player player = null;
        Entity entity = this.getPulling();
        if (entity instanceof Player) {
            Player pl2;
            player = pl2 = (Player)entity;
        } else {
            entity = this.getPulling().m_6688_();
            if (entity instanceof Player) {
                player = pl = (Player)entity;
            }
        }
        if (player != null && (pl = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData foodData = (TFCFoodData)pl;
            double animalWeight = this.countOverburdened();
            double healthFactor = (Boolean)TFCAstikorCartsConfig.COMMON.toggleFoodSpeed.get() != false ? Mth.m_144914_((double)foodData.getNutrition().getAverageNutrition(), (double)0.0, (double)1.0, (double)0.75, (double)1.0) * Mth.m_144914_((double)foodData.getThirst(), (double)0.0, (double)100.0, (double)0.5, (double)1.0) : 1.0;
            double speedFactor = Mth.m_14008_((double)(healthFactor / animalWeight), (double)0.0, (double)1.0);
            player.m_20256_(player.m_20184_().m_82542_(speedFactor, 1.0, speedFactor));
            if (animalWeight > 30.0) {
                player.m_7292_(new MobEffectInstance((MobEffect)TFCEffects.PINNED.get(), 25, 0, false, false));
            } else if (animalWeight > 20.0) {
                player.m_7292_(Helpers.getOverburdened((boolean)false));
            } else if (animalWeight > 10.0) {
                player.m_7292_(Helpers.getExhausted((boolean)false));
            }
        }
    }

    public float countOverburdened() {
        float count = 1.0f;
        if (this.m_20197_().size() > 0) {
            for (int i = 0; i < this.m_20197_().size(); ++i) {
                count = (float)((double)count + ((Entity)this.m_20197_().get(i)).m_20191_().m_82309_());
            }
        }
        return count;
    }

    public TFCPostilionEntity getPostilionEntity(RegistryWood wood) {
        if (this.postilionEntity != null) {
            return this.postilionEntity;
        }
        if (wood != null) {
            return (TFCPostilionEntity)((EntityType)AstikorEntities.POSTILION_TFC.get(wood).get()).m_20615_(this.m_9236_());
        }
        return null;
    }

    public void m_8119_() {
        TFCPostilionEntity postilion;
        super.m_8119_();
        LivingEntity coachman = this.m_6688_();
        Entity pulling = this.getPulling();
        if (pulling != null && coachman != null && pulling.m_6688_() == null && (postilion = this.getPostilionEntity(this.wood)) != null) {
            postilion.m_7678_(pulling.m_20185_(), pulling.m_20186_(), pulling.m_20189_(), coachman.m_146908_(), coachman.m_146909_());
            if (postilion.m_20329_(pulling)) {
                this.m_9236_().m_7967_((Entity)postilion);
            } else {
                postilion.m_146870_();
            }
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            if (!this.m_9236_().f_46443_) {
                for (Entity entity : this.m_20197_()) {
                    if (entity instanceof Player) continue;
                    entity.m_8127_();
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult bannerResult = this.useBanner(player, hand);
        if (bannerResult.m_19077_()) {
            return bannerResult;
        }
        if (this.getPulling() != player) {
            if (!this.m_7310_((Entity)player)) {
                return InteractionResult.PASS;
            }
            if (!this.m_9236_().f_46443_) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7334_(Entity entityIn) {
        if (!entityIn.m_20363_((Entity)this)) {
            double animalSize = entityIn.m_20191_().m_82309_();
            double maxAnimalSize = (Double)TFCAstikorCartsConfig.COMMON.maxAnimalSize.get();
            if (!this.m_9236_().f_46443_ && this.getPulling() != entityIn && this.m_6688_() == null && animalSize <= maxAnimalSize && !entityIn.m_20159_() && (entityIn.m_20205_() < this.m_20205_() || animalSize <= maxAnimalSize) && entityIn instanceof LivingEntity && TFCAnimalCartEntity.canCarryWaterEntities(entityIn) && TFCAnimalCartEntity.canPushIntoPlayers(entityIn)) {
                entityIn.m_20329_((Entity)this);
            } else {
                super.m_7334_(entityIn);
            }
        }
    }

    public static boolean canPushIntoPlayers(Entity entityIn) {
        if (entityIn instanceof Player) {
            return (Boolean)TFCAstikorCartsConfig.COMMON.canPushIntoPlayers.get();
        }
        return true;
    }

    public static boolean canCarryWaterEntities(Entity entityIn) {
        if (entityIn instanceof WaterAnimal) {
            return (Boolean)TFCAstikorCartsConfig.COMMON.canCarryWaterEntities.get();
        }
        return true;
    }

    public boolean m_7310_(Entity passenger) {
        double maxAnimalSize;
        double animalSize = passenger.m_20191_().m_82309_();
        return animalSize <= (maxAnimalSize = ((Double)TFCAstikorCartsConfig.COMMON.maxAnimalSize.get()).doubleValue()) && this.m_20197_().size() <= (Integer)TFCAstikorCartsConfig.COMMON.maxPassengerCount.get();
    }

    public double m_6048_() {
        return 0.6875;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction pCallback) {
        if (this.m_20363_(passenger)) {
            double f = -0.1;
            if (this.m_20197_().size() > 1) {
                double d = f = this.m_20197_().indexOf(passenger) == 0 ? 0.2 : -0.6;
                if (passenger instanceof Animal) {
                    f += 0.2;
                }
            }
            Vec3 forward = this.m_20154_();
            Vec3 origin = new Vec3(0.0, this.m_6048_(), 0.0625);
            Vec3 pos = origin.m_82549_(forward.m_82490_(f + (double)Mth.m_14031_((float)((float)Math.toRadians(this.m_146909_()))) * 0.7));
            passenger.m_6034_(this.m_20185_() + pos.f_82479_, this.m_20186_() + pos.f_82480_ + passenger.m_6049_(), this.m_20189_() + pos.f_82481_);
            passenger.m_5618_(this.m_146908_());
            float f2 = Mth.m_14177_((float)(passenger.m_146908_() - this.m_146908_()));
            float f1 = Mth.m_14036_((float)f2, (float)-105.0f, (float)105.0f);
            passenger.f_19859_ += f1 - f2;
            passenger.m_146922_(passenger.m_146908_() + (f1 - f2));
            passenger.m_5616_(passenger.m_146908_());
            if (passenger instanceof Animal && this.m_20197_().size() > 1) {
                int j = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                passenger.m_5618_(((Animal)passenger).f_20883_ + (float)j);
                passenger.m_5616_(passenger.m_6080_() + (float)j);
            }
        }
    }

    public Item getCartItem() {
        return this.drop.get();
    }
}

