/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.DecorationBlockRegistryObject;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tfcastikorcarts.common.items.AstikorItems;

public class AstikorItemGroup {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tfcastikorcarts");
    public static final CreativeTabHolder CARTS = AstikorItemGroup.register("carts", () -> new ItemStack((ItemLike)AstikorItems.WHEEL_TFC.get(Wood.OAK).get()), AstikorItemGroup::fillCartsTab);

    public static Stream<CreativeModeTab.DisplayItemsGenerator> generators() {
        return Stream.of(CARTS).map(holder -> holder.generator);
    }

    public static void onBuildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTab tab = event.getTab();
        FoodCapability.setStackNonDecaying((ItemStack)tab.m_40787_());
        for (ItemStack item : tab.m_260957_()) {
            FoodCapability.setStackNonDecaying((ItemStack)item);
        }
    }

    public static void fillCartsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Wood wood : Wood.values()) {
            AstikorItemGroup.accept(out, AstikorItems.WHEEL_TFC.get(wood));
            AstikorItemGroup.accept(out, AstikorItems.SUPPLY_CART_TFC.get(wood));
            AstikorItemGroup.accept(out, AstikorItems.PLOW_TFC.get(wood));
            AstikorItemGroup.accept(out, AstikorItems.ANIMAL_CART_TFC.get(wood));
            AstikorItemGroup.accept(out, AstikorItems.POSTILION_TFC.get(wood));
        }
    }

    public static CreativeTabHolder register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        RegistryObject reg = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)("tfcastikorcarts.creative_tab." + name))).m_257501_(displayItems).m_257652_());
        return new CreativeTabHolder((RegistryObject<CreativeModeTab>)reg, displayItems);
    }

    public static <T extends ItemLike, R extends Supplier<T>, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1) && map.get(key1).containsKey(key2)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key1).get(key2)).get());
        }
    }

    public static <T extends ItemLike, R extends Supplier<T>, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key)).get());
        }
    }

    public static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == Items.f_41852_) {
            SelfTests.reportExternalError();
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }

    public static void accept(CreativeModeTab.Output out, DecorationBlockRegistryObject decoration) {
        out.m_246326_((ItemLike)decoration.stair().get());
        out.m_246326_((ItemLike)decoration.slab().get());
        out.m_246326_((ItemLike)decoration.wall().get());
    }

    public static <T> void consumeOurs(IForgeRegistry<T> registry, Consumer<T> consumer) {
        for (Object value : registry) {
            if (!Objects.requireNonNull(registry.getKey(value)).m_135827_().equals("tfcastikorcarts")) continue;
            consumer.accept(value);
        }
    }

    public record CreativeTabHolder(RegistryObject<CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

