/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.capability.v2.data;

import fuzs.puzzleslib.api.capability.v2.CapabilityController;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityKey;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ForgeCapabilityKey<C extends CapabilityComponent>
implements CapabilityKey<C> {
    private final ResourceLocation id;
    private final Class<C> componentClass;
    private final CapabilityTokenFactory<C> factory;
    private Capability<C> capability;

    public ForgeCapabilityKey(ResourceLocation id, Class<C> componentClass, CapabilityTokenFactory<C> factory) {
        this.id = id;
        this.componentClass = componentClass;
        this.factory = factory;
        CapabilityController.submit(this);
    }

    public void createCapability(CapabilityToken<C> token) {
        this.capability = this.factory.apply(token);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Override
    @Nullable
    public <V> C get(@Nullable V provider) {
        ICapabilityProvider capabilityProvider;
        LazyOptional optional;
        this.validateCapability();
        if (provider instanceof ICapabilityProvider && (optional = (capabilityProvider = (ICapabilityProvider)provider).getCapability(this.capability)).isPresent()) {
            return (C)((CapabilityComponent)optional.orElseThrow(IllegalStateException::new));
        }
        return null;
    }

    @Override
    public <V> Optional<C> maybeGet(@Nullable V provider) {
        this.validateCapability();
        if (provider instanceof ICapabilityProvider) {
            ICapabilityProvider capabilityProvider = (ICapabilityProvider)provider;
            return capabilityProvider.getCapability(this.capability).resolve();
        }
        return Optional.empty();
    }

    void validateCapability() {
        Objects.requireNonNull(this.capability, "No valid capability implementation registered for %s".formatted(this.id));
    }

    public static interface CapabilityTokenFactory<C extends CapabilityComponent> {
        public Capability<C> apply(CapabilityToken<C> var1);
    }

    public static interface ForgeCapabilityKeyFactory<C extends CapabilityComponent, T extends CapabilityKey<C>> {
        public T apply(ResourceLocation var1, Class<C> var2, CapabilityTokenFactory<C> var3);
    }
}

