/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.shapes.v1;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ShapesHelper {
    public static Map<Direction, VoxelShape> rotate(VoxelShape voxelShape) {
        EnumMap shapes = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            shapes.put(direction, ShapesHelper.rotate(direction, voxelShape));
        }
        return Collections.unmodifiableMap(shapes);
    }

    public static VoxelShape rotate(Direction direction, VoxelShape voxelShape) {
        return ShapesHelper.rotate(direction, voxelShape, new Vector3d(0.5, 0.5, 0.5));
    }

    public static VoxelShape rotate(Direction direction, VoxelShape voxelShape, Vector3d originOffset) {
        VoxelShape[] value = new VoxelShape[]{Shapes.m_83040_()};
        Quaternionf rotation = direction.m_253075_();
        voxelShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vector3d start = rotation.transform(new Vector3d(minX, minY, minZ).sub((Vector3dc)originOffset)).add((Vector3dc)originOffset);
            Vector3d end = rotation.transform(new Vector3d(maxX, maxY, maxZ).sub((Vector3dc)originOffset)).add((Vector3dc)originOffset);
            value[0] = Shapes.m_83110_((VoxelShape)value[0], (VoxelShape)ShapesHelper.box(start.x, start.y, start.z, end.x, end.y, end.z));
        });
        return value[0];
    }

    public static VoxelShape box(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return Shapes.m_83048_((double)Math.min(startX, endX), (double)Math.min(startY, endY), (double)Math.min(startZ, endZ), (double)Math.max(startX, endX), (double)Math.max(startY, endY), (double)Math.max(startZ, endZ));
    }
}

