/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v3;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import fuzs.puzzleslib.api.client.data.v3.models.ModelLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.mixin.client.accessor.BlockModelGeneratorsAccessor;
import fuzs.puzzleslib.mixin.client.accessor.ModelTemplatesAccessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class AbstractModelProvider
implements DataProvider {
    public static final ModelTemplate SPAWN_EGG = ModelTemplatesAccessor.puzzleslib$callCreateItem("template_spawn_egg", new TextureSlot[0]);
    private final String modId;
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    private final Set<Object> skipValidation = Sets.newHashSet();

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, PackOutput packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.modelPathProvider = packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
    }

    public void addBlockModels(BlockModelGenerators builder) {
    }

    public void addItemModels(ItemModelGenerators builder) {
    }

    protected boolean skipValidation() {
        return false;
    }

    protected void skipBlock(Block block) {
        this.skipValidation.add(block);
    }

    protected void skipItem(Item item) {
        this.skipValidation.add(item);
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        HashMap generators = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = generator -> {
            Block block = generator.m_6968_();
            BlockStateGenerator blockstategenerator = generators.put(block, generator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate block state definition for " + block);
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier> modelOutput = (resourceLocation, supplier) -> {
            if (models.put(resourceLocation, supplier) != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        BlockModelGenerators blockModelGenerators = new BlockModelGenerators(blockStateOutput, modelOutput, skippedAutoModels::add);
        ((BlockModelGeneratorsAccessor)blockModelGenerators).puzzleslib$setNonOrientableTrapdoor(new ArrayList<Block>(((BlockModelGeneratorsAccessor)blockModelGenerators).puzzleslib$getNonOrientableTrapdoor()));
        ((BlockModelGeneratorsAccessor)blockModelGenerators).puzzleslib$setTexturedModels(new HashMap<Block, TexturedModel>(((BlockModelGeneratorsAccessor)blockModelGenerators).puzzleslib$getTexturedModels()));
        this.addBlockModels(blockModelGenerators);
        this.addItemModels(new ItemModelGenerators(modelOutput));
        List<Object> missingBlocks = !this.skipValidation() ? BuiltInRegistries.f_256975_.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId) && !generators.containsKey(entry.getValue())).map(Map.Entry::getValue).filter(Predicate.not(this.skipValidation::contains)).toList() : Collections.emptyList();
        if (!missingBlocks.isEmpty()) {
            throw new IllegalStateException("Missing block state definitions for " + missingBlocks);
        }
        BuiltInRegistries.f_256975_.m_6579_().forEach(entry -> {
            Item item = (Item)Item.f_41373_.get(entry.getValue());
            if (item != null) {
                if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId) || skippedAutoModels.contains(item)) {
                    return;
                }
                ResourceLocation resourcelocation = ModelLocationUtils.m_125571_((Item)item);
                if (!models.containsKey(resourcelocation)) {
                    models.put(resourcelocation, new DelegatedModel(ModelLocationUtils.m_125576_((Block)((Block)entry.getValue()))));
                }
            }
        });
        List<Object> missingItems = !this.skipValidation() ? BuiltInRegistries.f_257033_.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId) && !models.containsKey(ModelLocationHelper.getItemModel(((ResourceKey)entry.getKey()).m_135782_()))).map(Map.Entry::getValue).filter(Predicate.not(this.skipValidation::contains)).toList() : Collections.emptyList();
        if (!missingItems.isEmpty()) {
            throw new IllegalStateException("Missing item models for " + missingItems);
        }
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = AbstractModelProvider.saveCollection(output, generators, block -> this.blockStatePathProvider.m_245731_(block.m_204297_().m_205785_().m_135782_()));
        completableFutureArray[1] = AbstractModelProvider.saveCollection(output, models, arg_0 -> ((PackOutput.PathProvider)this.modelPathProvider).m_245731_(arg_0));
        return CompletableFuture.allOf(completableFutureArray);
    }

    private static <T> CompletableFuture<?> saveCollection(CachedOutput output, Map<T, ? extends Supplier<JsonElement>> map, Function<T, Path> pathExtractor) {
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            Path path = (Path)pathExtractor.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return DataProvider.m_253162_((CachedOutput)output, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public final String m_6055_() {
        return "Model Definitions";
    }
}

