/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.dyed.DyeBlockItem;
import de.geheimagentnr1.manyideas_core.elements.recipes.ModRecipeSerializersRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorIngredient;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorStackList;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorTagList;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.DyedRecipe;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DyedRecipeSerializer
implements RecipeSerializer<DyedRecipe> {
    @NotNull
    public DyedRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        int recipeHeight;
        int recipeWidth;
        boolean shaped = GsonHelper.m_13912_((JsonObject)json, (String)"shaped");
        NonNullList ingredients = NonNullList.m_122779_();
        if (shaped) {
            String[][] pattern = DyedRecipeSerializer.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            recipeWidth = 3;
            recipeHeight = 3;
            this.deserializeShapedIngredients((NonNullList<Ingredient>)ingredients, pattern, GsonHelper.m_13930_((JsonObject)json, (String)"keys"));
        } else {
            this.deserializeNonShapedIngredients((NonNullList<Ingredient>)ingredients, GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            recipeWidth = ingredients.size();
            recipeHeight = 1;
        }
        ItemStack result = this.deserializeResult(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        return new DyedRecipe(recipeId, ModRecipeSerializersRegisterFactory.DYED, shaped, (NonNullList<Ingredient>)ingredients, result, recipeWidth, recipeHeight);
    }

    @NotNull
    private static String[][] patternFromJson(@NotNull JsonArray patternArray) {
        String[][] pattern = new String[3][3];
        if (patternArray.size() != 3) {
            throw new JsonSyntaxException("Invalid pattern: pattern has not 3 rows");
        }
        for (int i = 0; i < 3; ++i) {
            JsonArray rowArray = patternArray.get(i).getAsJsonArray();
            if (rowArray.size() != 3) {
                throw new JsonSyntaxException("Invalid pattern: row " + i + " has not 3 column");
            }
            for (int j = 0; j < 3; ++j) {
                pattern[i][j] = rowArray.get(j).getAsString();
            }
        }
        return pattern;
    }

    private void deserializeShapedIngredients(@NotNull NonNullList<Ingredient> ingredients, @NotNull String[][] pattern, @NotNull JsonObject keysJson) {
        Map<String, Ingredient> keyMapping = this.deserializeKeys(keysJson);
        HashSet keys = Sets.newHashSet(keyMapping.keySet());
        keys.remove(" ");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Ingredient ingredient = keyMapping.get(pattern[i][j]);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + pattern[i][j] + "' but it's not defined in the key");
                }
                keys.remove(pattern[i][j]);
                ingredients.add((Object)ingredient);
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
    }

    @NotNull
    private Map<String, Ingredient> deserializeKeys(@NotNull JsonObject keys) {
        HashMap<String, Ingredient> map = new HashMap<String, Ingredient>();
        for (Map.Entry entry : keys.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), this.deserializeIngredient(((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    private void deserializeNonShapedIngredients(@NotNull NonNullList<Ingredient> ingredients, @NotNull JsonArray ingredientsJSON) {
        for (int i = 0; i < ingredientsJSON.size(); ++i) {
            ingredients.add((Object)this.deserializeIngredient(ingredientsJSON.get(i).getAsJsonObject()));
        }
    }

    @NotNull
    Ingredient deserializeIngredient(@NotNull JsonObject ingredient) {
        if (ingredient.has("color_item")) {
            return this.deserializeColorStackList(ingredient);
        }
        if (ingredient.has("color_tag")) {
            return this.deserializeColorTagList(ingredient);
        }
        return Ingredient.m_43938_(Stream.of(Ingredient.m_43919_((JsonObject)ingredient)));
    }

    @NotNull
    private Ingredient deserializeColorStackList(@NotNull JsonObject ingredient) {
        ResourceLocation location = new ResourceLocation(GsonHelper.m_13906_((JsonObject)ingredient, (String)"color_item"));
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(location).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + location + "'"));
        if (!(item instanceof DyeBlockItem)) {
            throw new JsonSyntaxException(location + " is not a DyeBlockItem");
        }
        return new ColorIngredient(new ColorStackList(new ItemStack((ItemLike)item)));
    }

    @NotNull
    private Ingredient deserializeColorTagList(@NotNull JsonObject ingredient) {
        JsonObject color_tag = GsonHelper.m_13930_((JsonObject)ingredient, (String)"color_tag");
        TreeMap<ItemStack, Color> stacks = new TreeMap<ItemStack, Color>(Comparator.comparing(o -> BuiltInRegistries.f_257033_.m_7981_((Object)o.m_41720_())));
        for (Color color : Color.values()) {
            String registry_key = GsonHelper.m_13851_((JsonObject)color_tag, (String)color.m_7912_(), (String)"");
            if (registry_key.isEmpty()) continue;
            ResourceLocation location = new ResourceLocation(registry_key);
            stacks.put(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(location).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + location + "'"))), color);
        }
        return new ColorIngredient(new ColorTagList(stacks));
    }

    @NotNull
    private ItemStack deserializeResult(@NotNull JsonObject result) {
        String registry_key = GsonHelper.m_13906_((JsonObject)result, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(registry_key)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + registry_key + "'"));
        if (!(item instanceof DyeBlockItem)) {
            throw new JsonParseException("Unallowed Recipe Result");
        }
        return new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)result, (String)"count", (int)1));
    }

    @Nullable
    public DyedRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        boolean shaped = buffer.readBoolean();
        int recipeWidth = buffer.m_130242_();
        int recipeHeight = buffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122779_();
        for (int k = 0; k < recipeWidth * recipeHeight; ++k) {
            ingredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack result = buffer.m_130267_();
        return new DyedRecipe(recipeId, ModRecipeSerializersRegisterFactory.DYED, shaped, (NonNullList<Ingredient>)ingredients, result, recipeWidth, recipeHeight);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull DyedRecipe recipe) {
        buffer.writeBoolean(recipe.isShaped());
        buffer.m_130130_(recipe.getRecipeWidth());
        buffer.m_130130_(recipe.getRecipeHeight());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(recipe.getResult());
    }
}

