/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.creative_mod_tabs;

import de.geheimagentnr1.manyideas_core.config.ClientConfig;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.blocks.ModBlocksRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.blocks.ModDebugBlocksRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.dyed.DyeBlockItem;
import de.geheimagentnr1.manyideas_core.elements.items.ModItemsRegisterFactory;
import de.geheimagentnr1.manyideas_core.util.DyeBlockHelper;
import de.geheimagentnr1.minecraft_forge_api.elements.creative_mod_tabs.CreativeModeTabFactory;
import de.geheimagentnr1.minecraft_forge_api.registry.RegistryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ManyIdeasCoreCreativeModeTabFactory
implements CreativeModeTabFactory {
    @NotNull
    private final ClientConfig clientConfig;
    @NotNull
    private final ModBlocksRegisterFactory modBlocksRegisterFactory;
    @NotNull
    private final ModDebugBlocksRegisterFactory modDebugBlocksRegisterFactory;
    @NotNull
    private final ModItemsRegisterFactory modItemsRegisterFactory;

    @NotNull
    public String getRegistryName() {
        return "manyideas_core";
    }

    @NotNull
    public ItemLike getIconItem() {
        return ModBlocksRegisterFactory.TABLE_SAW_DIAMOND;
    }

    @NotNull
    public List<RegistryEntry<Block>> getDisplayBlocks() {
        ArrayList<RegistryEntry<Block>> displayBlocks = new ArrayList<RegistryEntry<Block>>(this.modBlocksRegisterFactory.getBlocks());
        displayBlocks.addAll(this.modDebugBlocksRegisterFactory.getBlocks());
        return displayBlocks;
    }

    @NotNull
    public Stream<ItemStack> buildItemStacksOfBlockRegistryEntry(RegistryEntry<Block> registryEntry) {
        Item item = ((Block)registryEntry.getValue()).m_5456_();
        if (item instanceof DyeBlockItem) {
            if (this.clientConfig.allColorsInItemGroup()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (Color color : Color.values()) {
                    items.add(DyeBlockHelper.createItemStackOfItem(item, color));
                }
                return items.stream();
            }
            return Stream.of(DyeBlockHelper.createItemStackOfItem(item, Color.WHITE));
        }
        return Stream.of(new ItemStack((ItemLike)registryEntry.getValue()));
    }

    @NotNull
    public List<RegistryEntry<Item>> getDisplayItems() {
        return this.modItemsRegisterFactory.getItems();
    }

    public ManyIdeasCoreCreativeModeTabFactory(@NotNull ClientConfig clientConfig, @NotNull ModBlocksRegisterFactory modBlocksRegisterFactory, @NotNull ModDebugBlocksRegisterFactory modDebugBlocksRegisterFactory, @NotNull ModItemsRegisterFactory modItemsRegisterFactory) {
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked non-null but is null");
        }
        if (modBlocksRegisterFactory == null) {
            throw new NullPointerException("modBlocksRegisterFactory is marked non-null but is null");
        }
        if (modDebugBlocksRegisterFactory == null) {
            throw new NullPointerException("modDebugBlocksRegisterFactory is marked non-null but is null");
        }
        if (modItemsRegisterFactory == null) {
            throw new NullPointerException("modItemsRegisterFactory is marked non-null but is null");
        }
        this.clientConfig = clientConfig;
        this.modBlocksRegisterFactory = modBlocksRegisterFactory;
        this.modDebugBlocksRegisterFactory = modDebugBlocksRegisterFactory;
        this.modItemsRegisterFactory = modItemsRegisterFactory;
    }
}

