/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.jei;

import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.recipes.VatRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class VatCategory
extends BaseRecipeCategory<VatRecipe> {
    @Nullable
    protected IRecipeSlotBuilder inputFluidSlot;
    @Nullable
    protected IRecipeSlotBuilder inputItemSlot;
    @Nullable
    protected IRecipeSlotBuilder outputFluidSlot;
    @Nullable
    protected IRecipeSlotBuilder outputItemSlot;

    public VatCategory(RecipeType<VatRecipe> type, IGuiHelper helper) {
        super(type, helper, (IDrawable)helper.createBlankDrawable(118, 26), new ItemStack((ItemLike)FLBlocks.VAT.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VatRecipe recipe, IFocusGroup focuses) {
        this.inputFluidSlot = null;
        this.inputItemSlot = null;
        this.outputFluidSlot = null;
        this.outputItemSlot = null;
        int[] positions = this.slotPositions(recipe);
        List inputFluid = VatCategory.collapse((FluidStackIngredient)recipe.getInputFluid());
        List inputItem = VatCategory.collapse((ItemStackIngredient)recipe.getInputItem());
        FluidStack outputFluid = recipe.getOutputFluid();
        ArrayList<ItemStack> outputItem = new ArrayList<ItemStack>(VatCategory.collapse((List)inputItem, (ItemStackProvider)recipe.getOutputItem()));
        if (!recipe.getJarOutput().m_41619_()) {
            outputItem.add(recipe.getJarOutput());
        }
        if (!inputFluid.isEmpty()) {
            this.inputFluidSlot = builder.addSlot(RecipeIngredientRole.INPUT, inputItem.isEmpty() ? positions[1] : positions[0], 5);
            this.inputFluidSlot.addIngredients(JEIIntegration.FLUID_STACK, inputFluid);
            this.inputFluidSlot.setFluidRenderer(1L, false, 16, 16);
            this.inputFluidSlot.setBackground((IDrawable)this.slot, -1, -1);
        }
        if (!inputItem.isEmpty()) {
            this.inputItemSlot = builder.addSlot(RecipeIngredientRole.INPUT, positions[1], 5);
            this.inputItemSlot.addItemStacks(inputItem);
            this.inputItemSlot.setBackground((IDrawable)this.slot, -1, -1);
        }
        if (!outputFluid.isEmpty()) {
            this.outputFluidSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, positions[2], 5);
            this.outputFluidSlot.addIngredient(JEIIntegration.FLUID_STACK, (Object)outputFluid);
            this.outputFluidSlot.setFluidRenderer(1L, false, 16, 16);
            this.outputFluidSlot.setBackground((IDrawable)this.slot, -1, -1);
        }
        if (!outputItem.isEmpty() && !outputItem.stream().allMatch(ItemStack::m_41619_)) {
            this.outputItemSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, outputFluid.isEmpty() ? positions[2] : positions[3], 5);
            this.outputItemSlot.addItemStacks(outputItem);
            this.outputItemSlot.setBackground((IDrawable)this.slot, -1, -1);
        }
        if (recipe.getOutputItem().dependsOnInput() && this.inputItemSlot != null && this.outputItemSlot != null) {
            builder.createFocusLink(new IIngredientAcceptor[]{this.inputItemSlot, this.outputItemSlot});
        }
    }

    public void draw(VatRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        int arrowPosition = this.arrowPosition(recipe);
        this.arrow.draw(stack, arrowPosition, 5);
        this.arrowAnimated.draw(stack, arrowPosition, 5);
    }

    protected int[] slotPositions(VatRecipe recipe) {
        return new int[]{6, 26, 76, 96};
    }

    protected int arrowPosition(VatRecipe recipe) {
        return 48;
    }
}

